#include "Delay.hh"

Delay::Delay(int pSampleRate, int pChannels) : AudioFilter(pSampleRate, pChannels)
        {
        wetOut=1;
        init_tail(4); // max delay time will be 4 s.
        }

Delay::~Delay()
        {
        }

int Delay::load_data(   char* audioFragment, int audioFragmentSize)
        {
        fragment = audioFragment;
        fragmentSize = audioFragmentSize;
        return 1;
        }

int Delay::prepare()
        {
        return 1;
        }

int Delay::process()
        {
        float delayTime = 0.5; // in seconds
        float releaseFactor = 0.5;
        int delayDelta = (int)(delayTime*sampleRate*channels*sizeof(short));
        // PDEBUG("delayDelta=" << delayDelta);

        char* lastpf = fragment + fragmentSize;
        char* lastpt = tailBuffer + tailSize;


        // mix the current fragment into tail head
        char* pf = fragment;
        char* pt = tailBuffer;
        while (pf < lastpf)
                {
                for (int k=0; k<channels; k++)
                        {
                        short* spf = (short*) pf;
                        short* spt = (short*) pt;
                        short samplef = *(spf);
                        short samplet = *(spt);
                        int nsample = samplet + samplef;
                        CHECK_SAMPLE_OVERLOAD(nsample);
                        *(spt)= (short) nsample;
                        pf+=sizeof(short);
                        pt+=sizeof(short);
                        }
                }

        // copy tail head into current fragment
        memcpy(fragment,tailBuffer,fragmentSize);

        // Mix tail head into a future position of tail
        pt = tailBuffer;
        char* pd = tailBuffer + delayDelta;
        while ((pt<tailBuffer+fragmentSize) && (pd<lastpt))
                {
                for (int k=0; k<channels; k++)
                        {
                        short* spd = (short*) pd;
                        short* spt = (short*) pt;
                        float fsho = (float)(*(spt))*releaseFactor;
                        //if (abs(fsho)<100) fsho=0; // infinite release blocker
                        int nsample =  *(spd) + (short) fsho;
                        CHECK_SAMPLE_OVERLOAD(nsample);
                        *(spd)= (short) nsample;
                        pd+=sizeof(short);
                        pt+=sizeof(short);
                        }
                }


        // just a test
/*        pt = tailBuffer;
        int c = 0;
        int max = 0;
        while (pt<lastpt)
                {
                short sho=(short)*(short*)pt;
                if (c % 1000==0)
                        {
                        printf("%d ",max);
                        max=0;
                        }
                else
                        if (sho>max) max=sho;
                pt+=sizeof(short)*2;
                c++;
                }
        printf("\ntotal=%d\n\n",c);
*/
        // push the tail left
        push_tail(fragmentSize);
        return 1;
        }

//eof
