/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "CurveNode.hh"

CurveNode::CurveNode(Curve* pParentCurve, long long pPos, float  pValue)
        {
        PENTERCONS;
        parentCurve = pParentCurve;
        set_pos(pPos);
        set_value(pValue);
        isHighLighted=false;
        PEXITCONS;
        }

CurveNode::~CurveNode()
        {
        PENTERDES;
        PEXITDES;
        }

void CurveNode::toggle_highlight()
        {
        isHighLighted=!isHighLighted;
        draw();
        }

void CurveNode::set_pos(long long pPos)
        {
        if (pPos<0) pPos = 0;
        pos = pPos;
        }


void CurveNode::set_value(float pValue)
        {
        // (LG) Standard range : -100.0 to + 100.0
	// Each filter "converts" this range to a meanfull value
	// but all them use it as % or track height, when drawing.
	// For example. +100 means the top level, always.
	// -100 means the botton level, always.
	// But, for different filters,the meaning is different depending
	// on What the curve means:
	// in a Gain filter, in its Wet curve, 100 means + 25 dB of gain,
	// and -100 means -inf (mute) gain.
	// In a reverb, 100 mean "all wet", 0 means 50%/50% and -100 means
	// "all dry".
	// So, each filter is responsible to interpret this value.
        if (pValue>100.0) pValue=100.0;
        if (pValue<-100.0) pValue=-100.0;
        value=pValue;
        }



void CurveNode::draw()
        {
	PENTER4;
        FilterController* fc = parentCurve->assocFilterController;
        MustuxDrawable* drawArea = fc->get_drawarea();
        QPainter* painter = drawArea->painter;
	Track* parentTrack = fc->parentChain->assocTrack;

        const int NODE_WIDTH=3;

        if (this->isHighLighted)
                painter->setPen(QColor(0, 255, 0));

        else
                painter->setPen(QColor(0,0,0));

        int baseY = parentTrack->get_baseY();
        int half = parentTrack->get_height()/2;
        int yc = baseY + half;
        int x = parentTrack->parentSong->block_to_xpos(pos);
        int y = yc + (int) (-1*value*half/100);


        // MODE SUPERMARKERS
        /*for (int k=-NODE_WIDTH; k<NODE_WIDTH; k++)
                        {
                        painter->drawLine(x+k, baseY, x, y);
                        painter->drawLine(x+k, floorY, x, y);
                        }
        */

        // MODE CLASSICAL NODE
        int x1=x-(NODE_WIDTH/2);
        int y1=y-(NODE_WIDTH/2);
        painter->drawRect(x1,y1,NODE_WIDTH,NODE_WIDTH);
        drawArea->update(x1,y1,NODE_WIDTH,NODE_WIDTH);
	PEXIT4;
        }

void CurveNode::setup()
        {
        parentCurve->assocFilterController->setupFrontend->show();
        }


//eof
