/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef CURVE_HH
#define CURVE_HH

#include <mustux.h>

class CurveNode;
class FilterController;

class Curve
        {
        public:
                Curve(FilterController* pAssocFilterController, QString pType);
                ~Curve();

                CurveNode* add_node(long long pPos, float pValue);
                void add_node(CurveNode* node);
                CurveNode* get_nearest_node(long long pos);
                void delete_node(CurveNode* node);

                float get_value_at(long long pos);

                CurveNode* get_current_curve_node();

                void show();
                void hide();

                void highlight(int pXpos);
                void activate();
                void deactivate();

		CurveNode* head;
                CurveNode* currentNode;

                QString get_type();

                QString get_schema();

        private :
                bool active;

                FilterController* assocFilterController;

                QString type;

                friend class CurveNode;

        };

#include "../Song.hh"
#include "CurveNode.hh"
#include "FilterController.hh"

#endif
