#include "CompressorController.hh"
#include <mustux.h>

CompressorController::CompressorController(FilterChain* chain )
        : FilterController(chain)
        {
        PENTERCONS;
        PEXITCONS;
        }


CompressorController::~CompressorController()
        {
        for (int i=0; i<MAX_CURVES; i++)
                if (curve[i]) delete curve[i];
        }


void CompressorController::node_setup()
        {
        curve[currentCurveIndex]->get_current_curve_node()->setup();
        }


void CompressorController::setup()
        {
        FilterController::setup();
        }


QString CompressorController::get_type()
        {
        return "Compressor";
        }


void CompressorController::draw()
        {
        PENTER;
        FilterController::draw();
        PEXIT;
        }


int CompressorController::process(char* data, int size)
        {
	float peakPercent = 100.0f;
	float releaseTime = 0.0f;
	float fRatio = 1.0f;
	float ratio = 1.0f;
	/*assocFilter->set_peak_percent(peakPercent);
	assocFilter->set_release_time(releaseTime);
	assocFilter->set_fratio(fRatio);
	assocFilter->set_ratio(ratio);
	*/
        if (assocFilter->load_data(data,size)<0) return -1;
        if (assocFilter->prepare()<0) return -1;
        if (assocFilter->process()<0) return -1;
        return 1;
        }

//eof
