/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef AUDIOFILTER_HH
#define AUDIOFILTER_HH

#define CHECK_SAMPLE_OVERLOAD( x ) x = x < MIN_SAMPLE ? MIN_SAMPLE : x; x = x > MAX_SAMPLE ? MAX_SAMPLE : x;

class AudioFilter
        {
        public :

		static const int MIN_SAMPLE = -32768;
		static const int MAX_SAMPLE = 32767;

                AudioFilter(int pSampleRate, int pChannels);
                virtual ~AudioFilter();

                void set_preview_quality(float value);
                void set_wet_out(float value);
                void set_dry_out(float value);
                void set_pre_gain(float value);
                void set_pos_gain(float value);

                float get_preview_quality();
                float get_wet_out();
                float get_dry_out();
                float get_pre_gain();
                float get_pos_gain();

                virtual int load_data( char* pAudioFragment, int pFragmentSize );
                virtual int prepare();
                virtual int process();

                bool isBypassed;

                /**
                 * When a STOP action is performed, reset the tail and make other proper adjustments.
                 */
                int cleanup();

        protected :

                float previewQuality;
                float wetOut;
                float dryOut;
                float preGain;
                float posGain;


                void init_tail(int secs);
                void push_tail(int size);
                char* tailBuffer;
                int tailSize;

                char* fragment;
                int fragmentSize;

                int sampleRate;
                int channels;
        };





#endif
