/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef TRACKPANEL_HH
#define TRACKPANEL_HH

#include <mustux.h>

/** TrackPanel is not a Widget. It is object that DRAWS on a region of widget to
  * display the track main information, such gain, volume, pan, channel, and so on...
  * the drawArea atribute must be the widget inside the associated Song that will be used
  * to display the contents of the track panel.
    It also has NO properties. All properties comes from the associated Track object.
  */

class Track;

class TrackPanel : public MustuxDrawableRegion
        {

        public :
                TrackPanel(Track* pAssocTrack);
                ~TrackPanel();

                void recreate();
                void draw_axis();
                void update();
                void clear();
                void draw();
                bool is_pointed();
		void set_gain();
		void set_pan();

        private :
                Track* assocTrack;
		QString sid;
		QString sgain;
		QString span;
		float panValue;
		float gainValue;
		
                friend class Track;
        };

#include "Track.hh"

#endif



