/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#include "SplashScreen.hh"
#include <qimage.h>
#include <qapplication.h>

SplashScreen::SplashScreen(QString imageFile)
        {
        splash = new QLabel( 0, "splash", Qt::WDestructiveClose | Qt::WStyle_Customize | Qt::WStyle_NoBorder );
        splash->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
        QImage img;
        img = QImage(imageFile);
        QPixmap pix;
        pix.convertFromImage( img );
        splash->setPixmap(pix);
        splash->adjustSize();
        splash->setCaption( "Protux" );
        QRect r = QApplication::desktop()->geometry();
        splash->move( r.center() - splash->rect().center() );
        splash->show();
        splash->repaint( FALSE );
        QApplication::flushX();
        startTimer(4000);
        }

SplashScreen::~SplashScreen()
        {
        }

void SplashScreen::timerEvent(QTimerEvent *event)
        {
        delete splash;
        killTimers();
        }

//eof




