/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include <qcolor.h>
#include "Spectrogram.hh"
#include <stdio.h>

#define CHANNELS 2 // Spectrogram works using only stereo audio for input. Notice that internal buffers are arrays of shorts.

const int Spectrogram::NBANDS = 20;
const int Spectrogram::bandIndex[32] = { 2 , 3 , 4 , 8 , 10, 12 , 14 ,16 , 20, 24 , 28, 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112, 128 , 160, 192, 224, 256 , 320, 384, 448, 512, 640, 768, 896 , 1024 };

Spectrogram::Spectrogram( int pWidth, int pHeight, QWidget *parent, const char* pName)
            : MustuxDrawable( pWidth , pHeight, parent, pName )
        {
        PENTERCONS;
        fftSize=2048;
        mustuxFft = new MustuxFft(fftSize, MustuxFft::HAMMING_WINDOW);
        scaleFactor = 1.0;
        //setCaption("Protux - Spectrogram");
        updateTimer = new QTimer(this);
        connect( updateTimer, SIGNAL(timeout()), this, SLOT(update()));
        buf = (short*) 0;
        PEXITCONS;
        }


Spectrogram::~Spectrogram()
        {
        PENTERDES;
        delete mustuxFft;
        PEXITDES;
        }


void Spectrogram::set_scale_factor(float f)
        {
        scaleFactor = f;
        }


void Spectrogram::set_data(short* data)
        {
        buf=data;
        }

void Spectrogram::activate()
        {
        updateTimer->start(25);
        }


void Spectrogram::deactivate()
        {
        updateTimer->stop();
        }


void Spectrogram::update()
        {
        clear();
        if (!buf) return;

        float* data = new float[fftSize];     // the input array for fft analisys
        float* levels = new float[fftSize/2]; // the output (frequency domain) levels array. It comes normalized
                                      // from 0.0 to 100.0. This array's size must be always fftSize/2

        // takes just the left channel data to use in fft
        for (int i=0; i<fftSize; i++)
                data[i] = (float) buf[i*2];

        mustuxFft->perform(data,levels);

        for (int i=0; i<NBANDS; i++)
                {
                float le = levels[bandIndex[i]]*scaleFactor;
                if (le>currentLevel[i])
                        currentLevel[i]=le;
                if (currentLevel[i]>0) currentLevel[i]-=1.0 + 5.0*(1.0-currentLevel[i]/100);
                }


        int spectrumMode = 3; // PARAMETRIZE ME
        switch (spectrumMode)
                {
                case 1: // FFT CURVE MODE
                        {
                        painter->setPen(QColor(255,255,255));
                        painter->moveTo(0,height());
                        int levelIndex = 2;
                        int h = height();
                        for (int x=0; x < 100; x++)
                                {
                                float fl = levels[levelIndex] / 100.0;
                                float fy = fl * (float) h ;
                                int y = (int) fy;
                                painter->lineTo(x, h - y);
                                levelIndex+=1;
                                }
                        break;
                        }
                case 2:
                        {
                        painter->setPen(QColor(255,255,255));
                        int levelIndex = 2;
                        int h = height();
                        for (int x=0; x < 100; x++)
                                {
                                float fl = levels[levelIndex] / 100.0;
                                float fy = fl * (float) h ;
                                int y = (int) fy;
                                painter->drawLine(x, h, x , h - y);
                                levelIndex+=1;
                                }
                        break;
                        }
                case 3: // FFT BARS MODE
                        {
                        int bandWidth= width()/NBANDS;
                        int h = height();
                        for (int i=0; i < NBANDS ; i++)
                                {
                                float fl = currentLevel[i] / 100.0;
                                float fy = fl * (float) h ;
                                int y = (int) fy;
                                painter->fillRect(i*bandWidth, h-y, bandWidth, y, QColor(100,100,255));
                                }
                        break;
                        }
                }

                // WAVE MODE -- DO NOT DELETE ME; FIX ME;
        /*
                int y, yc;
                short sample;
                int channels = 2;
                int maxSample = 32768;
                const float f = (float) (height()/channels) / maxSample;

                for (int k=0; k<channels; k++)
                        {
                        yc = height()/4 + height()/2*k;
                        painter->moveTo(0, yc);
                        char* p = buf;
                        for (int x=0; x<fftSize; x++)
                                {
                                sample = *(short*) (p+sizeof(short)*k);
                                y = yc - (int) (f * (float) sample ) ;
                                painter->lineTo(x,y);
                                p+=4;
                                }
                        }
        */

        MustuxDrawable::update();

        delete data;
        delete levels;
        }


// eof

/*




2 = 43.0664

3 = 64.5996




4 = 86.1328

5 = 107.666

6 = 129.199

7 = 150.732




8 = 172.266
9 = 193.799

10 = 215.332
11 = 236.865

12 = 258.398
13 = 279.932

14 = 301.465
15 = 322.998




16 = 344.531
17 = 366.064
18 = 387.598
19 = 409.131

20 = 430.664
21 = 452.197
22 = 473.73
23 = 495.264

24 = 516.797
25 = 538.33
26 = 559.863
27 = 581.396

28 = 602.93
29 = 624.463
30 = 645.996
31 = 667.529



32 = 689.062
33 = 710.596
34 = 732.129
35 = 753.662
36 = 775.195
37 = 796.729
38 = 818.262
39 = 839.795

40 = 861.328
41 = 882.861
42 = 904.395
43 = 925.928
44 = 947.461
45 = 968.994
46 = 990.527
47 = 1012.06

48 = 1033.59
49 = 1055.13
50 = 1076.66
51 = 1098.19
52 = 1119.73
53 = 1141.26
54 = 1162.79
55 = 1184.33

56 = 1205.86
57 = 1227.39
58 = 1248.93
59 = 1270.46
60 = 1291.99
61 = 1313.53
62 = 1335.06
63 = 1356.59



64 = 1378.12
65 = 1399.66
66 = 1421.19
67 = 1442.72
68 = 1464.26
69 = 1485.79
70 = 1507.32
71 = 1528.86
72 = 1550.39
73 = 1571.92
74 = 1593.46
75 = 1614.99
76 = 1636.52
77 = 1658.06
78 = 1679.59
79 = 1701.12

80 = 1722.66
81 = 1744.19
82 = 1765.72
83 = 1787.26
84 = 1808.79
85 = 1830.32
86 = 1851.86
87 = 1873.39
88 = 1894.92
89 = 1916.46
90 = 1937.99
91 = 1959.52
92 = 1981.05
93 = 2002.59
94 = 2024.12
95 = 2045.65

96 = 2067.19
97 = 2088.72
98 = 2110.25
99 = 2131.79
100 = 2153.32
101 = 2174.85
102 = 2196.39
103 = 2217.92
104 = 2239.45
105 = 2260.99
106 = 2282.52
107 = 2304.05
108 = 2325.59
109 = 2347.12
110 = 2368.65
111 = 2390.19

112 = 2411.72
113 = 2433.25
114 = 2454.79
115 = 2476.32
116 = 2497.85
117 = 2519.38
118 = 2540.92
119 = 2562.45
120 = 2583.98
121 = 2605.52
122 = 2627.05
123 = 2648.58
124 = 2670.12
125 = 2691.65
126 = 2713.18
127 = 2734.72



128 = 2756.25
129 = 2777.78
130 = 2799.32
131 = 2820.85
132 = 2842.38
133 = 2863.92
134 = 2885.45
135 = 2906.98
136 = 2928.52
137 = 2950.05
138 = 2971.58
139 = 2993.12
140 = 3014.65
141 = 3036.18
142 = 3057.71
143 = 3079.25
144 = 3100.78
145 = 3122.31
146 = 3143.85
147 = 3165.38
148 = 3186.91
149 = 3208.45
150 = 3229.98
151 = 3251.51
152 = 3273.05
153 = 3294.58
154 = 3316.11
155 = 3337.65
156 = 3359.18
157 = 3380.71
158 = 3402.25
159 = 3423.78

160 = 3445.31
161 = 3466.85
162 = 3488.38
163 = 3509.91
164 = 3531.45
165 = 3552.98
166 = 3574.51
167 = 3596.04
168 = 3617.58
169 = 3639.11
170 = 3660.64
171 = 3682.18
172 = 3703.71
173 = 3725.24
174 = 3746.78
175 = 3768.31
176 = 3789.84
177 = 3811.38
178 = 3832.91
179 = 3854.44
180 = 3875.98
181 = 3897.51
182 = 3919.04
183 = 3940.58
184 = 3962.11
185 = 3983.64
186 = 4005.18
187 = 4026.71
188 = 4048.24
189 = 4069.78
190 = 4091.31
191 = 4112.84

192 = 4134.38
193 = 4155.91
194 = 4177.44
195 = 4198.97
196 = 4220.51
197 = 4242.04
198 = 4263.57
199 = 4285.11
200 = 4306.64
201 = 4328.17
202 = 4349.71
203 = 4371.24
204 = 4392.77
205 = 4414.31
206 = 4435.84
207 = 4457.37
208 = 4478.91
209 = 4500.44
210 = 4521.97
211 = 4543.51
212 = 4565.04
213 = 4586.57
214 = 4608.11
215 = 4629.64
216 = 4651.17
217 = 4672.71
218 = 4694.24
219 = 4715.77
220 = 4737.3
221 = 4758.84
222 = 4780.37
223 = 4801.9

224 = 4823.44
225 = 4844.97
226 = 4866.5
227 = 4888.04
228 = 4909.57
229 = 4931.1
230 = 4952.64
231 = 4974.17
232 = 4995.7
233 = 5017.24
234 = 5038.77
235 = 5060.3
236 = 5081.84
237 = 5103.37
238 = 5124.9
239 = 5146.44
240 = 5167.97
241 = 5189.5
242 = 5211.04
243 = 5232.57
244 = 5254.1
245 = 5275.63
246 = 5297.17
247 = 5318.7
248 = 5340.23
249 = 5361.77
250 = 5383.3
251 = 5404.83
252 = 5426.37
253 = 5447.9
254 = 5469.43
255 = 5490.97




256 = 5512.5
257 = 5534.03
258 = 5555.57
259 = 5577.1
260 = 5598.63
261 = 5620.17
262 = 5641.7
263 = 5663.23
264 = 5684.77
265 = 5706.3
266 = 5727.83
267 = 5749.37
268 = 5770.9
269 = 5792.43
270 = 5813.96
271 = 5835.5
272 = 5857.03
273 = 5878.56
274 = 5900.1
275 = 5921.63
276 = 5943.16
277 = 5964.7
278 = 5986.23
279 = 6007.76
280 = 6029.3
281 = 6050.83
282 = 6072.36
283 = 6093.9
284 = 6115.43
285 = 6136.96
286 = 6158.5
287 = 6180.03
288 = 6201.56
289 = 6223.1
290 = 6244.63
291 = 6266.16
292 = 6287.7
293 = 6309.23
294 = 6330.76
295 = 6352.29
296 = 6373.83
297 = 6395.36
298 = 6416.89
299 = 6438.43
300 = 6459.96
301 = 6481.49
302 = 6503.03
303 = 6524.56
304 = 6546.09
305 = 6567.63
306 = 6589.16
307 = 6610.69
308 = 6632.23
309 = 6653.76
310 = 6675.29
311 = 6696.83
312 = 6718.36
313 = 6739.89
314 = 6761.43
315 = 6782.96
316 = 6804.49
317 = 6826.03
318 = 6847.56
319 = 6869.09



320 = 6890.62
321 = 6912.16
322 = 6933.69
323 = 6955.22
324 = 6976.76
325 = 6998.29
326 = 7019.82
327 = 7041.36
328 = 7062.89
329 = 7084.42
330 = 7105.96
331 = 7127.49
332 = 7149.02
333 = 7170.56
334 = 7192.09
335 = 7213.62
336 = 7235.16
337 = 7256.69
338 = 7278.22
339 = 7299.76
340 = 7321.29
341 = 7342.82
342 = 7364.36
343 = 7385.89
344 = 7407.42
345 = 7428.96
346 = 7450.49
347 = 7472.02
348 = 7493.55
349 = 7515.09
350 = 7536.62
351 = 7558.15
352 = 7579.69
353 = 7601.22
354 = 7622.75
355 = 7644.29
356 = 7665.82
357 = 7687.35
358 = 7708.89
359 = 7730.42
360 = 7751.95
361 = 7773.49
362 = 7795.02
363 = 7816.55
364 = 7838.09
365 = 7859.62
366 = 7881.15
367 = 7902.69
368 = 7924.22
369 = 7945.75
370 = 7967.29
371 = 7988.82
372 = 8010.35
373 = 8031.88
374 = 8053.42
375 = 8074.95
376 = 8096.48
377 = 8118.02
378 = 8139.55
379 = 8161.08
380 = 8182.62
381 = 8204.15
382 = 8225.68
383 = 8247.22

384 = 8268.75
385 = 8290.28
386 = 8311.82
387 = 8333.35
388 = 8354.88
389 = 8376.42
390 = 8397.95
391 = 8419.48
392 = 8441.02
393 = 8462.55
394 = 8484.08
395 = 8505.62
396 = 8527.15
397 = 8548.68
398 = 8570.21
399 = 8591.75
400 = 8613.28
401 = 8634.81
402 = 8656.35
403 = 8677.88
404 = 8699.41
405 = 8720.95
406 = 8742.48
407 = 8764.01
408 = 8785.55
409 = 8807.08
410 = 8828.61
411 = 8850.15
412 = 8871.68
413 = 8893.21
414 = 8914.75
415 = 8936.28
416 = 8957.81
417 = 8979.35
418 = 9000.88
419 = 9022.41
420 = 9043.95
421 = 9065.48
422 = 9087.01
423 = 9108.54
424 = 9130.08
425 = 9151.61
426 = 9173.14
427 = 9194.68
428 = 9216.21
429 = 9237.74
430 = 9259.28
431 = 9280.81
432 = 9302.34
433 = 9323.88
434 = 9345.41
435 = 9366.94
436 = 9388.48
437 = 9410.01
438 = 9431.54
439 = 9453.08
440 = 9474.61
441 = 9496.14
442 = 9517.68
443 = 9539.21
444 = 9560.74
445 = 9582.28
446 = 9603.81
447 = 9625.34

448 = 9646.88
449 = 9668.41
450 = 9689.94
451 = 9711.47
452 = 9733.01
453 = 9754.54
454 = 9776.07
455 = 9797.61
456 = 9819.14
457 = 9840.67
458 = 9862.21
459 = 9883.74
460 = 9905.27
461 = 9926.81
462 = 9948.34
463 = 9969.87
464 = 9991.41
465 = 10012.9
466 = 10034.5
467 = 10056
468 = 10077.5
469 = 10099.1
470 = 10120.6
471 = 10142.1
472 = 10163.7
473 = 10185.2
474 = 10206.7
475 = 10228.3
476 = 10249.8
477 = 10271.3
478 = 10292.9
479 = 10314.4
480 = 10335.9
481 = 10357.5
482 = 10379
483 = 10400.5
484 = 10422.1
485 = 10443.6
486 = 10465.1
487 = 10486.7
488 = 10508.2
489 = 10529.7
490 = 10551.3
491 = 10572.8
492 = 10594.3
493 = 10615.9
494 = 10637.4
495 = 10658.9
496 = 10680.5
497 = 10702
498 = 10723.5
499 = 10745.1
500 = 10766.6
501 = 10788.1
502 = 10809.7
503 = 10831.2
504 = 10852.7
505 = 10874.3
506 = 10895.8
507 = 10917.3
508 = 10938.9
509 = 10960.4
510 = 10981.9
511 = 11003.5




512 = 11025
513 = 11046.5
514 = 11068.1
515 = 11089.6
516 = 11111.1
517 = 11132.7
518 = 11154.2
519 = 11175.7
520 = 11197.3
521 = 11218.8
522 = 11240.3
523 = 11261.9
524 = 11283.4
525 = 11304.9
526 = 11326.5
527 = 11348
528 = 11369.5
529 = 11391.1
530 = 11412.6
531 = 11434.1
532 = 11455.7
533 = 11477.2
534 = 11498.7
535 = 11520.3
536 = 11541.8
537 = 11563.3
538 = 11584.9
539 = 11606.4
540 = 11627.9
541 = 11649.5
542 = 11671
543 = 11692.5
544 = 11714.1
545 = 11735.6
546 = 11757.1
547 = 11778.7
548 = 11800.2
549 = 11821.7
550 = 11843.3
551 = 11864.8
552 = 11886.3
553 = 11907.9
554 = 11929.4
555 = 11950.9
556 = 11972.5
557 = 11994
558 = 12015.5
559 = 12037.1
560 = 12058.6
561 = 12080.1
562 = 12101.7
563 = 12123.2
564 = 12144.7
565 = 12166.3
566 = 12187.8
567 = 12209.3
568 = 12230.9
569 = 12252.4
570 = 12273.9
571 = 12295.5
572 = 12317
573 = 12338.5
574 = 12360.1
575 = 12381.6
576 = 12403.1
577 = 12424.7
578 = 12446.2
579 = 12467.7
580 = 12489.3
581 = 12510.8
582 = 12532.3
583 = 12553.9
584 = 12575.4
585 = 12596.9
586 = 12618.5
587 = 12640
588 = 12661.5
589 = 12683.1
590 = 12704.6
591 = 12726.1
592 = 12747.7
593 = 12769.2
594 = 12790.7
595 = 12812.3
596 = 12833.8
597 = 12855.3
598 = 12876.9
599 = 12898.4
600 = 12919.9
601 = 12941.5
602 = 12963
603 = 12984.5
604 = 13006.1
605 = 13027.6
606 = 13049.1
607 = 13070.7
608 = 13092.2
609 = 13113.7
610 = 13135.3
611 = 13156.8
612 = 13178.3
613 = 13199.9
614 = 13221.4
615 = 13242.9
616 = 13264.5
617 = 13286
618 = 13307.5
619 = 13329.1
620 = 13350.6
621 = 13372.1
622 = 13393.7
623 = 13415.2
624 = 13436.7
625 = 13458.3
626 = 13479.8
627 = 13501.3
628 = 13522.9
629 = 13544.4
630 = 13565.9
631 = 13587.5
632 = 13609
633 = 13630.5
634 = 13652.1
635 = 13673.6
636 = 13695.1
637 = 13716.7
638 = 13738.2
639 = 13759.7

640 = 13781.2
641 = 13802.8
642 = 13824.3
643 = 13845.8
644 = 13867.4
645 = 13888.9
646 = 13910.4
647 = 13932
648 = 13953.5
649 = 13975
650 = 13996.6
651 = 14018.1
652 = 14039.6
653 = 14061.2
654 = 14082.7
655 = 14104.2
656 = 14125.8
657 = 14147.3
658 = 14168.8
659 = 14190.4
660 = 14211.9
661 = 14233.4
662 = 14255
663 = 14276.5
664 = 14298
665 = 14319.6
666 = 14341.1
667 = 14362.6
668 = 14384.2
669 = 14405.7
670 = 14427.2
671 = 14448.8
672 = 14470.3
673 = 14491.8
674 = 14513.4
675 = 14534.9
676 = 14556.4
677 = 14578
678 = 14599.5
679 = 14621
680 = 14642.6
681 = 14664.1
682 = 14685.6
683 = 14707.2
684 = 14728.7
685 = 14750.2
686 = 14771.8
687 = 14793.3
688 = 14814.8
689 = 14836.4
690 = 14857.9
691 = 14879.4
692 = 14901
693 = 14922.5
694 = 14944
695 = 14965.6
696 = 14987.1
697 = 15008.6
698 = 15030.2
699 = 15051.7
700 = 15073.2
701 = 15094.8
702 = 15116.3
703 = 15137.8
704 = 15159.4
705 = 15180.9
706 = 15202.4
707 = 15224
708 = 15245.5
709 = 15267
710 = 15288.6
711 = 15310.1
712 = 15331.6
713 = 15353.2
714 = 15374.7
715 = 15396.2
716 = 15417.8
717 = 15439.3
718 = 15460.8
719 = 15482.4
720 = 15503.9
721 = 15525.4
722 = 15547
723 = 15568.5
724 = 15590
725 = 15611.6
726 = 15633.1
727 = 15654.6
728 = 15676.2
729 = 15697.7
730 = 15719.2
731 = 15740.8
732 = 15762.3
733 = 15783.8
734 = 15805.4
735 = 15826.9
736 = 15848.4
737 = 15870
738 = 15891.5
739 = 15913
740 = 15934.6
741 = 15956.1
742 = 15977.6
743 = 15999.2
744 = 16020.7
745 = 16042.2
746 = 16063.8
747 = 16085.3
748 = 16106.8
749 = 16128.4
750 = 16149.9
751 = 16171.4
752 = 16193
753 = 16214.5
754 = 16236
755 = 16257.6
756 = 16279.1
757 = 16300.6
758 = 16322.2
759 = 16343.7
760 = 16365.2
761 = 16386.8
762 = 16408.3
763 = 16429.8
764 = 16451.4
765 = 16472.9
766 = 16494.4
767 = 16516

768 = 16537.5
769 = 16559
770 = 16580.6
771 = 16602.1
772 = 16623.6
773 = 16645.2
774 = 16666.7
775 = 16688.2
776 = 16709.8
777 = 16731.3
778 = 16752.8
779 = 16774.4
780 = 16795.9
781 = 16817.4
782 = 16839
783 = 16860.5
784 = 16882
785 = 16903.6
786 = 16925.1
787 = 16946.6
788 = 16968.2
789 = 16989.7
790 = 17011.2
791 = 17032.8
792 = 17054.3
793 = 17075.8
794 = 17097.4
795 = 17118.9
796 = 17140.4
797 = 17162
798 = 17183.5
799 = 17205
800 = 17226.6
801 = 17248.1
802 = 17269.6
803 = 17291.2
804 = 17312.7
805 = 17334.2
806 = 17355.8
807 = 17377.3
808 = 17398.8
809 = 17420.4
810 = 17441.9
811 = 17463.4
812 = 17485
813 = 17506.5
814 = 17528
815 = 17549.6
816 = 17571.1
817 = 17592.6
818 = 17614.2
819 = 17635.7
820 = 17657.2
821 = 17678.8
822 = 17700.3
823 = 17721.8
824 = 17743.4
825 = 17764.9
826 = 17786.4
827 = 17808
828 = 17829.5
829 = 17851
830 = 17872.6
831 = 17894.1
832 = 17915.6
833 = 17937.2
834 = 17958.7
835 = 17980.2
836 = 18001.8
837 = 18023.3
838 = 18044.8
839 = 18066.4
840 = 18087.9
841 = 18109.4
842 = 18131
843 = 18152.5
844 = 18174
845 = 18195.6
846 = 18217.1
847 = 18238.6
848 = 18260.2
849 = 18281.7
850 = 18303.2
851 = 18324.8
852 = 18346.3
853 = 18367.8
854 = 18389.4
855 = 18410.9
856 = 18432.4
857 = 18454
858 = 18475.5
859 = 18497
860 = 18518.6
861 = 18540.1
862 = 18561.6
863 = 18583.2
864 = 18604.7
865 = 18626.2
866 = 18647.8
867 = 18669.3
868 = 18690.8
869 = 18712.4
870 = 18733.9
871 = 18755.4
872 = 18777
873 = 18798.5
874 = 18820
875 = 18841.6
876 = 18863.1
877 = 18884.6
878 = 18906.2
879 = 18927.7
880 = 18949.2
881 = 18970.8
882 = 18992.3
883 = 19013.8
884 = 19035.4
885 = 19056.9
886 = 19078.4
887 = 19100
888 = 19121.5
889 = 19143
890 = 19164.6
891 = 19186.1
892 = 19207.6
893 = 19229.2
894 = 19250.7
895 = 19272.2

896 = 19293.8
897 = 19315.3
898 = 19336.8
899 = 19358.3
900 = 19379.9
901 = 19401.4
902 = 19422.9
903 = 19444.5
904 = 19466
905 = 19487.5
906 = 19509.1
907 = 19530.6
908 = 19552.1
909 = 19573.7
910 = 19595.2
911 = 19616.7
912 = 19638.3
913 = 19659.8
914 = 19681.3
915 = 19702.9
916 = 19724.4
917 = 19745.9
918 = 19767.5
919 = 19789
920 = 19810.5
921 = 19832.1
922 = 19853.6
923 = 19875.1
924 = 19896.7
925 = 19918.2
926 = 19939.7
927 = 19961.3
928 = 19982.8
929 = 20004.3
930 = 20025.9
931 = 20047.4
932 = 20068.9
933 = 20090.5
934 = 20112
935 = 20133.5
936 = 20155.1
937 = 20176.6
938 = 20198.1
939 = 20219.7
940 = 20241.2
941 = 20262.7
942 = 20284.3
943 = 20305.8
944 = 20327.3
945 = 20348.9
946 = 20370.4
947 = 20391.9
948 = 20413.5
949 = 20435
950 = 20456.5
951 = 20478.1
952 = 20499.6
953 = 20521.1
954 = 20542.7
955 = 20564.2
956 = 20585.7
957 = 20607.3
958 = 20628.8
959 = 20650.3
960 = 20671.9
961 = 20693.4
962 = 20714.9
963 = 20736.5
964 = 20758
965 = 20779.5
966 = 20801.1
967 = 20822.6
968 = 20844.1
969 = 20865.7
970 = 20887.2
971 = 20908.7
972 = 20930.3
973 = 20951.8
974 = 20973.3
975 = 20994.9
976 = 21016.4
977 = 21037.9
978 = 21059.5
979 = 21081
980 = 21102.5
983 = 21167.1
984 = 21188.7
985 = 21210.2
986 = 21231.7
987 = 21253.3
988 = 21274.8
989 = 21296.3
990 = 21317.9
991 = 21339.4
992 = 21360.9
993 = 21382.5
994 = 21404
995 = 21425.5
996 = 21447.1
997 = 21468.6
998 = 21490.1
999 = 21511.7
1000 = 21533.2
1001 = 21554.7
1002 = 21576.3
1003 = 21597.8
1004 = 21619.3
1005 = 21640.9
1006 = 21662.4
1007 = 21683.9
1008 = 21705.5
1009 = 21727
1010 = 21748.5
1011 = 21770.1
1012 = 21791.6
1013 = 21813.1
1014 = 21834.7
1015 = 21856.2
1016 = 21877.7
1017 = 21899.3
1018 = 21920.8
1019 = 21942.3
1020 = 21963.9
1021 = 21985.4
1022 = 22006.9
1023 = 22028.5

*/


