/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef SONG_HH
#define SONG_HH

#include <qwidget.h>
#include <qlayout.h>
#include <qprogressbar.h>

#include <mustux.h>

class AudioSourcesList;
class Project;
class Track;
class TrackPanel;
class Audio;
class Mixer;
class Track;
class AudioClip;
class Spectrogram;
class CursorManager;
class TrackPanelsArea;
class TracksArea;
class FilterSelector;
class FilterChain;
class FilterController;
class BusSelector;
class BusMonitor;
class SongPropertiesDialog;
class MtaRegion;

class Song : public QWidget
	{
	Q_OBJECT

	public:
		static const int MAX_TRACKS = 32;
		static const int JOG_NONE = 0;
		static const int JOG_DRAG = 1;
		static const int JOG_ZOOM = 2;
		static const int JOG_SHUTTLE = 3;
		static const int JOG_EDGE = 4;
		static const int JOG_GAIN = 5;
		static const int JOG_PAN = 6;
		static const int JOG_GAIN_AND_PAN = 9;
		static const int JOG_VERTICAL_SCROLL = 10;
		static const int JOG_FADE_IN = 11;
		static const int JOG_FADE_OUT = 12;
		static const int JOG_FADE_BOTH = 13;
		static const int JOG_CLIP_GAIN = 14;
		static const int JOG_CREATE_REGION = 15;
		static const int JOG_CROP = 16;
		static const int LEFT_EDGE = 1;
		static const int RIGHT_EDGE = 2;
		static const int BOTH_EDGES = 3;
		static const int SELECTION_SINGLE = 0;
		static const int SELECTION_ADD = 1;
		static const int SELECTION_REMOVE = 2;
		static const int SELECTION_REGION = 3;
		static const int SELECTION_ALL = 4;
		static const int SELECTION_NONE = 5;
		static const int SELECTION_INVERSE = 6;
		static const int SELECTION_ADD_REGION = 7;
		static const int SELECTION_REMOVE_REGION = 8;
		static const int SELECTION_DIALOG = 9;
		static const int EDITING_MODE_NORMAL = 1;
		static const int EDITING_MODE_TRACK_CURVES = 2;
		static const int GO_MODE_NORMAL = 1;
		static const int GO_MODE_REGIONS = 2;
		static const int GO_MODE_LOOP_REGIONS = 3;
		static const int RENDER_MODE_NORMAL = 1;
		static const int RENDER_MODE_REGIONS = 2;

		Song(int pMyNumber, Project* pParentProject, QWidget* parent, int pRate=-1, int pBithDepth=-1);
		~Song();

		// general methods
		Project* get_parent_project();
		AudioSourcesList* get_asl();
		MustuxDrawable* get_tracks_area();
		MustuxDrawable* get_track_panels_area();
		MustuxLcd* get_default_lcd();

		int process_jmb_action(MustuxJogMouseBoardMessage* m);
		int load();
		int save();
		int build(int tracksToCreate);
		int init();
		int render(int mode = RENDER_MODE_NORMAL, bool toFile = true);
		int render(QString filename);
		int toggle_go(int goMode);
		int get_status();
		int get_rate();
		int get_bit_depth();
		int get_block_size();
		void change_settings(int pRate, int pBitDepht);
		int update_properties();


		// track methods
		void         set_active_track(int trackNumber);
		int          get_active_track_number();
		Track*       get_active_track();
		Track*       get_track(int trackNumber);
		TrackPanel*  get_active_track_panel();
		Track*       get_track_under_mouse();
		Track*       get_track_under_y (int y);
		TrackPanel*  get_track_panel_under_y (int y);
		int          add_track();
		int          add_track(int trackNumber);
		int          delete_track();
		int          delete_track(int trackNumber);

		// Song atributes methods
		void set_artists(QString pArtistis);
		void set_master_gain(float pMasterGain);
		void set_title(QString sTitle);
		QString get_title();
		int get_mynumber();
		QString get_artists();
		float get_master_gain();

		// Audio Methods
		int import_audio(QString filename, QProgressBar *monitorProgressBar = 0 );
		void cancel_import_audio();
		void add_audio_source(Audio* pAudio);
		void delete_audio_source(Audio* pAudio);

		// Audio clips
		AudioClip* create_clip(QString audiofileRootdir, QString filename, QProgressBar *monitorProgressBar = 0);
		AudioClip* create_clip(Audio* au, bool isTake=false);
		AudioClip* create_clip(Audio* au, bool isTake, Track* t, long long insertPos);
		AudioClip* get_clip_under_XY(int x, int y);
		int remove_all_clips_for_audio(Audio* a);

		// vertical stuff
		int get_mta_baseY();
		int get_floorY();

		// cursors
		void disable_cursors();
		void enable_cursors();

		// Actions
		void recreate();
		void recreate_mta();	//Added By Remon
		void recreate_locator();
		void touch();
		void touch_x(int x);
		void touch_track(int trackNumber);
		void touch_in_active_track();
		void touch_in_active_track(int x);
		void touch_in_active_track_panel(); // DEPRECATED
		void update_pan(int x);
		void update_gain(int y);
		void jog_gain(int track, int mouseY);
		void jog_pan(int track, int mouseX);
		void jog_gain_pan(int track, int mouseX, int mouseY);
		void jog_vertical_scroll(int mouseY);
		int split();
		int mute();
		int solo();
		int select(int selectionType, int x, int y);
		int process_delete();
		int drag(bool pIsCopying, int mouseX, int mouseY);
		int drag_edge(int mode, int mouseX);
		int jog_fade(bool in, bool out);
		void update_jog_fade(int x, int y);

		void jog_zoom(int mouseX, int mouseY);
		void update_jog_zoom(int x, int y);
		void update_shuttle_factor(int x);
		void update_drag_edge(int x, int y);
		bool any_track_armed();
		void jog_vertical_scroll();	//not used at the moment?
		void update_vertical_scroll(int y);
		void set_hzoom_level(int level);
		void hzoom_in();
		void hzoom_out();
		void vzoom_in();
		void vzoom_out();
		int get_hzoom();
		int get_vzoom();
		int get_zoom_step();
		void goto_begin();
		void goto_end();
		void center();
		void shuttle();
		void scroll_left(int amount);
		void scroll_right(int amount);
		void scroll_down();
		void scroll_up();
		void set_first_block(long long pos);
		void set_work_at(long long pos);
		void update_last_block();

		void jog_crop(bool type);
		void update_jog_crop(int x);

		void create_region_start(int xpos);
		void create_region_end(int xpos);
		void jog_create_region();
		void delete_region_under_x(int xpos);
		void update_jog_create_region();
		void set_progress_timer(bool start);


		// other methods
		void clear_root_space();
		int get_total_tracks();
		QString get_capture_dir();
		QString get_sources_dir();
		QString get_mta_schema();
		void set_output_spectrogram(Spectrogram* spectrogram);
		void info(QString message);
		void info(QString message, int line);
		void show_zoom_info();
		int get_editing_mode();
		void set_editing_mode();
		int block_to_xpos(long long block);
		long long xpos_to_block(int xpos);
		long long get_first_block();
		long long get_last_block();
		long long get_working_block();
		long long get_playing_block();
		int get_playing_xpos();
		int get_mouse_x();
		int get_mouse_y();
		int get_clips_count_for_audio(Audio* a);
		bool is_snap_on();
		void toggle_snap();
		BusMonitor* get_bus_monitor();
		Mixer* get_mixer();
		void add_mta_region(MtaRegion* m);

		SongPropertiesDialog* propertiesDialog;
		long long workingBlock;
		long long firstBlock;
		long long lastBlock;
		bool changed;
		bool isSomePeakBuilding;
		bool cropMode; // IN (true) or OUT (false)
		int peakBuildCount;

	protected:

		Project* parentProject;
		TrackPanelsArea* trackPanelsArea;
		TracksArea* tracksArea;
		AudioSourcesList* audioSourcesList;
		CursorManager* cursorManager;
		Mixer* mixer;
		Track* track[MAX_TRACKS];
		TrackPanel* trackPanel[MAX_TRACKS];
		AudioClip* workingClip;
		Track* volatileTrack;

		int rate;
		int bitDepth;

		QTimer* shuttleTimer;
		QTimer* updateProgressTimer;
		QTimer* BusMonitorRecreateTimer;

		QString artists;
		QString title;
		float masterGain;
		int myNumber;
		int numTracks;
		int activeTrackNumber;

		QString rootDir;
		QString audioSourcesDir;
		QString captureDir;
		QString mtaSchemaFilename;

		int jogMode;
		int takeNumber;
		int hzoom;
		int draggingEdge;
		int shuttleFactor;
		int jogZoomTotalX;
		int jogZoomTotalY;
		int lastJogZoomXFactor;
		int baseJogZoomXFactor;

		int verticalJogZoomLastY;
		int verticalScrollTotalHeight;

		bool isCopying;
		bool isSnapOn;
		bool cancelImportAudio;
		int gainingTrack;
		int origX;
		int origY;

		int mtaBaseY;

		long long playBlocksOffset;
		long long origBlockL;
		long long origBlockR;
		float origGain;
		float origPan;

		int editingMode;

		MtaRegion* regionList;

		void resizeEvent(QResizeEvent* e);
		void mouseMoveEvent(QMouseEvent* e);
		void recreate_tracks();
		void recreate_panels();

		int snapped_x(int x);

		FilterSelector* filterSelector;
		BusSelector* busSelector;


		friend class Mixer;
		friend class Slice;
		friend class TrackPanel;
		friend class Track;
		friend class AudioClip;
		friend class CursorManager;
		friend class TracksArea;
		friend class TrackPanelsArea;
		friend class FilterController;
		friend class SongPropertiesDialog;
		friend class FilterChain;


	public slots :
		void update_shuttle();
		void update_progress();
		void update_busmonitor();
		void cleanupEventFilter(); // Just to avoid the warning. See the comment in the implementation


	};



#include "Project.hh"
#include "Track.hh"
#include "TrackPanel.hh"
#include "Mixer.hh"
#include "Audio.hh"
#include "AudioClip.hh"
#include "AudioSourcesList.hh"
#include "Spectrogram.hh"
#include "CursorManager.hh"
#include "TracksArea.hh"
#include "TrackPanelsArea.hh"
#include "filters/Filters.hh"
#include "filters/FilterChain.hh"
#include "BusSelector.hh"
#include "BusMonitor.hh"
#include "SongPropertiesDialog.hh"
#include "MtaRegion.hh"

#endif



//eof
