/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef PEAK_HH
#define PEAK_HH

#include <mustux.h>
#include <stdio.h>

#include <qprogressbar.h>
#include <qthread.h>

class Audio;
class Peak;
class AudioClip;
class Song;

class PeakBuildThread : public QThread
	{
	public:
		PeakBuildThread(Peak* peak);
                Peak* peak;
		void run();
	};


class Peak : public MustuxEngine
        {
        Q_OBJECT
        public:
                Peak(Song* pParentSong);
                ~Peak();

                /** Instantiate a Peak Object and generate RAM buffers containing the peak images for
                *  zoom levels equal or greater than 6. Zoom levels between 1 and 5 uses "real-peak"
                *  images (peaks which are read direct from the audio file);
                */
                int build(Audio* audiosource, QProgressBar *monitorProgressBar = 0);

                /** Deallocate memory resources allocated by build() */
                int unbuild();

                /** Receives an empty buffer and fills it with peaks, according to the zoom level passed. */
                int fill_buffer(char* bufferToFill, long long startBlock, int numBlocksToFill , int hzoom);

                /** Display information about the RAM buffers on the console */
                void show_info();

                /** Save the ram buffers images to a .peak file */
                int save();

                /** Load the ram buffers from .peak file previously saved*/
                int load();

		/** Start build within a thread returns value < 1 when something failed */
		int threadedBuild();

		/** Receives all audio samples in chunks (buffer) with size 'bufferSize', calculate peak's on the fly */
		int process_samples_from_buffer(char* buffer, int bufferSize);

		/** Initialize peak atributes for on the fly peak building */
		void init(Audio* audioSource);

		/** Get's the progress of peak building (0-100) */
		int get_progress();

		static const int MAX_ZOOM_LEVELS=31;
                static const int MAX_ZOOM_USING_SOURCEFILE;
                static const int zoomStep[MAX_ZOOM_LEVELS];


	private :


		Song* parentSong;
                Audio* audioSource;
		AudioClip* audioClip;
                MustuxAudioFileFormat* audioSourceFile;

                char* RAMBuffer[MAX_ZOOM_LEVELS];
                long long RAMBufferSize[MAX_ZOOM_LEVELS];
                char* tempRAMBuffer;
		char* RAMBufferHzoomNine;
		char* RAMBufferHzoomTen;
		int RAMBufferHzoomNineSize;
		int RAMBufferHzoomTenSize;
		int totalRAMBufferSize;
		int posInRAMBufferHzoomNine;
		int posInRAMBufferHzoomTen;
		char* peakValueHzoomNine;
		char* peakValueHzoomTen;
		int resolutionHzoomNine;
		int resolutionHzoomTen;
		bool buildOnTheFly;
		bool peaksAvailable;
		QProgressBar* monitorProgressBar;
		int progress;
                int channels;

		PeakBuildThread* peakBuildThread;

        };

#include "Audio.hh"
#include "AudioClip.hh"
#include "Song.hh"
#endif




//eof

