/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef MIXER_HH
#define MIXER_HH

#include <mustux.h>
#include <qtimer.h>
#include <qthread.h>

class Song;
class GoThread;
class ListenerThread;
class Track;
class MtaRegion;

/**
 * This is the new Mixer Engine. It can Play the MTA, Rec on
   armed tracks in MTA, play and rec at the same time, and other
   many common actions found on Multitrack applications.
   It supports mono and stereo files from audio clips present in MTA.
   but the RATE and the BITDEPTH are still fixed to the song's properties.
   The reason is that if you support multiple rates/bitdepths
   the engine becomes so complex that lost most of its performance.
   Besides that, normally you work in a audio project using the
   same hardware, using its best audio quality, so there is
   no problem on adopting a singe rate/bitdepth for the whole song.
 */


class Mixer : public MustuxEngine
        {
        Q_OBJECT

        public:

                static const int STOPPED = 0;
                static const int ARMED = 1;
                static const int GOING = 2;
                static const int PAUSED = 3;
                static const int ABORTED = 4;

                static const int ERROR_EMPTY_MTA = -10;
                static const int REACHED_END_OF_MTA = -111;

                Mixer(Song* pSong);
                ~Mixer();

		int validate_buses(int rate, int whichChannels, int bitDepth);
                int go(MtaRegion* regionList);
		int go(long long pStartPos, long long pEndPos = -1);
                int arm(int busIn, int whichChannels);
                int disarm(int busIn);
                int going();
                int listening();
                int abort();
                int stop();
                int render_all(QString filename);

		void force_stop();

                int get_status();
                long long get_going_pos();

                bool any_track_armed();
                bool valid_playback_bus(int busId);
                bool valid_capture_bus(int busId);
		bool validPlaybackBus[MustuxAudioDeviceMapper::MAX_BUSES];
                bool validCaptureBus[MustuxAudioDeviceMapper::MAX_BUSES];

                GoThread* goThread;
		ListenerThread* listenerThread;
                Song* assocSong;
		MtaRegion* regionList;

		int mix_track_portion( Track* track,
                              char* sourceBuffer,
                              int sourceBufferSize,
                              char* mixBuffer,
                              int mixBufferSize,
                              int mixBufferBlockSize);

		long long goStartPos;
		long long goEndPos;
                long long goingPos;
                int goingStep;
		long long listenPos;
		int listenStep;
		float commonFpsOut,commonFpsIn;

                int status;
	private:
		bool emptyMTA;
        };

#include "Song.hh"
#include "Track.hh"
#include "MtaRegion.hh"

#endif


