/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include <mustux.h>
#include "Protux.hh"
#include "Main.hh"


int main( int argc, char **argv )
	{
	if (argc > 1)
		{
		for (int i=1; i<argc; i++)
			{
			if (strcmp(argv[i],"--d1")==0)
				MustuxDebugger::set_debug_level(MustuxDebugger::BASIC);
			if (strcmp(argv[i],"--d2")==0)
				MustuxDebugger::set_debug_level(MustuxDebugger::FLOOD);
			if (strcmp(argv[i],"--d3")==0)
				MustuxDebugger::set_debug_level(MustuxDebugger::SUPER_FLOOD);
			if (strcmp(argv[i],"--d4")==0)
				MustuxDebugger::set_debug_level(MustuxDebugger::ALL);
			if (strcmp(argv[i],"--log")==0)
				MustuxDebugger::create_log("protux.log");
			if ((strcmp(argv[i],"--help")==0) || (strcmp(argv[i],"-h")==0))
				{
				printf("\nUsage: protux [OPTIONS]\n");
				printf("         Valid OPTIONS are :\n");
				printf("               --d1  \t Set debug level to 1 (BASIC)\n");
				printf("               --d2  \t Set debug level to 2 (FLOOD)\n");
				printf("               --d3  \t Set debug level to 3 (SUPER_FLOOD)\n");
				printf("               --d4  \t Set debug level to 4 (ALL)\n");
				printf("               --log \t Create a ~/protux.log file instead of dumping debug messages to stdout\n");
				printf("               --scanbuses \t List all hardware in and out buses\n");
				printf("               --help or -h \t This help text\n");
				printf("\n");
				return 0;
				}
			if ((strcmp(argv[i],"--scanbuses")==0) || (strcmp(argv[i],"-h")==0))
				{
				MustuxAudioDeviceMapper::init();
				MustuxAudioDeviceMapper::list_buses();
				return 0;
				}
			if (strcmp(argv[i],"--render")==0)
				{
				printf("Render in batch mode is being implemented.\n");
				// TODO
				return 0;
				}
			if (strcmp(argv[i],"--renderwav")==0)
				{
				printf("Render in batch mode is being implemented.\n");
				// TODO
				return 0;
				}
			}
		}
	PENTER;
	Protux* protux = new Protux(argc, argv);
	int r = protux->exec();
	delete protux;
	printf("Thank you for using Protux ! Visit our web site for more information http://www.nongnu.org/protux\n");
	PEXIT;
	return 0;
	}


