/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include <stdio.h>
#include <qvbox.h>
#include <mustux.h>
#include "Help.hh"

Help::Help(QString helpfilename , QWidget *parent) : QVBox( parent, (char*) 0 )
        {
        PENTERCONS;
        FILE *helpfile;
        setMargin( 5 );
        setMinimumSize(600,200);
        resize(600,200);

        view = new QTextView( this );
        view->setText( "This is a <b>Test</b> with <i>italic</i> <u>stuff</u> ");

        char* buffer;
        helpfile = fopen((const char*) helpfilename.latin1(), "r");
        if (helpfile)
                {
                fseek(helpfile, 0, SEEK_END);
                int len = ftell(helpfile);
                buffer = new char[len+1];
                buffer[len]=0;
                rewind(helpfile);
                fread(buffer, 1, len, helpfile);
                fclose (helpfile);
                }
        else
                {
                buffer="Cannot open help.text file";
                PERROR("Cannot open help.text file");
                }
	view->setTextFormat(PlainText);
        view->setText( buffer );
        view->setMinimumSize( 450, 250 );
        PEXITCONS;
        }

Help::~Help()
        {
        PENTERDES;
        PEXITDES;
        }

//eof

