/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "GlobalProperties.hh"
#include <mustux.h>
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <qasciidict.h>
#include <qmessagebox.h>
#define PROPERTY_SIZE 4096
#define MAX_PROPERTIES 100

// IMPROVE-ME : WORK WITH QString INSTEAD OF CHAR* !!!

class Pair
        {
        public :
                Pair(char* pKey, char* pValue)
                        {
                        key = new char[len(pKey)];
                        strcpy(key,pKey);
                        value = new char[len(pValue)];
                        strcpy(value,pValue);
                        }
                ~Pair() {
                        delete key;
                        delete value;
                        }

                char* key;
                char* value;
        private :
                int len(char* s)
                        {
                        int l=0;
                        while (s[l++]);
                        return l;
                        }
        };

namespace GlobalProperties
        {
                Pair* dict[MAX_PROPERTIES];
        }


void GlobalProperties::init()
        {
        PENTER;
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                dict[i]=0;
                }

        // Version is defined in configure.in file
        QString userHomePath = QString(getenv("HOME")) + "/";
        QString rcFile = userHomePath + ".protuxrc";
        FILE* f = fopen( (const char*) rcFile.latin1(), "r");
        char* settingsData =
                "SLICE_WIDTH_FACTOR=1\n"
                "JMB_CLEAR_TIME=2000\n"
                "JMB_HOLD_TIMEOUT=200\n"
                "JMB_DOUBLE_FACT_TIMEOUT=200\n"
                "DEFAULT_NUM_TRACKS=6\n"
                "HZOOM_LEVEL=23\n"
                "DEFAULT_SAMPLE_RATE=44100\n"
                "DEFAULT_BIT_DEPTH=16\n"
                "AUDIO_MAPPER_FPS=20\n"
                "USE_PLUGHW=NO\n"
                "USE_EXTERNAL_OGG_DECODER=1\n"
                "USE_EXTERNAL_OGG_ENCODER=1\n"
                "MP3_DECODE_COMMAND=mpg123 -w %of %if\n"
                "OGG_DECODE_COMMAND=ogg123 -d wav -f %of %if\n"
                "OGG_ENCODE_COMMAND=oggenc -b 320 -o %of %if\n"
                "CURRENT_PROJECT=Untitled\n";

        if (!f)
                {
                QString warnMessage =  "Hi! This is the first time you run Protux. Welcome !\n"
                                       "I generated a basic Protux configuration file under your home dir.\n"
                                       "~/.protuxrc and hold these settings : \n\n";
                warnMessage =  warnMessage + settingsData +  "\n" +
                               "You can edit it if you wish. To do so, please follow Protux user's\n" +
                               "guide, in Configuration Section.\n";
                QMessageBox::warning( 0,"Protux", warnMessage);
                PWARN("No ~/.protuxrc file found. Creating it as %s ...",(const char*) rcFile.latin1());
                f = fopen( (const char*) rcFile.latin1(), "w");
                int count=0; while (settingsData[count++]);
                fwrite(settingsData, 1,count, f);
                fclose(f);
                f = fopen( (const char*) rcFile.latin1(), "r");
                }
        char line[PROPERTY_SIZE];

        char c;
        int x;
        while (!feof(f))
                {
                c=0;
                x=0;
                for (int i=0; i<PROPERTY_SIZE; i++) line[i]=0;
                while ((!feof(f)) && (c!='\n'))
                        {
                        fread ( &c, 1 , 1 , f);
                        line[x++]= ( c!='\n' ? c : 0 );
                        }
                int len=0; while (line[len]) len++;
                if (len==0) continue;
                char* pkey=line;
                char* pval=0;
                char* p=line;
                int lenKey=0;
                while (*p)
                        if (*p=='=')
                                {
                                pval=p+1;
                                *p=0;
                                }
                        else { p++; lenKey++; }
                if ((pval) && (pkey) && (pval[0]) && (pkey[0]))
                        insert (pkey,pval);
                }
        fclose(f);

        //show_dict();

        PEXIT;
        }


void GlobalProperties::insert(char* key, char* value)
        {
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i])
                        {
                        dict[i]=new Pair(key,value);
                        PMESG("Added property %s = %s ",key,value);
                        break;
                        }
                }
        }

void GlobalProperties::remove(char* key)
        {
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i]) continue;
                if (strcmp(dict[i]->key,key)==0)
                        {
                        PMESG("Deleting key %s",key );
                        delete (dict[i]);
                        dict[i]=0;
                        break;
                        }
                }
        }

char* GlobalProperties::get(char* key)
        {
        char* value=0;
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i]) continue;
                if (strcmp(dict[i]->key,key)==0)
                        {
                        value=dict[i]->value;
                        //PMESG("Retrieving key " << key << " = " << value);
                        break;
                        }
                }
        return value;
        }



int GlobalProperties::get_int(char* key)
        {
        int value=0;
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i]) continue;
                if (strcmp(dict[i]->key,key)==0)
                        {
                        value=atoi(dict[i]->value);
                        PMESG("Retrieving key %s=%d ", key,value);
                        break;
                        }
                }
        return value;
        }


void GlobalProperties::set(char* key, int value)
        {
        remove(key);
        char* svalue = new char[PROPERTY_SIZE];
        sprintf(svalue,"%d",value);
        insert(key, svalue);
        }


void GlobalProperties::set(char* key, char* value)
        {
        PENTER;
        remove(key);
        insert(key,value);
        PEXIT;
        }



void GlobalProperties::show_dict()
        {
        PENTER;
        PMESG("Showing dict...");
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i]) continue;
                char *a = dict[i]->key;
                char *b = dict[i]->value;
                PMESG("         Property %s=%s",a,b);
                }
        PEXIT;
        }


void GlobalProperties::save()
        {
        PENTER;
        QString userHomePath = QString(getenv("HOME")) + "/";
        QString rcFile = userHomePath + ".protuxrc";

        PMESG("Saving GlobalProperties to %s ... " , (const char*) rcFile.latin1());
        FILE* f = fopen( (const char*) rcFile.latin1(), "w");

        QString data="";
        //char data[PROPERTY_SIZE];
        for (int i=0; i<MAX_PROPERTIES; i++)
                {
                if (!dict[i]) continue;
                QString line = QString(dict[i]->key) + "=" + QString(dict[i]->value);
                PMESG("Saving Property %s",line.latin1());
                data = data + line + "\n";
                }
        const char* buf = (const char*) data.latin1();
        fwrite(buf, 1, data.length(), f);

        fclose(f);
        PEXIT;
        }

void GlobalProperties::finish()
        {
        PENTER;
        PEXIT;
        }



//eof

