/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef CURSORMANAGER_HH
#define CURSORMANAGER_HH

#include <mustux.h>
#include <qwidget.h>
#include <qpainter.h>

class Song;

class CursorManager : public MustuxEngine
	{
	Q_OBJECT
	public :

		static const int MODE_NOTDEFINED=0;
		static const int MODE_NONE=1;
		static const int MODE_FLOAT=2;
		static const int MODE_DRAG=3;
		static const int MODE_PLAY=4;
		static const int MAX_CURSORS = 20;

		static const int CURSOR_FLOAT = 0;
		static const int CURSOR_FLOAT_OVER_CLIP = 1;
		static const int CURSOR_FLOAT_OVER_TRACK = 2;
		static const int CURSOR_HOLD_UD = 3;
		static const int CURSOR_HOLD_LR = 4;
		static const int CURSOR_HOLD_LRUD = 5;
		static const int CURSOR_DRAG = 6;
		static const int CURSOR_SELECT = 7;
		static const int CURSOR_MAGIC_ZOOM = 8;

		CursorManager(Song* pAssocSong);
		~CursorManager();

		void set_mode(int mode, int pOrigX=0, int pOrigY=0,
			int pCursorW=1, int pCursorH=-1,
			int pOffsetX=0, int pOffsetY=0);

		void set_cursor(int cMode);

		void start();
		void recreate();
		void update(int x, int y);
		void enable();
		void disable();
		void set_work_at(int x);
		void set_work_at(long long bp);

		int get_orig_x();
		int get_orig_y();
		int get_x_offset();
		int get_y_offset();
		void set_x_offset(int x);
		void set_y_offset(int y);

		void set_work_cursor_color(int r, int g, int b);

		int get_current_cursor_map_index();

		QString block_to_smpte(long long pos, int sampleRate); // FIND ME ANOTHER BETTER PLACE

	protected :
		QColor* workCursorColor;

		void update_work_cursor(int x);
		void update_drag_cursor(int x, int y);
		void update_float_cursor(int x);

		int currentCursorMapIndex;

		MustuxDrawable* dataBox;

		Song* assocSong;
		MustuxDrawable *drawArea;
		QTimer* followPlayTimer;
		QCursor* cursorMap[MAX_CURSORS];

		int mode;
		int floatX;
		int floatY;
		int xOrig;
		int yOrig;
		int xOffset;
		int yOffset;
		int cursorW;
		int cursorH;
		int workX;
		int playX;

		bool isEnabled;

		void toggle_work_cursor();
		void toggle_float_cursor(int x, int h);
		void toggle_drag_cursor();
		void toggle_play_cursor(int x, int h); // vai virar generico

	public slots:
		void update_play_cursor();

	private:
		friend class Song;
	};

#include "Song.hh"

#endif



