#include "BusSelector.hh"


        static const int MENU_W = 350;
        static const int MENU_H = 200;
        static const int ROW_HEIGHT = 14;
        static const int MAX_ROUTES = 20;


BusSelector::BusSelector(MustuxDrawable* pDrawArea, Mixer* pMixer)  : MustuxDrawableRegion(pDrawArea)
        {
        drawArea=pDrawArea;
        assocMixer = pMixer;
        updateTimer = new QTimer(drawArea);
        connect( updateTimer , SIGNAL(timeout()), this, SLOT(update_selection()));
        }

BusSelector::~BusSelector()
        {
        }

void BusSelector::show_list()
        {
        rootx = 0;//drawArea->get_mouse_x();
        rooty = drawArea->get_mouse_y();
        windowWidth = drawArea->width();
        windowHeight = drawArea->height();
        if (rooty+MENU_H>windowHeight-10) rooty=rooty-MENU_H;
        drawArea->painter->fillRect(rootx,rooty,MENU_W,MENU_H,Qt::white);
        drawArea->painter->setPen(QColor(0,20,40));
        for (int i=0; i<5; i++)
                drawArea->painter->drawRect(rootx+i,rooty+i,MENU_W-i*2,MENU_H-i*2);

        for (int i=0; i<5; i++)
                drawArea->painter->drawLine(rootx,rooty+25+i,rootx+MENU_W,rooty+25+i);

        drawArea->painter->setFont( QFont( "Fixed", 8 ) );
        drawArea->painter->setPen(QColor(0,0,0));

        if (direction == IN)
                {
                drawArea->painter->drawText(rootx+20,rooty+20,"Select Bus IN");
                for (int i=0; i<MustuxAudioDeviceMapper::get_total_buses_in(); i++)
                        {
                        if (!assocMixer->valid_capture_bus(i))
                                drawArea->painter->setPen(QColor(220,210,210));
                        else
                                drawArea->painter->setPen(QColor(0,0,0));
                        drawArea->painter->drawText(rootx+12,rooty+45+i*ROW_HEIGHT,MustuxAudioDeviceMapper::get_bus_in_full_name(i));
                        }
                }

        else
                {
                drawArea->painter->drawText(rootx+20,rooty+20,"Select Bus OUT");
                for (int i=0; i<MustuxAudioDeviceMapper::get_total_buses_out(); i++)
                        {
                        if (!assocMixer->valid_playback_bus(i))
                                drawArea->painter->setPen(QColor(220,210,210));
                        else
                                drawArea->painter->setPen(QColor(0,0,0));
                        drawArea->painter->drawText(rootx+12,rooty+45+i*ROW_HEIGHT,MustuxAudioDeviceMapper::get_bus_out_full_name(i));
                        }
                }
        drawArea->update(rootx,rooty,MENU_W,MENU_H);
        }


void BusSelector::start(int pDirection)
        {
        PENTER;
        direction = pDirection;
        rootx=-1;
        rooty=-1;
        windowWidth=-1;
        windowHeight=-1;
        lastPointedLine=-1;
        colorChangeVal=0;
        colorChangeFactor=1;
        show_list();
        updateTimer->start(50);
        PEXIT;
        }

void BusSelector::stop()
        {
        PENTER;
        updateTimer->stop();
        drawArea->recreate();
        PEXIT;
        }

void BusSelector::update_selection()
        {
        int y = drawArea->get_mouse_y();
        int pointedLine = ((y+5-rooty)/ROW_HEIGHT)-3;
        if (direction==IN)
		{
	        if ((pointedLine<0) || (pointedLine>MustuxAudioDeviceMapper::get_total_buses_in()-1))
                	return;
		}
	else
		{
	        if ((pointedLine<0) || (pointedLine>MustuxAudioDeviceMapper::get_total_buses_out()-1))
			return;
		}
        int cx = rootx+5;
        int cy = rooty+pointedLine*ROW_HEIGHT+35;
        if (pointedLine!=lastPointedLine)
                {
                if ((lastPointedLine>=0) && (lastPointedLine<17))
                        {
                        int lcy = rooty+lastPointedLine*ROW_HEIGHT+35;
                        drawArea->painter->fillRect(cx,lcy,MENU_W-10,ROW_HEIGHT, QColor(255,255,255));
                        // optimize me , there is this code in 3 places
                        QString bn;
                        if (direction==IN)
                                {
                                bn = MustuxAudioDeviceMapper::get_bus_in_full_name(lastPointedLine);
                                if (!assocMixer->valid_capture_bus(lastPointedLine))
                                        drawArea->painter->setPen(QColor(220,210,210));
                                else
                                        drawArea->painter->setPen(QColor(0,0,0));
                                }

                        else
                                {
                                bn = MustuxAudioDeviceMapper::get_bus_out_full_name(lastPointedLine);
                                if (!assocMixer->valid_playback_bus(lastPointedLine))
                                        drawArea->painter->setPen(QColor(220,210,210));
                                else
                                        drawArea->painter->setPen(QColor(0,0,0));
                                }

                        drawArea->painter->drawText(rootx+12,rooty+46+lastPointedLine*ROW_HEIGHT,bn);
                        drawArea->update(cx,lcy,MENU_W-10,ROW_HEIGHT);
                        }
                lastPointedLine=pointedLine;
                }
        drawArea->painter->fillRect(cx,cy,MENU_W-10,ROW_HEIGHT, QColor(255,colorChangeVal,colorChangeVal));
        drawArea->painter->setPen(QColor(0,0,0));
        // optimized, there is this code in 3 places
        QString bn;
        if (direction==IN)
                bn = MustuxAudioDeviceMapper::get_bus_in_full_name(pointedLine);
        else
                bn = MustuxAudioDeviceMapper::get_bus_out_full_name(pointedLine);
        drawArea->painter->drawText(rootx+12,rooty+46+pointedLine*ROW_HEIGHT,bn);
        drawArea->update(cx,cy,MENU_W-10,ROW_HEIGHT);

        colorChangeVal+=colorChangeFactor;
        if (colorChangeVal>240) colorChangeFactor=-20;
        if (colorChangeVal<60) colorChangeFactor=20;
        }

int BusSelector::get_selected_bus()
        {
        if (direction==IN)
	        if ((lastPointedLine>=0) && (lastPointedLine<MustuxAudioDeviceMapper::get_total_buses_in()))
                	return lastPointedLine;
	if (direction==OUT)
	        if ((lastPointedLine>=0) && (lastPointedLine<MustuxAudioDeviceMapper::get_total_buses_out()))
                	return lastPointedLine;
        return -1;
        }

QString BusSelector::get_selected_bus_name()
        {
        if ((lastPointedLine>=0) && (lastPointedLine<MustuxAudioDeviceMapper::get_total_buses_out()))
                {
                if (direction==IN)
                        return MustuxAudioDeviceMapper::get_bus_in_full_name(lastPointedLine);
                else
                        return MustuxAudioDeviceMapper::get_bus_out_full_name(lastPointedLine);
                }
        else
                return "";
        }

//eof
