/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#ifndef BUSMONITOR_HH
#define BUSMONITOR_HH

#include <mustux.h>
#include <qcolor.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qdockwindow.h>
#include <qsplitter.h>

#define MAX_PRESET_MARKS 6

class Interface;
class SingleBusMonitor;


class BusMonitor :  public QWidget // TODO will be called AudioDevicesMonitor or MultiBusMonitor
	{
	Q_OBJECT


	public :
		static const int MAX_CHANNELS_PER_BUS = 2;

		static float coefficient_to_dB (float coeff);
		static float dB_to_scale_factor (float dB);

		BusMonitor(int minWidth, int minHeight, QWidget* parent, Interface* pAssocInterface);
		~BusMonitor();

		void init();
		void recreate();
		void finish();

		void show_only_vus_in();
		void show_only_vus_out();
		void show_both_vus();
		void set_view_card_info_area();

		SingleBusMonitor *cardInfoArea , *busInArea, *busOutArea;


	protected:

		void resizeEvent( QResizeEvent* e);
		void leaveEvent ( QEvent* e );
		void enterEvent ( QEvent* e );
		float presetMark[MAX_PRESET_MARKS];
		QSplitter* splitter;

	private:
		Interface* assocInterface;
		QWidget* parentWidget;
		QWidget* hbox;
		QHBoxLayout* hboxlayout;
		QWidget* splitterbox;
		QWidget* busAreaSplitter;
		QVBoxLayout* splitterlay;
		bool activeTail;
		bool onlyVUsOut;
		bool onlyVUsIn;
		bool showCardInfoArea;

		float levelIn [MustuxAudioDeviceMapper::MAX_BUSES][MAX_CHANNELS_PER_BUS];
		float levelOut[MustuxAudioDeviceMapper::MAX_BUSES][MAX_CHANNELS_PER_BUS];
		float tailDeltaYIn[MustuxAudioDeviceMapper::MAX_BUSES][BusMonitor::MAX_CHANNELS_PER_BUS];
		float tailDeltaYOut[MustuxAudioDeviceMapper::MAX_BUSES][BusMonitor::MAX_CHANNELS_PER_BUS];

		QTimer* updateTimer;
		void draw_indicators(SingleBusMonitor* bus,
						int bx,
						int by,
						QString title);

		void draw_bus_vu_base(SingleBusMonitor* bus,
					int bx ,
					int by ,
					int channels,
					QString title,
					bool isActiveBus,
					int busId);
		void draw_bus_vu_peaks(SingleBusMonitor* bus,
					int bx,
					int by,
					int channels,
					int stream,
					float* levelBufferm,
					float* tailDeltaY);
		void draw_active_tails();


	public slots:

		void update();
	};


class SingleBusMonitor : public MustuxDrawable
	{
	public :
		BusMonitor* assocBusMonitor;
		SingleBusMonitor(int minw, int minh, QWidget* parent, BusMonitor* bm);
		~SingleBusMonitor();

	protected:
		void resizeEvent(QResizeEvent* e);
	};



#include "Interface.hh"

#endif



