/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "AudioSourcesList.hh"

AudioSourcesList::AudioSourcesList()
        {
        PENTERCONS;
        for (int i=0; i< MAX_AUDIO_SOURCES;i++)
                audioSource[i]= (Audio*) 0;
        PEXITCONS;
        }

AudioSourcesList::~AudioSourcesList()
        {
        PENTERDES;
        PEXITDES;
        }


int AudioSourcesList::add(Audio*  pAudio)
        {
        PENTER;
        for (int i=0; i< MAX_AUDIO_SOURCES;i++)
                {
                if (!audioSource[i])
                        {
                        audioSource[i]=pAudio;
                        PEXIT;
                        return 1;
                        }
                }
        PEXIT;
        return -1;
        }

int AudioSourcesList::remove(Audio* pAudio)
        {
        PENTER;
        for (int i=0; i< MAX_AUDIO_SOURCES;i++)
                {
                if (audioSource[i]==pAudio)
                        {
                        audioSource[i]=(Audio*) 0;
                        for (int j=i; j<MAX_AUDIO_SOURCES - 1; j++)
                                audioSource[j]=audioSource[j+1];
                        PEXIT;
                        return 1;
                        }
                }
        PEXIT;
        return -1;
        }


int AudioSourcesList::get_total_sources()
        {
        int total=0;
        for (int i=0; i< MAX_AUDIO_SOURCES;i++)
                if (audioSource[i])
                        total++;
        return total;
        }

Audio* AudioSourcesList::get_source_for_index(int i)
        {
        if ((i<0) || (i>MAX_AUDIO_SOURCES-1))
                return (Audio*) 0;
        else
                return audioSource[i];
        }


Audio* AudioSourcesList::get_audio_for_source(QString sourceFileName)
        {
        Audio* au = 0;
        for (int i=0; i< MAX_AUDIO_SOURCES;i++)
                {
                if (audioSource[i] && (audioSource[i]->file->filename==sourceFileName))
                        {
                        au=audioSource[i];
                        break;
                        }
                }
        return au;
        }
//eof

