/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef AUDIO_HH
#define AUDIO_HH

#include <stdio.h>
#include <qstring.h>
#include <qprogressbar.h>


#include <mustux.h>

class Song;
class Peak;

class Audio
        {
        public :
                Audio(Song* pParentSong);
                ~Audio();

                int build(QString rootDir, QString pFileName, QProgressBar *monitorProgressBar = 0);
                int create(QString rootDir, QString pFileName, int pChannels, int pRate, int pSize,
                        QString pProjectLabel, QString pGroupLabel,
                        QString pHardwareLabel, QString pDescription);
                int rebuild_peaks();
		int build_peaks(); 	// added By Remon
                int unbuild();
                QString get_info();
                int get_clips_count();

                /** return the 'pure' filename, without the path*/
                QString get_pure_filename();

                /** return the 'full' filename, including the path*/
                QString get_absolute_filename();

                static const int MONO = 1;
                static const int STEREO = 2;

                Peak* peak;
                MustuxAudioFileFormat* file;

        private:
                QString pureFilename;
                QString absoluteFilename;
                Song* parentSong;
                QString rootDir;

                friend class Peak;
                friend class Mixer;
        };

#include "Song.hh"
#include "Peak.hh"
#endif


