/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include <mustux.h>
#include "Audio.hh"


// FOR LATER ::#include "GlobalSettings.hh"

Audio::Audio(Song* pParentSong)
        {
        PENTERCONS;
        peak = new Peak(pParentSong);	//WAS: peak = (Peak*) 0; By Remon
        file = (MustuxAudioFileFormat*) 0;
        parentSong = pParentSong;
        PEXITCONS;
        }

Audio::~Audio()
        {
        PENTERDES;
        if (file) delete file;
        if (peak) delete peak;
        PEXITDES;
        }


int Audio::build(QString pRootDir, QString filename, QProgressBar *monitorProgressBar )
        {
        PENTER;
        rootDir = pRootDir;
        pureFilename = filename;
        // this way to detect a file type is bad..
        // try to implement something like static MustuxAudioFileFormat::identify_type()
        if (filename.find("praf",0,false)>=0)
                {
                file = new PrafFile();
                }
        else if (filename.find("wav", 0,false)>=0)
                {
                file = new WavFile();
                }
#ifdef OGG_VORBIS_SUPPORT
        else if (filename.find("ogg", 0,false)>=0)
                {
                file = new OggFile();
                }
#endif
        absoluteFilename = rootDir + "/" + filename;
        if (file->open(absoluteFilename)<0)
                {
                PERROR( "%s not Found",(const char*)absoluteFilename.ascii());
                delete file;
                file = 0;
                PEXIT;
                return -1;
                }
        //file->rewind_all(); //Ehm,,: this is already done in file>open(absoluteFilename); By Remon
        if (file->read_header()<0) // Seems not to be a WAV/PRAF/OGG file
                {
                PEXIT;
                return -1;
                }
        //peak = new Peak();	//Allready done in constructor By Remon
        peak->build(this,monitorProgressBar);
        file->rewind_audio();
        PEXIT;
        return 1;
        }



int Audio::create(QString pRootDir, QString filename, int pChannels, int pRate, int pSize,
                        QString pProjectLabel, QString pGroupLabel,
                        QString pHardwareLabel, QString pDescription)
        {
        PENTER;
        rootDir = pRootDir;
	pureFilename = filename;
        PMESG("Creating audio %d channels, %d Hz, %d bits",pChannels,pRate,pSize);
        QString absoluteFilename = rootDir + "/" + filename;
        file =  new PrafFile();
        if (file->create((char*)absoluteFilename.ascii())<0)
                {
                delete file;
                file = 0;
                PERROR("Cannot create new file");
                return -1;
                }
        file->write_header(pChannels, pRate, pSize, 0,
                         pProjectLabel, pGroupLabel,
                         pHardwareLabel, pDescription);
	file->read_header();	//nothing initialized yet, now all variables are set for this file By Remon
        PEXIT;
        return 1;
        }


int Audio::rebuild_peaks()
        {
        PENTER;
        if (peak)
                delete peak;
        peak = new Peak(parentSong);
        peak->build(this);
        PEXIT;
        return 1;
        }


int Audio::build_peaks()
        {
        PENTER;
        peak->build(this);
        PEXIT;
        return 1;
        }


int Audio::unbuild()
        {
        PENTER;
        if (file->close_file()<0)
                {
                PERROR("Cannot close file" );
                }
        PEXIT;
        return 1;
        }



QString Audio::get_info()
        {
        QString s = file->get_info();
        QString s2; s2.setNum(get_clips_count());
        s = s + "\nClipsCount=" + s2 + "\n";
        return s;
        }


int Audio::get_clips_count()
        {
        return parentSong->get_clips_count_for_audio(this);
        }

QString Audio::get_pure_filename()
        {
        return pureFilename;
        }

QString Audio::get_absolute_filename()
        {
        return absoluteFilename;
        }

// eof
