# Configure paths for Mustux
# Martin Herren		2003-01-02
# 	adapted from
# Configure paths for GTS
# Stphane Popinet  2001-10-4
#       adapted from
# Configure paths for GLIB
# Owen Taylor       97-11-3

dnl
dnl AC_PATH_MUSTUX([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for MUSTUX, and define MUSTUX_CXXFLAGS and MUSTUX_LIBS
dnl
dnl This macro sets the $MUSTUX_CXXFLAGS and $MUSTUX_LIBS variables
dnl 
dnl For this macro to work, a 'Qt detection' macro must have been run before,
dnl setting $QT_CXXFLAGS and $LIBS correctly so that i can make a mustux test-link
dnl
dnl TODO: implement the --disable-mustuxtest option, where no compile and link occurs
dnl

AC_DEFUN([AC_PATH_MUSTUX], \
[
  MUSTUX_LIB_SEARCH_PATH="/usr/lib \
			/usr/local/lib"
  MUSTUX_HEADERS_SEARCH_PATH="/usr/include \
			/usr/local/include"

  min_mustux_version=ifelse([$1],, [0.16.0], [$1])

  AC_LANG(C++)
  
  AC_PATH_QT([2.3.0])

  AC_ARG_WITH([mustux-prefix], \
		[  --with-mustux-prefix=PREFIX   Prefix where Mustux is installed (optional)], \
		[MUSTUX_LIB_SEARCH_PATH="$withval/lib $MUSTUX_lIB_SEARCH_PATH" \
		        MUSTUX_HEADERS_SEARCH_PATH="$withval/include $MUSTUX_HEADERS_SEARCH_PATH" \
		        PATH="$withval/bin:$PATH"], \
		[MUSTUX_LIB_SEARCH_PATH="$MUSTUX_LIB_SEARCH_PATH" \
		        MUSTUX_HEADERS_SEARCH_PATH="$MUSTUX_HEADERS_SEARCH_PATH" \
		        PATH="$PATH"])
  AC_ARG_WITH([mustux-lib-dir], \
		[  --with-mustux-lib-dir=DIR     Directory where Mustux libraries are installed (optional)], \
		[MUSTUX_LIB_SEARCH_PATH="$withval $MUSTUX_LIB_SEARCH_PATH"], \
		[MUSTUX_LIB_SEARCH_PATH="$MUSTUX_LIB_SEARCH_PATH"])
  AC_ARG_WITH([mustux-include-dir], \
		[  --with-mustux-include-dir=DIR Directory where Mustux includes are installed (optional)], \
		[MUSTUX_HEADERS_SEARCH_PATH="$withval $MUSTUX_HEADERS_SEARCH_PATH"], \
		[MUSTUX_HEADERS_SEARCH_PATH="$MUSTUX_HEADERS_SEARCH_PATH"])
  AC_ARG_WITH([mustux-bin-dir], \
		[  --with-mustux-bin-dir=DIR     Directory where Mustux binaries are installed (optional)], \
		[PATH="$withval:$PATH"], \
		[PATH="$PATH"])

dnl  AC_ARG_ENABLE(mustux-test,
dnl		[  --enable-mustux-test          Do not try to compile a test Mustux program],
dnl		,
dnl		enable_mustuxtest=yes)


dnl look for mustux-config, and take the config from it
  AC_PATH_PROG([MUSTUX_CONFIG], [mustux-config], [no])
  if test $MUSTUX_CONFIG = "no"; then
    AC_MSG_ERROR([mustux-config could not be found, please install mustux first])
  fi

  mustux_prefix=`$MUSTUX_CONFIG --prefix`
  MUSTUX_LIB_SEARCH_PATH="$mustux_prefix/lib $MUSTUX_LIB_SEARCH_PATH"
  MUSTUX_HEADERS_SEARCH_PATH="$mustux_prefix/include $MUSTUX_HEADERS_SEARCH_PATH"


dnl check if libmustux is installed
  AC_MSG_CHECKING([for libmustux])
  L_PATH="no"
  AC_FIND_FILE([libmustux.so], [$MUSTUX_LIB_SEARCH_PATH], [L_PATH])
  if test $L_PATH = "no"; then
    AC_FIND_FILE([libmustux.a], [$MUSTUX_LIB_SEARCH_PATH], [L_PATH])
    if test $L_PATH = "no"; then
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([libmustux not found, please install it first])
    fi
  fi
  AC_MSG_RESULT([$L_PATH])
  MUSTUX_LIBS=`$MUSTUX_CONFIG --libs`


dnl check for mustux header files
  AC_MSG_CHECKING([for mustux headers])
  H_PATH="no"
  AC_FIND_FILE([mustux.h], [$MUSTUX_HEADERS_SEARCH_PATH], [H_PATH])
  if test $H_PATH = "no"; then
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([mustux headers not found, please install them first])
  fi
  AC_MSG_RESULT([$H_PATH])
  MUSTUX_CXXFLAGS=`$MUSTUX_CONFIG --cflags`


dnl check for version
  AC_MSG_CHECKING([for libmustux version >= $min_mustux_version])
  installed_mustux_version=`$MUSTUX_CONFIG --version`
  AC_COMPARE_VERSIONS($installed_mustux_version, $min_mustux_version, result="yes", result="no")
  if test $result = "yes"; then
    AC_MSG_RESULT([yes])
  else
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([you need to upgrade to a newer version of mustux])
  fi


dnl try to link a minimal mustux appplication
  ac_save_CXXFLAGS="$CXXFLAGS"
  ac_save_LIBS="$LIBS"
  CXXFLAGS="$CXXFLAGS $MUSTUX_CXXFLAGS $QT_CXXFLAGS -DQT_THREAD_SUPPORT  -D_REENTRANT"
  LIBS="$LIBS $MUSTUX_LIBS $QT_LIBS"
  AC_MSG_CHECKING([if a small mustux application compiles and links fine])
  AC_LINK_IFELSE([ \
#include <mustux.h>

int main(int argc, char **argv)
{
  MustuxApplication *app = new MustuxApplication(argc, argv);
  delete app;

  return 0;
}
], result="yes", result="no")

  if test $result = "yes"; then
    AC_MSG_RESULT([ok])
  else
    AC_MSG_RESULT([failed])
    AC_MSG_ERROR([there is something wrong with your mustux installation])
  fi



  CXXFLAGS=$ac_save_CXXFLAGS
  LIBS=$ac_save_LIBS



  AC_SUBST([MUSTUX_CXXFLAGS])
  AC_SUBST([MUSTUX_LIBS])
])







dnl AC_PATH_QT([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [,LIBRARY]]]])
dnl Test for QT, and define QT_MOC, QT_CXXFLAGS and QT_LIBS
dnl
AC_DEFUN([AC_PATH_QT],[

  QT_LIB_SEARCH_PATH="$QTDIR/lib \
			/usr/lib \
			/usr/local/lib \
			/usr/lib/qt3 \
			/usr/lib/qt2 \
			/usr/lib/qt \
			/usr/local/lib/qt3 \
			/usr/local/lib/qt2 \
			/usr/local/lib/qt \
			/usr/lib/qt3/lib \
			/usr/lib/qt2/lib \
			/usr/lib/qt/lib \
			/usr/local/lib/qt3/lib \
			/usr/local/lib/qt2/lib \
			/usr/local/lib/qt/lib \
			/opt/qt3/lib \
			/opt/qt2/lib \
			/opt/qt/lib"
  QT_HEADERS_SEARCH_PATH="$QTDIR/include \
			/usr/include \
			/usr/local/include \
			/usr/include/qt3 \
			/usr/include/qt2 \
			/usr/include/qt \
			/usr/local/include/qt3 \
			/usr/local/include/qt2 \
			/usr/local/include/qt \
			/usr/lib/qt3/include \
			/usr/lib/qt2/include \
			/usr/lib/qt/include \
			/usr/local/lib/qt3/include \
			/usr/local/lib/qt2/include \
			/usr/local/lib/qt/include \
			/opt/qt3/include \
			/opt/qt2/include \
			/opt/qt/include"

  min_qt_version=ifelse([$1], [], [3.0.0],[$1])

  AC_LANG([C++])

  AC_ARG_WITH([qt-prefix], \
		[  --with-qt-prefix=PREFIX   Prefix where Qt is installed (optional)], \
		[QT_LIB_SEARCH_PATH="$withval/lib $QT_LIB_SEARCH_PATH" \
		        QT_HEADERS_SEARCH_PATH="$withval/include $QT_HEADERS_SEARCH_PATH" \
		        PATH="$withval/bin:$PATH"], \
		[QT_LIB_SEARCH_PATH="$QT_LIB_SEARCH_PATH" \
	        	QT_HEADERS_SEARCH_PATH="$QT_HEADERS_SEARCH_PATH" \
	        	PATH="$PATH"])
  AC_ARG_WITH([qt-lib-dir], \
		[  --with-qt-lib-dir=DIR     Directory where Qt libraries are installed (optional)], \
		[QT_LIB_SEARCH_PATH="$withval $QT_LIB_SEARCH_PATH"], \
		[QT_LIB_SEARCH_PATH="$QT_LIB_SEARCH_PATH"])
  AC_ARG_WITH([qt-include-dir], \
		[  --with-qt-include-dir=DIR Directory where Qt includes are installed (optional)], \
		[QT_HEADERS_SEARCH_PATH="$withval $QT_HEADERS_SEARCH_PATH"], \
		[QT_HEADERS_SEARCH_PATH="$QT_HEADERS_SEARCH_PATH"])
  AC_ARG_WITH([qt-bin-dir], \
		[  --with-qt-bin-dir=DIR     Directory where Qt binaries are installed (optional)], \
		[PATH="$withval:$PATH"], \
		[PATH="$PATH"])
dnl  AC_ARG_ENABLE(qt-test,
dnl		[  --enable-qt-test          Do not try to compile a test Qt program],
dnl		,
dnl		enable_qttest=yes)

  AC_PATH_PROG([QT_MOC], [moc], [no], [/usr/lib/qt3/bin:/usr/lib/qt2/bin:/usr/lib/qt/bin:/opt/qt3/bin:/opt/qt2/bin:/opt/qt/bin:$PATH])

  if test "$QT_MOC" = "no" ; then
    AC_MSG_ERROR([moc could not be found, please install first])
  fi


dnl check for qt-mt library
  AC_MSG_CHECKING([for libqt-mt.so])
  L_PATH="no"
  AC_FIND_FILE([libqt-mt.so], [$QT_LIB_SEARCH_PATH], [L_PATH])
  if test $L_PATH = "no"; then
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([QT libs not found, please install them first])
  fi
  AC_MSG_RESULT([$L_PATH/libqt-mt.so])
  QT_LIBS="-L$L_PATH -lqt-mt"


dnl check for qt headers
  AC_MSG_CHECKING([for QT headers])
  H_PATH="no"
  AC_FIND_FILE([qglobal.h], [$QT_HEADERS_SEARCH_PATH], [H_PATH])
  if test $H_PATH = "no"; then
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([QT headers not found, please install them first])
  fi
  AC_MSG_RESULT([$H_PATH])
  QT_CXXFLAGS="-I$H_PATH -DQT_THREAD_SUPPORT"


dnl now we should check the qt version


dnl try to link a minimal qt application
  ac_save_CXXFLAGS="$CXXFLAGS"
  ac_save_LIBS="$LIBS"
  CXXFLAGS="$QT_CXXFLAGS $CXXFLAGS"
  LIBS="$QT_LIBS $LIBS"
  AC_MSG_CHECKING([if a small qt application compiles and links fine])
  AC_LINK_IFELSE([
#include <qapplication.h>

int main(int argc, char **argv)
{
  QApplication *app = new QApplication(argc, argv);
  delete app;

  return 0;
}
], result="yes", result="no")
  if test $result = "yes"; then
    AC_MSG_RESULT([ok])
  else
    AC_MSG_RESULT([failed])
    AC_MSG_ERROR([there is something wrong with your qt installation])
  fi

  CXXFLAGS="$ac_save_CXXFLAGS"
  LIBS="$ac_save_LIBS"


  AC_SUBST([QT_MOC])
  AC_SUBST([QT_CXXFLAGS])
  AC_SUBST([QT_LIBS])
])






dnl AC_FIND_FILE(file, path list, found path)
AC_DEFUN([AC_FIND_FILE], \
[
dnl echo;
	for i in $2;
	do
dnl	echo $i/$1;
		if test -r "$i/$1";
		then
			$3=$i
			break 2
		fi
	done
])






dnl
dnl AC_COMPARE_VERSIONS(INSTALLED_VERSION,REQUIRED_VERSION,[ACTION-IF-FOUND[, ACTION_IF_NOT_FOUND]])
dnl where versions are strings of type 1.2.10 ore 0.16.0pre4
dnl
AC_DEFUN([AC_COMPARE_VERSIONS],[ \

  installed_version=$1
  required_version=$2

  installed_major_version=`echo $installed_version | cut -d . -f 1`
  installed_minor_version=`echo $installed_version | cut -d . -f 2`
  installed_micro_version=`echo $installed_version | sed s/pre/./ | cut -d . -f 3`
  installed_prerelease_version=`echo $installed_version | sed s/pre/./ | cut -d . -f 4`
  required_major_version=`echo $required_version | cut -d . -f 1`
  required_minor_version=`echo $required_version | cut -d . -f 2`
  required_micro_version=`echo $required_version | sed s/pre/./ | cut -d . -f 3`
  required_prerelease_version=`echo $required_version | sed s/pre/./ | cut -d . -f 4`
  if (test $installed_major_version -gt $required_major_version); then
    has_good_version="yes"
  else
    if (test $installed_major_version -eq $required_major_version -a \
             $installed_minor_version -gt $required_minor_version); then
      has_good_version="yes"
    else
      if (test $installed_major_version -eq $required_major_version -a \
               $installed_minor_version -eq $required_minor_version -a \
               $installed_micro_version -gt $required_micro_version); then
        has_good_version="yes"
      else
        if (test $installed_major_version -eq $required_major_version -a \
                 $installed_minor_version -eq $required_minor_version -a \
                 $installed_micro_version -eq $required_micro_version); then
          if (test x$installed_prerelease_version = x); then
            has_good_version="yes"
          else
            if (test x$required_prerelease_version = x); then
	      has_good_version="no"
            else
              if (test $installed_prerelease_version -ge $required_prerelease_version); then
                has_good_version="yes"
              else
                has_good_version="no"
              fi
            fi
          fi
        else
          has_good_version="no"
        fi
      fi
    fi
  fi

  if test $has_good_version = "yes"; then
    ifelse([$3],, [:],[$3])
  else
    ifelse([$4],, [:],[$4])
  fi
])
