/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef MUSTUXLCD_HH
#define MUSTUXLCD_HH

#include <qwidget.h>
#include <qtimer.h>

#include "MustuxDrawable.hh"

class MustuxLcd : public MustuxDrawable
        {
        Q_OBJECT
        public :
                MustuxLcd(int w, int h, QWidget *parent, const char* pName = 0);
                ~MustuxLcd();

                void clear_digit ( int line, int col);
                void clear_digits (int line, int startCol, int endCol);
                void clear_line(int line);
                void draw_digit_grid(int line, int col);
                void draw_digits_grids(int line, int startCol, int endCol);
                void draw_line_grid(int line);
                void draw_all_grids();
                void draw_digit(int index, int line, int col);

                void print(QString s, int line);
                void print(QString s, int line, int col);
                void print(QString s, int line, bool clean);
                void print(QString s, int line, int col, bool clean);

                void roll_message(QString text, int vel=40, int line=0);
                int get_max_digits() const;
                void set_max_digits(int md);
                void draw_background_grid();


        protected:
                void recreate();
                void paintEvent( QPaintEvent* );
                void resizeEvent( QResizeEvent *);

                QString welcomeText;
                int maxDigits;
                int welcomeIndex;
                QTimer* welcomeTimer;
                int rollLine;

                static const int DEFAULT_WIDTH = 100;
                static const int DEFAULT_HEIGHT = 50;

                int dotSize;
                int gridDotSize;
                int digitHSpace;
                int digitVSpace;
                int digitHSize;
                int digitVSize;
                int gridMarginLeft;
                int gridMarginUp;
                int scale;
                int hdelta;
                int vdelta;

        public slots:
                void scroll_welcome();

        private :
                static const int MAXSYMBOLS = 91;
                static char digit[MAXSYMBOLS][8][6];
        };



#endif

//eof
