/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#include "MustuxDebugger.hh"
#include "MustuxLcd.hh"
#include <qcolor.h>


MustuxLcd::MustuxLcd( int w, int h,  QWidget *parent, const char* pName )
        : MustuxDrawable( w, h, parent, pName )
        {
        PENTERCONS;
        maxDigits = 40;
        dotSize = 2;
        gridDotSize = 1;
        digitHSpace = 1;
        digitVSpace = 1;
        digitHSize = 5;
        digitVSize = 8;
        gridMarginLeft = 8;
        gridMarginUp = 8;
        scale = 2;
        hdelta = (digitHSize+digitHSpace)*scale;
        vdelta = (digitVSize+digitVSpace)*scale;
        set_background_color(152,164,150);

        welcomeTimer = new QTimer(this);
        connect( welcomeTimer, SIGNAL(timeout()), this, SLOT(scroll_welcome()) );

        draw_all_grids();
        PEXITCONS;
        }

MustuxLcd::~MustuxLcd()
        {
        PENTERDES;
        delete welcomeTimer;
        PEXITDES;
        }

void MustuxLcd::paintEvent(QPaintEvent* e)
        {
        MustuxDrawable::paintEvent(e);
        draw_all_grids();
        }


void MustuxLcd::resizeEvent(QResizeEvent* e)
        {
        MustuxDrawable::resizeEvent(e);
        recreate();
        }

void MustuxLcd::set_max_digits(int md)
        {
        maxDigits = md;
        }

void MustuxLcd::recreate()
        {
        draw_all_grids();
        }


void MustuxLcd::clear_digit ( int line, int col)
        {
        int x = gridMarginLeft + col*hdelta;
        int y = gridMarginUp + line*vdelta;
        fastPainter->fillRect(x,y,hdelta,vdelta,QColor(152,164,150));
        //update(x,y,hdelta,vdelta); IF YOU UNCOMMENT ME, CHANGE fastPainter ABOVE to PAINTER
        draw_digit_grid(line,col);
        }


void MustuxLcd::clear_digits (int line, int startCol, int endCol)
        {
        for (int i = startCol;i <= endCol; i++)
                clear_digit(line, i);
        }


void MustuxLcd::clear_line(int line)
        {
        clear_digits(line, 0, maxDigits);
        }


void MustuxLcd::draw_digit_grid(int line, int col)
        {
        fastPainter->setPen(QColor(60,70,60));
        for (int k=0; k<digitVSize; k++)
                for (int j=0; j<digitHSize; j++)
                        {
                        int x = gridMarginLeft + col*hdelta + (j*scale);
                        int y = gridMarginUp   + line*vdelta + (k*scale);
                        fastPainter->drawRect(x,y,gridDotSize,gridDotSize);
                        }
        //update(gridMarginLeft + (col-1)*hdelta ,gridMarginUp   + (line-1)*vdelta,hdelta,vdelta);IF YOU UNCOMMENT ME, CHANGE fastPainter ABOVE to PAINTER
        }


void MustuxLcd::draw_digits_grids(int line, int startCol, int endCol)
        {
        for (int c=startCol; c <= endCol; c++)
                draw_digit_grid(line,c);
        }


void MustuxLcd::draw_line_grid(int line)
        {
        draw_digits_grids(line, 0, maxDigits);
        }


void MustuxLcd::draw_all_grids()
        {
        for (int i=0; i<5; i++)
                        draw_line_grid(i);
        }


void MustuxLcd::draw_digit(int index, int line, int col)
        {
        for (int x=0; x<digitHSize; x++)
                for (int y=0; y<digitVSize; y++)
                        {
                        if (digit[index][y][x]!=' ')
                                fastPainter->fillRect(
                                                   gridMarginLeft +  col *hdelta + (x*scale),
                                                   gridMarginUp   +  line*vdelta + (y*scale),
                                                   dotSize, dotSize,
                                                   Qt::black);
                        }
        //update(gridMarginLeft + (col-1)*hdelta ,gridMarginUp + (line-1)*vdelta,hdelta,vdelta);
        }



void MustuxLcd::print (QString s, int line)
        {
        print(s, line, 0, true);
        }


void MustuxLcd::print (QString s, int line, int col)
        {
        print (s, line, col, true);
        }


void MustuxLcd::print (QString s, int line, bool clean)
        {
        print (s, line, 0, clean);
        }


void MustuxLcd::print (QString s, int line, int col, bool clean)
        {
        const char* cs = static_cast<const char*>(s.latin1());
        if (clean)
                {
                clear_line(line);
                }
        else
                {
                clear_digits (line, col, col + s.length());
                }
        int i=0;
        while (cs[i])
                {
                draw_digit(cs[i]-32, line, i+col);
                i++;
                }
        }


void MustuxLcd::roll_message( QString text , int vel, int line )
        {
        welcomeText = text;
        welcomeIndex = 0;
        welcomeTimer->start(vel);
        rollLine = line;
        }


void MustuxLcd::scroll_welcome()
        {
        QString s;
        int md = get_max_digits();
        if (welcomeIndex < (md+20))
                {
                s = welcomeText.mid(welcomeIndex,1);
                if ((s) && (s.length()>0) && (welcomeIndex < md))
                        {
                        print(s, rollLine, welcomeIndex, false);
                        }
                }
        else
                {
                clear_line(rollLine);
                s = welcomeText.mid(welcomeIndex - md - 20, md);
                if (s) print(s, rollLine, 0, false);
                }
        welcomeIndex++;

        if (welcomeIndex >= (int) welcomeText.length()+20)
                {
                welcomeTimer->stop();
                }
        }


int MustuxLcd::get_max_digits() const
        {
        return maxDigits;
        }





void MustuxLcd::draw_background_grid()
        {
        /*  MUST BE REVIEWD...
        int gridxpoints = (width()-10)  / dotHSpace;
        int gridypoints = (height()-10) / dotVSpace;
        for (int i=0; i<gridxpoints; i++)
                for (int j=0; j<gridypoints; j++)
                        {
                        painter->fillRect( 5 + i * dotHSpace,
                                        5 + j * dotVSpace,
                                        1, 1, QColor(90,90,90));
                        }
        update();
        */
        }


char MustuxLcd::digit[MAXSYMBOLS][8][6] =
                               {{ // space
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                { // !
                                "  0  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "     ",
                                "  O  ",
                                "     "},
                                { // "
                                "     ",
                                "     ",
                                " O O ",
                                " O O ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                { // #
                                " O O ",
                                " O   ",
                                "OOOOO",
                                " O O ",
                                "OOOOO",
                                " O O ",
                                " O O ",
                                "     "},
                                { // $
                                "  O  ",
                                " OOO ",
                                "O   O",
                                " OO  ",
                                "  OO ",
                                "    O",
                                " OOO ",
                                "  O  "},
                                { // %
                                " O   ",
                                "O O O",
                                " O O ",
                                "  O  ",
                                " O O ",
                                "O O O",
                                "   O ",
                                "     "},
                                { // &
                                " OOO ",
                                "O   O",
                                " O   ",
                                " OO  ",
                                "O O  ",
                                "O  O ",
                                " OO O",
                                "     "},
                                { // '
                                "  O  ",
                                "  O  ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                { // (
                                "   O ",
                                "  O  ",
                                " O   ",
                                " O   ",
                                " O   ",
                                " O   ",
                                "  O  ",
                                "   O "},
                                { // )
                                " O   ",
                                "  O  ",
                                "   O ",
                                "   O ",
                                "   O ",
                                "   O ",
                                "  O  ",
                                " O   "},
                                { // *
                                "  O  ",
                                "O O O",
                                " OOO ",
                                "OOOOO",
                                " OOO ",
                                "O O O",
                                "  O  ",
                                "     "},
                                { // +
                                "     ",
                                "  O  ",
                                "  O  ",
                                "OOOOO",
                                "  O  ",
                                "  O  ",
                                "     ",
                                "     "},
                                { // ,
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "  O  ",
                                " O   "},

                                { // -
                                "     ",
                                "     ",
                                "     ",
                                " OOO ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                { // .
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "  O  ",
                                "     "},
                                { // /
                                "   O ",
                                "   O ",
                                "  O  ",
                                "  O  ",
                                " O   ",
                                " O   ",
                                "     ",
                                "     "},
                                { //
                                "  O  ",
                                " O O ",
                                "O   O",
                                "O   O",
                                "O   O",
                                " O O ",
                                "  O  ",
                                "     "},
                                { // O
                                "  O  ",
                                " OO  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                " OOO ",
                                "     "},
                                { // 2
                                " OOO ",
                                "O   O",
                                "    O",
                                "  OO ",
                                " O   ",
                                "O    ",
                                "OOOOO",
                                "     "},
                                { // 3
                                " OOO ",
                                "O   O",
                                "    O",
                                "  OO ",
                                "    O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {// 4
                                "  OO ",
                                " O O ",
                                "O  O ",
                                "OOOO ",
                                "   O ",
                                "   O ",
                                "  OOO",
                                "     "},
                                {// 5
                                "OOOOO",
                                "O    ",
                                "O    ",
                                "OOOO ",
                                "    O",
                                "O   O",
                                " OOO ",
                                "     "},
                                { // 6
                                " OOO ",
                                "O   O",
                                "O    ",
                                "OOOO ",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                { //7
                                "OOOOO",
                                "    O",
                                "   O ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "     "},
                                { // 8
                                " OOO ",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                { // 9
                                " OOO ",
                                "O   O",
                                "O   O",
                                " OOOO",
                                "    O",
                                "    O",
                                " OOO ",
                                "     "},
                                { // :
                                "     ",
                                "     ",
                                "  O  ",
                                "     ",
                                "  O  ",
                                "     ",
                                "     ",
                                "     "},
                                { // ;
                                "     ",
                                "     ",
                                "     ",
                                "  O  ",
                                "     ",
                                "  O  ",
                                "  O  ",
                                " O   "},
                                { // <
                                "   O ",
                                "  O  ",
                                " O   ",
                                "O    ",
                                " O   ",
                                "  O  ",
                                "   O ",
                                "     "},
                                { // =
                                "     ",
                                "     ",
                                " OOO ",
                                "     ",
                                " OOO ",
                                "     ",
                                "     ",
                                "     "},
                                { // >
                                " O   ",
                                "  O  ",
                                "   O ",
                                "    O",
                                "   O ",
                                "  O  ",
                                " O   ",
                                "     "},
                                { // ?
                                " OOO ",
                                "O   O",
                                "    O",
                                "   O ",
                                "  O  ",
                                "     ",
                                "  O  ",
                                "     "},
                                { // @
                                " OOOO",
                                "O   O",
                                "O  OO",
                                "O O O",
                                "O  OO",
                                "O    ",
                                " OOO ",
                                "     "},
                                { // A
                                "  O  ",
                                " O O ",
                                "O   O",
                                "O   O",
                                "OOOOO",
                                "O   O",
                                "O   O",
                                "     ",
                                },
                                {
                                "OOOO ",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "     "},
                                {
                                " OOO ",
                                "O   O",
                                "O    ",
                                "O    ",
                                "O    ",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "OOOO ",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "     "},
                                {
                                "OOOOO",
                                "O    ",
                                "O    ",
                                "OOOO ",
                                "O    ",
                                "O    ",
                                "OOOOO",
                                "     "},
                                {
                                "OOOOO",
                                "O    ",
                                "O    ",
                                "OOOO ",
                                "O    ",
                                "O    ",
                                "O    ",
                                "     "},
                                {
                                " OOO ",
                                "O   O",
                                "O    ",
                                "O  OO",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                "O   O",
                                "OOOOO",
                                "O   O",
                                "O   O",
                                "O   O",
                                "     "},
                                {
                                " OOO ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                " OOO ",
                                "     "},
                                {
                                "  OOO",
                                "   O ",
                                "   O ",
                                "   O ",
                                "O  O ",
                                "O  O ",
                                " OO  ",
                                "     "},
                                {
                                "O   O",
                                "O  O ",
                                "O O  ",
                                "OO   ",
                                "O O  ",
                                "O  O ",
                                "O   O",
                                "     "},
                                {
                                "O    ",
                                "O    ",
                                "O    ",
                                "O    ",
                                "O    ",
                                "O    ",
                                "OOOOO",
                                "     "},
                                {
                                "O   O",
                                "OO OO",
                                "O O O",
                                "O O O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "     "},
                                {
                                "O   O",
                                "OO  O",
                                "O O O",
                                "O O O",
                                "O  OO",
                                "O   O",
                                "O   O",
                                "     "},
                                {
                                " OOO ",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "OOOO ",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "O    ",
                                "O    ",
                                "O    ",
                                "     "},
                                {
                                " OOO ",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O  O ",
                                " OO O",
                                "     "},
                                {
                                "OOOO ",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "O O  ",
                                "O  O ",
                                "O   O",
                                "     "},
                                {
                                " OOO ",
                                "O   O",
                                "O    ",
                                " OOO ",
                                "    O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "OOOOO",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                " O O ",
                                "  O  ",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                "O   O",
                                "O O O",
                                "O O O",
                                " O O ",
                                " O O ",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                " O O ",
                                "  O  ",
                                " O O ",
                                "O   O",
                                "O   O",
                                "     "},
                                {
                                "O   O",
                                "O   O",
                                " O O ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "     "},
                                {
                                "OOOOO",
                                "    O",
                                "   O ",
                                "  O  ",
                                " O   ",
                                "O    ",
                                "OOOOO",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},

                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     ",
                                "     "},


                                {
                                "     ",
                                "     ",
                                " OOO ",
                                "    O",
                                " OOOO",
                                "O   O",
                                " OOOO",
                                "     "},
                                {
                                "0    ",
                                "O    ",
                                "O000 ",
                                "O   0",
                                "O   O",
                                "O   O",
                                "OOOO ",
                                "     "},

                                {
                                "     ",
                                "     ",
                                " OOO ",
                                "O   O",
                                "O    ",
                                "O   O",
                                " OOO ",
                                "     "},


                                {
                                "    0",
                                "    O",
                                " 000O",
                                "0   O",
                                "O   O",
                                "O   O",
                                " OOOO",
                                "     "},
                                {
                                "     ",
                                "     ",
                                " OOO ",
                                "O   O",
                                "OOOOO",
                                "O    ",
                                " OOO ",
                                "     "},
                                {
                                "   00",
                                "  0  ",
                                "  0  ",
                                "  0  ",
                                " O00 ",
                                "  0  ",
                                "  0  ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                " 000 ",
                                "0   0",
                                "O   O",
                                " 000O",
                                "    0",
                                " OOO "},
                                {
                                "0    ",
                                "0    ",
                                "O000 ",
                                "O   0",
                                "O   0",
                                "O   O",
                                "O   O",
                                "     "},
                                {
                                "  0  ",
                                "     ",
                                " 00  ",
                                "  0  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "     "},
                                {
                                "   0 ",
                                "     ",
                                "  000",
                                "   0 ",
                                "   O ",
                                "   O ",
                                "O  O ",
                                " OO  "},
                                {
                                "     ",
                                "O    ",
                                "O O  ",
                                "OO   ",
                                "OO   ",
                                "O O  ",
                                "O  O ",
                                "     "},
                                {
                                " 00  ",
                                "  0  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                "  O  ",
                                " OOO ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "00 0 ",
                                "0 0 0",
                                "O O O",
                                "O O O",
                                "O O O",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O OO ",
                                " O  O",
                                " O  O",
                                " O  O",
                                " O  O",
                                "     "},
                                {
                                "     ",
                                "     ",
                                " OOO ",
                                "O   O",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O OO ",
                                " O  O",
                                " O  O",
                                " O  0",
                                " O00 ",
                                " O   "},
                                {
                                "     ",
                                "     ",
                                " OO O",
                                "O  O ",
                                "O  O ",
                                "0  O ",
                                " 00O ",
                                "   O "},
                                {
                                "     ",
                                "     ",
                                "O OO ",
                                " O  O",
                                " O   ",
                                " O   ",
                                " O   ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                " OOO0",
                                "O    ",
                                " OOO ",
                                "    O",
                                "0OOO ",
                                "     "},
                                {
                                "     ",
                                " 0   ",
                                "0000 ",
                                " 0   ",
                                " 0   ",
                                " 0   ",
                                "  0O ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O   O",
                                "O   O",
                                "O   O",
                                "O   O",
                                " OOO ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O   O",
                                "O   O",
                                "O   O",
                                " O O ",
                                "  O  ",
                                "     "},

                                {
                                "     ",
                                "     ",
                                "O   O",
                                "O O O",
                                "O O O",
                                "O O O",
                                " OOO ",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O   O",
                                " O O ",
                                "  O  ",
                                " O O ",
                                "O   O",
                                "     "},
                                {
                                "     ",
                                "     ",
                                "O   0",
                                "O   0",
                                "O   0",
                                " OOO0",
                                "    0",
                                " OO0 "},
                                {
                                "     ",
                                "     ",
                                "OOOOO",
                                "   O ",
                                "  O  ",
                                " O   ",
                                "OOOOO",
                                "     "}};

//eof
