/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef MUSTUXINTERFACE_HH
#define MUSTUXINTERFACE_HH

#include <qwidget.h>
#include <qstring.h>

class MustuxJogMouseBoard;
class MustuxJogMouseBoardMessage;
class MustuxLcd;

class MustuxInterface : public QWidget
        {
        public:
                /** Constructs a Mustux basic interface using parent as parent widget.
                * A basic Mustux interface contains a default LCD and a internal JMB engine.
                */
                MustuxInterface(QWidget *parent);
                ~MustuxInterface();

                /** Prints mesg into the default lcd */
                void info(QString mesg);

                /** automatically called whenever JMB catches an action on the keyboard*/
                virtual int process_jmb_action( MustuxJogMouseBoardMessage* m);

                /** set the default LCD component */
                void set_default_lcd(MustuxLcd* pLcd);

                /** get the default LCD */
                MustuxLcd* get_default_lcd();


        protected :
                MustuxLcd* defaultLcd;
                MustuxJogMouseBoard* jmb;
                void keyPressEvent ( QKeyEvent * );
                void keyReleaseEvent ( QKeyEvent * );
        };


#include "MustuxJogMouseBoard.hh"
#include "MustuxJogMouseBoardMessage.hh"
#include "MustuxLcd.hh"

#endif


// eof

