/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#include "MustuxInterface.hh"
#include "MustuxDebugger.hh"


MustuxInterface::MustuxInterface( QWidget *parent) : QWidget( parent, (char*) 0 )
        {
        PENTERCONS;
        jmb = new MustuxJogMouseBoard(this);
        PEXITCONS;
        }


MustuxInterface::~MustuxInterface()
        {
        PENTERDES;
        PEXITDES;
        }

void MustuxInterface::info(QString mesg)
        {
        PENTER;
        PMESG(mesg);
        if (!defaultLcd)
                {
                PERROR("Default LCD not set in MustuxInterface::info(String)");
                }
        else
                defaultLcd->print(mesg, 1, 1);
        PEXIT;
        }

void MustuxInterface::set_default_lcd(MustuxLcd* pLcd)
        {
        defaultLcd=pLcd;
        }


MustuxLcd* MustuxInterface::get_default_lcd()
        {
        return defaultLcd;
        }

int MustuxInterface::process_jmb_action(MustuxJogMouseBoardMessage* m)
        {
        PMESG("What I am doing here? I am supposed to be re-implemented in sub-classes!");
        return 0;
        }


void MustuxInterface::keyPressEvent( QKeyEvent * e)
        {
        if (!e->isAutoRepeat())
                jmb->catch_press(e);
        e->ignore();
        }

void MustuxInterface::keyReleaseEvent( QKeyEvent * e)
        {
        if (!e->isAutoRepeat())
                jmb->catch_release(e);
        e->ignore();

        }


// eof

