#ifndef MUSTUXFFT_HH
#define MUSTUXFFT_HH

#define MAX_FFT_SIZE 32768
#define PI 3.14159265358979323846
#define PI2 2.*PI
#define IS_POWER_OF_TWO(x) ( (x>=2) && !( x & (x-1) ) )


// THIS CLASS IS CONSUMING TOO MUCH MEMORY. MUST SOME KIND OF OPTIMIZATION
class MustuxFft
                {
                public :

                        static const float NORMALIZATION_FACTOR = 50.0; // EMPIRIC.. FOR A STATIC 440 SINOIDE WAVE WITH MAX APLITUDE , THE POWER SPECTRUM WAS 8800. This way, it becomes 100 in the normalization.

                        MustuxFft(int pSize, int pWinType = 1, int pSampleRate=44100);
                        ~MustuxFft();


                        void perform(float* pInputData, float* pOutputLevels);
                        float index_to_frequency( int index );
                        int frequency_to_index ( float freq);

                        // this is not the audio noise level. This is the SPECTRUM noise level !
                        float get_level_noise_line();

                        // The outputLevels array is normalized to 0.0 .. 100.0
                        void set_level_noise_line(float val);

                        static int const HAMMING_WINDOW = 1;
                        static int const VON_HANN_WINDOW = 2;
                        static int const BLACKMANN_WINDOW = 3;
                        static int const BARTLETT_WINDOW = 4;
                        static int const BLACKMAN_HARRIS_WINDOW =5;

                private:
                        float buf_re[MAX_FFT_SIZE];
                        float buf_im[MAX_FFT_SIZE];
                        int size;
                        int sampleRate;
                        float windowCoef[MAX_FFT_SIZE];
                        int winType;
                        float dcComponent;
                        float noiseLine;
                        static unsigned numberOfBitsNeeded ( unsigned param );
                        static int reverseBits ( unsigned index, unsigned numBits );

                };

#endif

