/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef MUSTUXDRAWABLE_HH
#define MUSTUXDRAWABLE_HH


#include <qpainter.h>
#include <qpixmap.h>
#include <qframe.h>


class MustuxDrawable : public QWidget
        {

        public:
                MustuxDrawable( int w, int h, QWidget *parent, const char* pName = 0 );
                ~MustuxDrawable();
                void clear();
                void clear(int x, int y, int w, int h);
                virtual void recreate();
                int get_mouse_x();
                int get_mouse_y();
                void set_foreground_color(int r, int g, int b);
                void set_background_color(int r, int g, int b);

                virtual void fit(); // ?? SHOULD IT BECOME DEPRECATED ?

                QPixmap* drawArea;
                QPainter* painter;
                QPainter* fastPainter;
                
        protected:

                void paintEvent( QPaintEvent* e);
                void resizeEvent( QResizeEvent* e);


        private:
                int bgR, bgG, bgB, fgR, fgG, fgB;


        };


#endif


