/**************************************************************************************

	MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include "MustuxDrawable.hh"
#include "MustuxDebugger.hh"

#include <qscrollview.h>
#include <qwidget.h>
#include <qcolor.h>
#include <qcursor.h>

MustuxDrawable::MustuxDrawable( int w, int h, QWidget *parent, const char* pName)
	: QWidget( parent, pName, WRepaintNoErase | WResizeNoErase )	//fixme: this should be changed in WNoAutoErase as soon as possible (Qt version >= 3.2 required)
	{
	PENTERCONS;
	setUpdatesEnabled( true );
	setBackgroundMode(NoBackground);
	drawArea = new QPixmap(w, h);
	painter = new QPainter( drawArea );
	fastPainter = new QPainter ( this );
	set_background_color(0,0,0);
	set_foreground_color(255,255,255);
	setMinimumWidth(w);
	setMinimumHeight(h);
	resize(w,h);
	clear();
	PEXITCONS;
	}

MustuxDrawable::~MustuxDrawable()
	{
	PENTERDES;
	delete fastPainter;
	delete painter;
	delete drawArea;
	PEXITDES;
	}

void MustuxDrawable::paintEvent( QPaintEvent* e)
	{
	int x=e->rect().x();
	int y=e->rect().y();
	int w=e->rect().width();
	int h=e->rect().height();
	bitBlt(fastPainter->device(), x, y, painter->device(), x, y, w, h, Qt::CopyROP, false); // WAS fastPainter->drawPixmap(x,y, *drawArea, x,y,w,h);
	}

void MustuxDrawable::resizeEvent( QResizeEvent* e)
	{
	delete painter;
	delete drawArea;        
	int w=width();
	int h=height();
	drawArea=new QPixmap(w,h);
	painter = new QPainter( drawArea );
	clear();
	}



void MustuxDrawable::clear()
	{
	drawArea->fill(QColor(bgR,bgG,bgB));
	}



void MustuxDrawable::clear(int x, int y, int w, int h)
	{
	painter->fillRect(x,y,w,h,QColor(bgR,bgG,bgB));
	update(x,y,w,h);
	}



void MustuxDrawable::set_background_color(int r, int g, int b)
	{
	bgR=r;
	bgG=g;
	bgB=b;
	setBackgroundColor(QColor(r,g,b));
	}



void MustuxDrawable::set_foreground_color(int r, int g, int b)
	{
	fgR=r;
	fgG=g;
	fgB=b;
	painter->setPen(QColor(r,g,b));
	}



void MustuxDrawable::fit() // virtual // ?? SHOULD IT BECOME DEPRECATED ?
	{
	PERROR("oops.. I am virtual !!!");
	}



void MustuxDrawable::recreate() // virtual
	{
	PERROR("oops.. I am virtual !!!");
	}



int MustuxDrawable::get_mouse_x()
	{
	return mapFromGlobal(QCursor::pos()).x();
	}


int MustuxDrawable::get_mouse_y()
	{
	return mapFromGlobal(QCursor::pos()).y();
	}
//eof
