/**************************************************************************************

        MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/


#include <stdlib.h>
#include <stdio.h>

#include "MustuxDebugger.hh"

namespace MustuxDebugger
        {
        int ntabs = 0;
        int debugLevel = OFF;
        FILE* logFile = (FILE*) 0;
        QString logFileName = 0;
        bool logging = false;
        }

void MustuxDebugger::fill_tabs()
        {
        for (int i=0; i < ntabs; i++) printf("|   ");
        }

QString MustuxDebugger::get_tabs()
        {
        QString t="";
        for (int i=0; i < ntabs; i++) t=t.append("   ");
        return t;
        }


void MustuxDebugger::more_tabs()
        {
        ntabs++;
        }


void MustuxDebugger::less_tabs()
        {
        ntabs--;
        }


void MustuxDebugger::set_debug_level(int l)
        {
        debugLevel = l;
        }


int MustuxDebugger::get_debug_level()
        {
        return debugLevel;
        }


void MustuxDebugger::create_log(QString fn)
        {
        logFileName = QString(getenv("HOME")) + "/" + fn;
        logFile = fopen((const char*)logFileName.ascii(),"a+");
        if (!logFile)
                {
                PERROR("Cannot create MustuxDebugger Log file (%s)",fn.ascii());
                logging=false;
                }
        else
                {
                fclose(logFile);
                logging=true;
                }
        }



void MustuxDebugger::close_log()
        {
        logging=false;
        }



void MustuxDebugger::log(QString s)
        {
        const char* sc = s.ascii();
        int len = s.length();
        logFile = fopen(logFileName.ascii(),"a+");
        fwrite(sc,len,1,logFile);
        fclose(logFile);
        }

bool MustuxDebugger::is_logging()
        {
        return logging;
        }





//eof

