/**************************************************************************************

	MUSTUXLIB - THE COMMON LIBRARY FOR ALL MUSTUX APPLICATIONS
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#ifndef MUSTUXAUDIOBUS_HH
#define MUSTUXAUDIOBUS_HH

#define ALSA_PCM_NEW_HW_PARAMS_API
#include <alsa/asoundlib.h>

#include <qstring.h>
#include <qthread.h>

// These are auxiliary classes, not meant to be used directly by user.

class MustuxAudioBusTransferResult;
class BusMode;


class Bus
	{
	public:
		static const int MONO = 1;
		static const int STEREO = 2;
		static const int MAX_SCB_MODES = 34;
		static const int CLOSED = 0;
		static const int PLAYING_TO_MONO = 1;
		static const int PLAYING_TO_STEREO = 2;
		static const int PLAYING_TO_LEFT_CHANNEL  = 3;
		static const int PLAYING_TO_RIGHT_CHANNEL  = 4;
		static const int CAPTURING_FROM_MONO = 5;
		static const int CAPTURING_FROM_STEREO = 6;
		static const int CAPTURING_FROM_LEFT_CHANNEL = 7;
		static const int CAPTURING_FROM_RIGHT_CHANNEL = 8;

		Bus(int pParentCardId, int pId, int pStream, QString desc);
		~Bus();

		void probe_valid_modes();
		int supports(int pRate, int pBitDepht, int pChannels, int pStream);
		bool valid_mode(int pRate, int pBitDepht, int pChannels);
		int open(int pRate, int pBitDepht, int whichChannels,bool block=true, float suggestedFragmentsPerSecond = 10.0);
		float get_fps();
		int get_transfer_size();
		char* get_transfer_buffer(int whichChannels);
		MustuxAudioBusTransferResult* transfer(int bytesToTransfer=-1);
		void clean_buffer();
		int close();
		bool allocated_for_playback();
		bool allocated_for_capture();
		bool is_stereo();
		QString get_short_name();
		QString get_full_name();
		QString get_descriptor();

		// levels inside the bus is seens as float
		// so it will be easir to implement floating point audio format levels
		// in the future.
		float* get_levels();
                float* levels;

		int transferError;
		int bytesToTransfer;
		int stream;   // CAPTURE or PLAYBACK
		int parentCardId;
		int id;
		int status;
		bool stereoBus;
		int blockSize;
		snd_pcm_t* pcmHandle;
		snd_pcm_hw_params_t* hwparams;
		snd_pcm_format_t format;
		MustuxAudioBusTransferResult* transferResult;
		QString descriptor; // those "hw:x,x" ALSA descriptors

		char* transferBuffer;
		int transferSize;
		int partialPeriodSize;
		snd_pcm_uframes_t periodSize;
		float fragmentsPerSecond;

		BusMode* busMode[MAX_SCB_MODES];

	private:
		QString get_real_descriptor();

	};

class BusMode
	{
	public:
		BusMode(int rate , int channels, int bitdepht)
			{
			this->rate=rate;
			this->channels=channels;
			this->bitDepht=bitdepht;
			this->valid=false;
			}
		QString get_name()
			{
			QString s1; s1.setNum(rate);
			QString s2 = (channels==Bus::MONO?"MONO":"STEREO");
			QString s3; s3.setNum(bitDepht);
			return QString(s1 + " Hz " +  s2 + " " + s3 + " bits");
			}
		int rate;
		int channels;
		int bitDepht;
		bool valid;
	};

#include "MustuxAudioDeviceMapper.hh"
#endif


