/*
 * proccpuinfo.h - public interface for libproccpuinfo
 *
 * Copyright (C) 2006, 2007, 2008, 2009 Thomas Cort <tcort@tomcort.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PROCCPUINFO_H
#define __PROCCPUINFO_H

typedef struct proccpuinfo {
	unsigned short version;
	char *architecture;
	char *hardware_platform;
	double frequency;		/* in MHz */
	double bogomips;
	unsigned int cache;		/* in KB  */
	unsigned int cpus;		/* number of processors */
	char *cputype;
} proccpuinfo;

proccpuinfo *proccpuinfo_read();
void proccpuinfo_free(proccpuinfo *);

int   proccpuinfo_get_arch();
char *proccpuinfo_get_filename();

void proccpuinfo_set_arch(int);
void proccpuinfo_set_filename(char*);

int proccpuinfo_decode_arch(char*);

#endif
