#include <Python.h>
#include <gmp.h>
#include <math.h>
#include <time.h>

/*
    This file is part of primerange.

    primerange is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    primerange is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with primerange.  If not, see <http://www.gnu.org/licenses/>.

    (c) 2012 Gary Wright
    http://wrightsolutions.co.uk/contact
    http://identi.ca/gnubyexample
    http://gnumbers.blogspot.com/

*/

	const char  outfstem [25] = "/tmp/setz_exp_esl";
	unsigned int	debug_flag = 0;
	unsigned int	simulate_gigantic = 0;
	char      *fexpk;
	char      *fout36;
	char      *fplanned;
	char      *fnotes;
	char      *frinprogress;
	char      *fchunkmod;
	char      date8tee4 [13];
	char      ndesc[31];
	char      *ndesc_unlimited;

	FILE      *outfexpk;
	FILE      *outfout36;
	FILE      *outfplanned;
	FILE      *outfnotes;
	FILE      *outfrinprogress;
	FILE      *outfchunkmod;
	const unsigned long NINETYNINEMILLION = 99000000;
   const unsigned long hundred_million = 100000000;
   const unsigned long thousand_million = 1000000000;
	unsigned long multiple_of_1365 = 294076965;
   unsigned int slice_size_max_2exp = 3;
   unsigned long long exp_shift_start = 0;
   int process_expk_optimisation = -999;
   unsigned long long size5_ultimate = 999;
   unsigned long long c2e_candidate;
   unsigned long long c2e_ultimate;
   const unsigned long two_to_twenty_seven = 134217728;
   const unsigned long two_to_twenty_eight = 268435456;
   const unsigned long two_to_twenty_nine  = 536870912;
   const unsigned long two_to_thirty       = 1073741824;
   const unsigned long two_to_thirty_one   = 2147483648;
   const unsigned long long two_to_thirty_two   = 4294967296;
   const unsigned long long two_to_thirty_three = 8589934592;
   const unsigned long long two_to_thirty_four  = 17179869184;
   const unsigned long long two_to_thirty_five  = 34359738368;
   const unsigned long long two_to_thirty_six   = 68719476736;
   const unsigned long long two_to_thirty_seven = 137438953472;
   const unsigned long long two_to_thirty_eight = 274877906944;
   const unsigned long long two_to_thirty_nine  = 549755813888;
   const unsigned long long two_to_fourty       = 1099511627776;
   const unsigned long long two_to_fourty_one   = 2199023255552;
   const unsigned long long two_to_fourty_two   = 4398046511104;
   const unsigned long long two_to_fourty_three = 8796093022208;
   const unsigned long long two_to_fourty_four  = 17592186044416;
   const unsigned long long two_to_fourty_five  = 35184372088832;
   const unsigned long long two_to_fourty_six   = 70368744177664;
   const unsigned long long two_to_fourty_seven = 140737488355328;
   const unsigned long long two_to_fourty_eight = 281474976710656;
   const unsigned long long two_to_fourty_nine  = 562949953421312;
   const unsigned long long two_to_fifty        = 1125899906842624;
   const unsigned long long two_to_fifty_one    = 2251799813685248;
   const unsigned long long two_to_fifty_two    = 4503599627370496;
   const unsigned long long two_to_fifty_three  = 9007199254740992;
   const unsigned long long two_to_fifty_four   = 18014398509481984;
   const unsigned long long two_to_fifty_five   = 36028797018963968;
   const unsigned long long two_to_fifty_six    = 72057594037927936;
   const unsigned long long two_to_fifty_seven  = 144115188075855872;
   const unsigned long long two_to_fifty_eight  = 288230376151711744;
   const unsigned long long two_to_fifty_nine   = 576460752303423488;
   const unsigned long long two_to_sixty        = 1152921504606846976;
   const unsigned long long two_to_sixty_one    = 2305843009213693952;
   const unsigned long long two_to_sixty_two    = 4611686018427387904;
   const unsigned long long two_to_sixty_three  = 9223372036854775808;
   /* for(i=27,63,print("2^"i"="2^i";")) 
		http://packages.debian.org/stable/pari-gp */

	const double tend = 10.0;
	mpz_t		ONE;
	mpz_t		TWO;
	mpz_t    HUNDRED_MILLION;
	mpz_t    THOUSAND_MILLION;
	mpz_t    TEN_THOUSAND_MILLION;
	mpz_t		THIRTEENSIXTYFIVE;
	mpz_t		FOURZERONINEFIVE;
	mpz_t		FIVEFOURSIXTY;
	mpz_t		MULTIPLE_OF_1365; 
	mpz_t		N,N_ALG;
	mpz_t		R_IN_PROGRESS_LIMITED_INPUT;
	mpz_t		R_IN_PROGRESS_LIMITED;
	mpz_t		R1, R2, RA, R; 
	mpz_t		A,A_ALG;
	mpz_t		HALF_OF_TWO_TO_K;
	mpz_t		CHUNK_MOD_CANDIDATE;
   mpz_t		CHUNK_MOD_ULTIMATE;
   mpz_t    A_LL_TO_EXP;

   mpz_t TWO_TO_TWENTY_SEVEN;
   mpz_t TWO_TO_TWENTY_EIGHT;
   mpz_t TWO_TO_TWENTY_NINE ;
   mpz_t TWO_TO_THIRTY      ;
   mpz_t TWO_TO_THIRTY_ONE  ;
   mpz_t TWO_TO_THIRTY_TWO  ;
   mpz_t TWO_TO_THIRTY_THREE;
   mpz_t TWO_TO_THIRTY_FOUR ;
   mpz_t TWO_TO_THIRTY_FIVE ;
   mpz_t TWO_TO_THIRTY_SIX  ;
   mpz_t TWO_TO_THIRTY_SEVEN;
   mpz_t TWO_TO_THIRTY_EIGHT;
   mpz_t TWO_TO_THIRTY_NINE ;
   mpz_t TWO_TO_FOURTY      ;
   mpz_t TWO_TO_FOURTY_ONE  ;
   mpz_t TWO_TO_FOURTY_TWO  ;
   mpz_t TWO_TO_FOURTY_THREE;
   mpz_t TWO_TO_FOURTY_FOUR ;
   mpz_t TWO_TO_FOURTY_FIVE ;
   mpz_t TWO_TO_FOURTY_SIX  ;
   mpz_t TWO_TO_FOURTY_SEVEN;
   mpz_t TWO_TO_FOURTY_EIGHT;
   mpz_t TWO_TO_FOURTY_NINE ;
   mpz_t TWO_TO_FIFTY       ;
   mpz_t TWO_TO_FIFTY_ONE   ;
   mpz_t TWO_TO_FIFTY_TWO   ;
   mpz_t TWO_TO_FIFTY_THREE ;
   mpz_t TWO_TO_FIFTY_FOUR  ;
   mpz_t TWO_TO_FIFTY_FIVE  ;
   mpz_t TWO_TO_FIFTY_SIX   ;
   mpz_t TWO_TO_FIFTY_SEVEN ;
   mpz_t TWO_TO_FIFTY_EIGHT ;
   mpz_t TWO_TO_FIFTY_NINE  ;
   mpz_t TWO_TO_SIXTY       ;
   mpz_t TWO_TO_SIXTY_ONE   ;
   mpz_t TWO_TO_SIXTY_TWO   ;
   mpz_t TWO_TO_SIXTY_THREE ;

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long size2gmp(unsigned long num_long) {
  mpz_t NUM_LONG;
  unsigned long sibt = 0;
  mpz_init_set_ui(NUM_LONG, num_long);
  sibt = (long)mpz_sizeinbase(NUM_LONG,2);
  mpz_clear(NUM_LONG);
  return sibt;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(size2gmp__doc__,
"Calculate (and return) number of portions.");

/* Wrapper around the underlying C function */
static PyObject *
py_size2gmp(PyObject *self, PyObject *args)
{
  /* The function size2gmp() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long s2gmpresult;
	unsigned long num_l;
	/* "args" signature is long */
	/* ':size2gmp' for error messages */
	if (!PyArg_ParseTuple(args, "l:size2gmp", &num_l))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	s2gmpresult = size2gmp(num_l);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)s2gmpresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long size2longlong(unsigned long long num_ll) {
  mpz_t NUM_LL;
  unsigned long sibt = 0;
  mpz_init_set_ui(NUM_LL, num_ll);
  sibt = (long long)mpz_sizeinbase(NUM_LL,2);
  mpz_clear(NUM_LL);
  return sibt;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(size2longlong__doc__,
"Calculate (and return) number of portions - ll variant.");

/* Wrapper around the underlying C function */
static PyObject *
py_size2longlong(PyObject *self, PyObject *args)
{
  /* The function size2longlong() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long s2result;
	unsigned long num_l;
	/* "args" signature is long */
	/* ':size2longlong' for error messages */
	if (!PyArg_ParseTuple(args, "l:size2longlong", &num_l))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	s2result = size2longlong((unsigned long long)num_l);

	if (s2result > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)s2result);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long a_pow_2exp_limited(unsigned long long a_ll, unsigned int two_exp_int) {
  extern mpz_t A;
  mpz_t A_LL;
  extern mpz_t A_LL_TO_EXP;
  extern const unsigned long two_to_thirty;
  mpz_t A_TO_TWO_TO_THIRTY;
  mpz_t A_TO_TWO_TO_THIRTY_EXTRA;

  unsigned long long exponent_derived;
  unsigned long long size10;
  unsigned int thirty_times = 1;
  unsigned int thirty_extra = 0;
  unsigned int idx = 0;
  unsigned int exp_done = 0;

  /* First arg 0 indicates that mpz_t A should be used.
	  First arg > 1 indicates mpz_t A ignored, use a given as arg */
  mpz_init(A_LL);
  mpz_init(A_LL_TO_EXP);
  mpz_init(A_TO_TWO_TO_THIRTY);
  mpz_init(A_TO_TWO_TO_THIRTY_EXTRA);

  if (a_ll > 1) {
	 mpz_set_ui(A_LL,a_ll);
  } else {
	 mpz_set(A_LL,A);
  }

  if (two_exp_int < 32) {
	 exponent_derived = pow(2,two_exp_int);
	 mpz_pow_ui(A_LL,A,exponent_derived);

  } else if (two_exp_int < 128) {

	 mpz_pow_ui(A_TO_TWO_TO_THIRTY,A,two_to_thirty);
	 thirty_times = two_exp_int / 30;
	 thirty_extra = two_exp_int % 30;
	 if (thirty_times > 0) {
		mpz_set(A_LL_TO_EXP,A_TO_TWO_TO_THIRTY);
		exp_done += 30;
	 }
	 for(idx = 1; idx < thirty_times; idx++) {
		mpz_mul(A_LL_TO_EXP,A_LL_TO_EXP,A_TO_TWO_TO_THIRTY);
		exp_done += 30;
	 }
	 if (thirty_extra > 0) {
		mpz_pow_ui(A_TO_TWO_TO_THIRTY_EXTRA,A,thirty_extra);
		mpz_mul(A_LL_TO_EXP,A_LL_TO_EXP,A_TO_TWO_TO_THIRTY_EXTRA);
		exp_done += thirty_extra;
	 }
	 if (debug_flag > 0) {
		printf("a_pow_2exp_limited(%lld,%u) exp_done=%u\n",
				 a_ll,two_exp_int,exp_done);
	 }
  } else {
	 mpz_set_ui(A_LL_TO_EXP,0);
	 size10 = 0;
  }

  mpz_clear(A_LL);
  mpz_clear(A_TO_TWO_TO_THIRTY);
  mpz_clear(A_TO_TWO_TO_THIRTY_EXTRA);

  if (mpz_cmp_ui(A_LL_TO_EXP,1) > 0) {
	 size10 = mpz_sizeinbase(A_LL_TO_EXP,10);
  }
  return size10;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(a_pow_2exp_limited__doc__,
"Raise A to exponent where exponent is a given power of 2.");


/* Wrapper around the underlying C function */
static PyObject *
py_a_pow_2exp_limited(PyObject *self, PyObject *args)
{
  unsigned long a_long;
  unsigned int raise_2exp;
   long lresult;
	/* "args" signature is long, int */
	/* ':a_pow_2exp_limited' for error messages */
	if (!PyArg_ParseTuple(args, "li:a_pow_2exp_limited",
								 &a_long, &raise_2exp))
		return NULL;

	lresult = a_pow_2exp_limited((unsigned long long)a_long, raise_2exp);

	if (lresult < 0 || lresult > ULONG_MAX) {
	  return NULL;
	}

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)lresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long log_to_base_a_of_n_based_on_size10(int a_integer) {
  extern mpz_t A, N;
  extern const double tend;
  double d_a;
  double d_numerator;
  double d_denominator;
  double d_log_to_base_a_of_n;
  unsigned long long ll_log_to_base_a_of_n;
  unsigned long long sib_ten;
  /* passing 0 as arg means you do not override A and function will obtain
	  from mpz_get_ui(A) */
  if (a_integer > 1) {
	 d_a = (double)a_integer;
	 /* a_integer is a testing aid - try a_integer=10 or a_integer=11 */
  } else {
	 d_a = (double)mpz_get_ui(A);
  }
  sib_ten = mpz_sizeinbase(N,10);
  d_numerator = sib_ten * log(tend);
  d_denominator = log(d_a);
  d_log_to_base_a_of_n = floor(d_numerator / d_denominator);
  ll_log_to_base_a_of_n = (unsigned long long)d_log_to_base_a_of_n;
  return (ll_log_to_base_a_of_n-1);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(log_to_base_a_of_n_based_on_size10__doc__,
"log to base a of n - rough guide - returns value rounded down to positive integer");


/* Wrapper around the underlying C function */
static PyObject *
py_log_to_base_a_of_n_based_on_size10(PyObject *self, PyObject *args)
{
  unsigned int a_int;
   long lresult;
	/* "args" signature is int */
	/* ':log_to_base_a_of_n_based_on_size10' for error messages */
	if (!PyArg_ParseTuple(args, "i:log_to_base_a_of_n_based_on_size10",
								 &a_int))
		return NULL;

	lresult = log_to_base_a_of_n_based_on_size10(a_int);

	if (lresult < 0 || lresult > ULONG_MAX) {
	  return NULL;
	}

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)lresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long log_to_base_a_of_n_veryapprox(void) {
  extern mpz_t A, N;
  mpz_t A_POWERED;
  unsigned long long power = 3;
  mpz_init(A_POWERED);
  for(power = 2;power < ULLONG_MAX; power++) {
	 mpz_pow_ui(A_POWERED,A,power);
	 if (mpz_cmp(A_POWERED,N) > 0) {
		break;
	 }
  }
  return (power-1);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(log_to_base_a_of_n_veryapprox__doc__,
"log to base a of n - rough guide - returns value rounded down to positive integer");


/* Wrapper around the underlying C function */
static PyObject *
py_log_to_base_a_of_n_veryapprox(PyObject *self, PyObject *args)
{
   long lresult;
	/* "args" - there are none */
	
	lresult = log_to_base_a_of_n_veryapprox();

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)lresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_mod_prefix_suffix_outfile(unsigned int prefix_num_alpha,
																	unsigned int cm1_num,
																	unsigned int infix_num_alpha,
																	unsigned int cm2_num,
																	unsigned int suffix_num_alpha) {

  extern unsigned int debug_flag;
  extern FILE		*outfchunkmod;
  extern unsigned long long c2e_candidate;
  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_CANDIDATE;
  extern mpz_t		CHUNK_MOD_ULTIMATE;

  unsigned long long outCM1len = 0;
  char      *outCM1;
  char      *outCM1tail;
  unsigned long long outCM2len = 0;
  char      *outCM2;
  char      *outCM2tail;

  /* An example (0,1,2,9,0) illustrates the workings of this function.
	  Output line consists of four parts: prefix then number then
	  infix then number then suffix.
	  chunk_mod_prefix_suffix_outfile(0,1,2,9,0);
	  0,1,2,9,0 is saying the following:
	    No prefix
		 Output a number (large) decimal representation - selected by 1
		 Some infix (selected by 2) - 2 is the word 'beats'
		 Output a second (large) decimal representation - selected by 9
		 No suffix
  */

  if (cm1_num == 1) {
	 /* 1 selects ULTIMATE */
	 outCM1 = mpz_get_str(NULL,10,CHUNK_MOD_ULTIMATE);
  } else {
	 /* 9 selects CANDIDATE */
	 outCM1 = mpz_get_str(NULL,10,CHUNK_MOD_CANDIDATE);
  }
  outCM1len = strlen(outCM1);

  if (cm2_num == 1) {
	 /* 1 selects ULTIMATE */
	 outCM2 = mpz_get_str(NULL,10,CHUNK_MOD_ULTIMATE);
  } else {
	 /* 9 selects CANDIDATE */
	 outCM2 = mpz_get_str(NULL,10,CHUNK_MOD_CANDIDATE);
  }
  outCM2len = strlen(outCM2);

  asprintf(&outCM1tail,"%s",&outCM1[(outCM1len-10)]);
  asprintf(&outCM2tail,"%s",&outCM1[(outCM2len-10)]);

  /* suffix usually includes a trailing space */
  if (prefix_num_alpha > 0) {
	 if (prefix_num_alpha == 27) {
		gmp_fprintf(outfchunkmod,"HALF_OF_TWO_TO_K=%Zd ",
						HALF_OF_TWO_TO_K);
	 }
  }

  switch(cm1_num) {
  case 0:
	 break;
  case 1:
	 fprintf(outfchunkmod,"CHUNK_MOD_ULTIMATE having %lld decimal digits"
				" and ending %s ",outCM1len,outCM1tail);
	 break;
  case 9:
	 fprintf(outfchunkmod,"CHUNK_MOD_CANDIDATE having %lld decimal digits"
				" and ending %s ",outCM1len,outCM1tail);
	 break;
  default:
	 break;
  }

  switch(infix_num_alpha) {
  case 0:
	 break;
  case 2:
	 fprintf(outfchunkmod,"beats ");
	 break;
  default:
	 fprintf(outfchunkmod,"infix ");
	 break;
  }

  switch(cm2_num) {
  case 0:
	 break;
  case 1:
	 fprintf(outfchunkmod,"CHUNK_MOD_ULTIMATE having %lld decimal digits"
				" and ending %s",outCM2len,outCM2tail);
	 break;
  case 9:
	 fprintf(outfchunkmod,"CHUNK_MOD_CANDIDATE having %lld decimal digits"
				" and ending %s",outCM2len,outCM2tail);
	 break;
  default:
	 break;
  }

  /* suffix usually includes a leading space */
  if (suffix_num_alpha > 0) {
	 switch(suffix_num_alpha) {
	 case 0:
		break;
	 case 27:
		gmp_fprintf(outfchunkmod," HALF_OF_TWO_TO_K=%Zd\n",
						HALF_OF_TWO_TO_K);
		break;
	 case 28:
		fprintf(outfchunkmod," order of output here is ");
		if (cm1_num == 9) {
		  fprintf(outfchunkmod," CANDIDATE then ULTIMATE\n");
		}
		break;
	 default:
		break;
	 } /* end of switch */
  }
  if (suffix_num_alpha == 0) {
	 /* newline to outfile manually */
	 fprintf(outfchunkmod,"\n");
  }
  fflush(outfchunkmod);

  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_mod_prefix_suffix_outfile__doc__,
"Output to file tail representations of two possibly very large decimal representations.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_mod_prefix_suffix_outfile(PyObject *self, PyObject *args)
{
  /* The function chunk_mod_prefix_suffix_outfile() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long outresult;
	unsigned int prefix;
	unsigned int cm1;
	unsigned int infix;
	unsigned int cm2;
	unsigned int suffix;
	/* "args" signature is int, int, int, int, int */
	/* ':chunk_mod_prefix_suffix_outfile' for error messages */
	if (!PyArg_ParseTuple(args, "iiiii:chunk_mod_prefix_suffix_outfile", &prefix,
								 &cm1, &infix, &cm2, &suffix))
		return NULL;

	outresult = chunk_mod_prefix_suffix_outfile(prefix, cm1, infix, cm2, suffix);

	if (outresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)outresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_mod_prefix_suffix_outfile_size10(unsigned int prefix_num_alpha,
																	unsigned int cm1_num,
																	unsigned int infix_num_alpha,
																	unsigned int cm2_num,
																	unsigned int suffix_num_alpha) {


  extern unsigned int debug_flag;
  extern const unsigned long hundred_million;
  extern FILE		*outfchunkmod;
  extern unsigned long long c2e_candidate;
  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_CANDIDATE;
  extern mpz_t		CHUNK_MOD_ULTIMATE;
  mpz_t MOD_NULL;

  unsigned long long cm1size10 = 0;
  unsigned long cm1tail = 0;
  unsigned long long cm2size10 = 0;
  unsigned long cm2tail = 0;

  /* An example (0,1,2,9,0) illustrates the workings of this function.
	  Output line consists of four parts: prefix then number then
	  infix then number then suffix.
	  chunk_mod_prefix_suffix_outfile_size10(0,1,2,9,0);
	  0,1,2,9,0 is saying the following:
	    No prefix
		 Output a number (large) decimal representation - selected by 1
		 Some infix (selected by 2) - 2 is the word 'beats'
		 Output a second (large) decimal representation - selected by 9
		 No suffix
  */

  mpz_init(MOD_NULL);

  if (cm1_num == 1) {
	 /* 1 selects ULTIMATE */
	 cm1size10 = mpz_sizeinbase(CHUNK_MOD_ULTIMATE,10);
	 cm1tail = mpz_mod_ui(MOD_NULL,CHUNK_MOD_ULTIMATE,hundred_million);
  } else {
	 /* 9 selects CANDIDATE */
	 cm1size10 = mpz_sizeinbase(CHUNK_MOD_CANDIDATE,10);
	 cm1tail = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,hundred_million);
  }

  if (cm2_num == 1) {
	 /* 1 selects ULTIMATE */
	 cm2size10 = mpz_sizeinbase(CHUNK_MOD_ULTIMATE,10);
	 cm2tail = mpz_mod_ui(MOD_NULL,CHUNK_MOD_ULTIMATE,hundred_million);
  } else {
	 /* 9 selects CANDIDATE */
	 cm2size10 = mpz_sizeinbase(CHUNK_MOD_CANDIDATE,10);
	 cm2tail = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,hundred_million);
  }

  mpz_clear(MOD_NULL);

  /* suffix usually includes a trailing space */
  if (prefix_num_alpha > 0) {
	 if (prefix_num_alpha == 27) {
		gmp_fprintf(outfchunkmod,"HALF_OF_TWO_TO_K=%Zd ",
						HALF_OF_TWO_TO_K);
	 }
  }

  switch(cm1_num) {
  case 0:
	 break;
  case 1:
	 fprintf(outfchunkmod,"CHUNK_MOD_ULTIMATE having %lld decimal digits"
				" and ending %lu ",cm1size10,cm1tail);
	 break;
  case 9:
	 fprintf(outfchunkmod,"CHUNK_MOD_CANDIDATE having %lld decimal digits"
				" and ending %lu ",cm1size10,cm1tail);
	 break;
  default:
	 break;
  }

  switch(infix_num_alpha) {
  case 0:
	 break;
  case 2:
	 fprintf(outfchunkmod,"beats ");
	 break;
  default:
	 fprintf(outfchunkmod,"infix ");
	 break;
  }

  switch(cm2_num) {
  case 0:
	 break;
  case 1:
	 fprintf(outfchunkmod,"CHUNK_MOD_ULTIMATE having %lld decimal digits"
				" and ending %lu",cm2size10,cm2tail);
	 break;
  case 9:
	 fprintf(outfchunkmod,"CHUNK_MOD_CANDIDATE having %lld decimal digits"
				" and ending %lu",cm2size10,cm2tail);
	 break;
  default:
	 break;
  }

  /* suffix usually includes a leading space */
  if (suffix_num_alpha > 0) {
	 switch(suffix_num_alpha) {
	 case 0:
		break;
	 case 27:
		gmp_fprintf(outfchunkmod," HALF_OF_TWO_TO_K=%Zd\n",
						HALF_OF_TWO_TO_K);
		break;
	 case 28:
		fprintf(outfchunkmod," order of output here is ");
		if (cm1_num == 9) {
		  fprintf(outfchunkmod," CANDIDATE then ULTIMATE\n");
		}
		break;
	 default:
		break;
	 } /* end of switch */
  }
  if (suffix_num_alpha == 0) {
	 /* newline to outfile manually */
	 fprintf(outfchunkmod,"\n");
  }
  fflush(outfchunkmod);

  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_mod_prefix_suffix_outfile_size10__doc__,
"Output to file tail representations of two possibly very large decimal representations.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_mod_prefix_suffix_outfile_size10(PyObject *self, PyObject *args)
{
  /* The function chunk_mod_prefix_suffix_outfile_size10() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long outresult;
	unsigned int prefix;
	unsigned int cm1;
	unsigned int infix;
	unsigned int cm2;
	unsigned int suffix;
	/* "args" signature is int, int, int, int, int */
	/* ':chunk_mod_prefix_suffix_outfile_size10' for error messages */
	if (!PyArg_ParseTuple(args, "iiiii:chunk_mod_prefix_suffix_outfile_size10", &prefix,
								 &cm1, &infix, &cm2, &suffix))
		return NULL;

	outresult = chunk_mod_prefix_suffix_outfile_size10(prefix, cm1, infix, cm2, suffix);

	if (outresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)outresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_mod_prefix_suffix_outfile_wrapper(
																	unsigned int prefix_num_alpha_w,
																	unsigned int cm1_num_w,
																	unsigned int infix_num_alpha_w,
																	unsigned int cm2_num_w,
																	unsigned int suffix_num_alpha_w,
																	unsigned long long kmo_w) {

  extern unsigned int debug_flag;
  extern FILE		*outfchunkmod;
  extern mpz_t		CHUNK_MOD_CANDIDATE;
  extern mpz_t		CHUNK_MOD_ULTIMATE;

  unsigned long long size10cm1 = 0;
  unsigned long long size10cm2 = 0;
  unsigned long long return_from_callchain_next = 0;

  /* An example (0,1,2,9,0) illustrates the workings of this function.
	  Output line consists of four parts: prefix then number then
	  infix then number then suffix.
	  chunk_mod_prefix_suffix_outfile_wrapper(0,1,2,9,0);
	  0,1,2,9,0 is saying the following:
	    No prefix
		 Output a number (large) decimal representation - selected by 1
		 Some infix (selected by 2) - 2 is the word 'beats'
		 Output a second (large) decimal representation - selected by 9
		 No suffix
  */

  if (cm1_num_w == 1) {
	 /* 1 selects ULTIMATE */
	 size10cm1 = mpz_sizeinbase(CHUNK_MOD_ULTIMATE,10);
  } else {
	 /* 9 selects CANDIDATE */
	 size10cm1 = mpz_sizeinbase(CHUNK_MOD_CANDIDATE,10);
  }

  if (cm2_num_w == 1) {
	 /* 1 selects ULTIMATE */
	 size10cm2 = mpz_sizeinbase(CHUNK_MOD_ULTIMATE,10);
  } else {
	 /* 9 selects CANDIDATE */
	 size10cm2 = mpz_sizeinbase(CHUNK_MOD_CANDIDATE,10);
  }

  if (kmo_w > 4000) {
	 if (prefix_num_alpha_w == 27) {
		/* override prefix_num_alpha_w where printing
			out HALF_OF_TWO_TO_K would be impractical */
		prefix_num_alpha_w = 0;
	 }
  }

  if (size10cm1 < 50 && size10cm2 < 50) {
	 if (debug_flag > 0) {
		printf("...suffix_outfile() will draw on full representation for a 10 tail\n");
	 }
	 return_from_callchain_next = chunk_mod_prefix_suffix_outfile(
																	prefix_num_alpha_w,
																	cm1_num_w,
																	infix_num_alpha_w,
																	cm2_num_w,
																	suffix_num_alpha_w);
  } else {
	 if (debug_flag > 0) {
		printf("...suffix_outfile_size10() uses mod to obtain 8 tail\n");
	 }
	 return_from_callchain_next = chunk_mod_prefix_suffix_outfile_size10(
																	prefix_num_alpha_w,
																	cm1_num_w,
																	infix_num_alpha_w,
																	cm2_num_w,
																	suffix_num_alpha_w);
  }  
  return return_from_callchain_next;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_mod_prefix_suffix_outfile_wrapper__doc__,
"Output to file tail representations of two possibly very large decimal representations.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_mod_prefix_suffix_outfile_wrapper(PyObject *self, PyObject *args)
{
  /* The function chunk_mod_prefix_suffix_outfile_wrapper() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long outresult;
	unsigned int prefix;
	unsigned int cm1;
	unsigned int infix;
	unsigned int cm2;
	unsigned int suffix;
	unsigned long long kmo;
	/* "args" signature is int, int, int, int, int */
	/* ':chunk_mod_prefix_suffix_outfile_wrapper' for error messages */
	if (!PyArg_ParseTuple(args, "iiiiil:chunk_mod_prefix_suffix_outfile_wrapper", &prefix,
								 &cm1, &infix, &cm2, &suffix, &kmo))
		return NULL;

	outresult = chunk_mod_prefix_suffix_outfile_wrapper(prefix, cm1, infix, cm2, suffix, kmo);

	if (kmo > ULONG_MAX) {
	  /* kmo is currently only used in this context as a switch to prevent trying to output
		  full representation of HALF_OF_TWO_TO_K when impractical (too large) */
	  kmo = ULONG_MAX;
	}

	if (outresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)outresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_2exp_improve(unsigned long long c2e,
												  unsigned long long kmo,
												  unsigned int kmo_divisor) {
  extern mpz_t A, N;
  unsigned long long size5_to_beat = 0;
  unsigned long long size5_ultimate = 0;
  unsigned long long size5_runnerup = 0;
  unsigned long long size5 = 0;
  unsigned long long upper2e = 0;
  unsigned long long try2e = 0;
  unsigned long long try2e_ultimate = 0;
  extern unsigned int debug_flag;
  mpz_t CHUNK_EXP;
  mpz_t C2E_MOD;
  mpz_t T2E_MOD;

  mpz_init(CHUNK_EXP);
  mpz_ui_pow_ui(CHUNK_EXP,2,c2e);
  mpz_init(C2E_MOD);
  mpz_powm(C2E_MOD,A,CHUNK_EXP,N);
  mpz_clear(CHUNK_EXP);
  size5_to_beat = mpz_sizeinbase(C2E_MOD,5);
  if (size5_to_beat < 100 && debug_flag > 0) {
	 gmp_printf("c2e gave C2E_MOD=%Zd\n",C2E_MOD);
  }
  try2e_ultimate = c2e;
  
  upper2e = kmo / kmo_divisor;
  if (upper2e > 63) { upper2e = 63; } /* 2^63 is less than ULLONG_MAX */

  size5_ultimate = size5_to_beat;
  size5_runnerup = size5_to_beat;
  mpz_init(T2E_MOD);
  try2e = upper2e;
  for(try2e = upper2e; try2e > c2e; try2e--) {
	 mpz_init(CHUNK_EXP);
	 mpz_ui_pow_ui(CHUNK_EXP,2,try2e); /* replace with call to new switch function? */
	 mpz_init(T2E_MOD);
	 mpz_powm(T2E_MOD,A,CHUNK_EXP,N);
	 mpz_clear(CHUNK_EXP);
	 size5 = mpz_sizeinbase(T2E_MOD,5);

	 if (size5 < size5_ultimate) {
		size5_runnerup = size5_ultimate;
		size5_ultimate = size5;
		try2e_ultimate = try2e;
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld tops leaderboard.\n",try2e);
		}
	 } else {
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld is unable to beat try2e_ultimate\n",
					try2e);
		}
	 }
	 if (size5 < 100 && debug_flag > 0) {
		gmp_printf("this tm try2e gave T2E_MOD=%Zd\n",T2E_MOD);
	 }
	 mpz_clear(T2E_MOD);
  }
  if (debug_flag > 0) {
	 printf("chunk_2exp_improve(%lld,,) size5_ultimate=%lld"
			  " >= size5_runnerup=%lld\n",c2e,
			  size5_ultimate,size5_runnerup);
  }
  if (size5_ultimate < size5_to_beat) {
	 if (debug_flag > 0) {
		printf("try2e=%lld beats c2e=%lld\n",try2e_ultimate,c2e);
	 }
	 return try2e_ultimate;
  } else {
	 if (debug_flag > 0) {
		printf("c2e=%lld having size in base 5=%lld is unbeaten\n",
				 c2e,size5_to_beat);
	 }
  }
  return c2e;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_2exp_improve__doc__,
"Attempt to 'improve' on ideal 2exp to raise A to in order to give remainder numerically small.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_2exp_improve(PyObject *self, PyObject *args)
{
  /* The function chunk_2exp_improve() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long impresult;
	unsigned long num_l;
   unsigned long long k_m_o;
   unsigned int k_m_o_divisor = 0;
	/* "args" signature is long, long, optional int */
	/* ':chunk_2exp_improve' for error messages */
	if (!PyArg_ParseTuple(args, "ll|i:chunk_2exp_improve", &num_l,
								 &k_m_o, &k_m_o_divisor))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	if (k_m_o_divisor < 1) {
	  k_m_o_divisor = 4;
	}

	impresult = chunk_2exp_improve((unsigned long long)num_l,
											 (unsigned long long)k_m_o,
											 (unsigned long long)k_m_o_divisor);

	if (impresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)impresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_2exp_unimprove(unsigned long long c2e, unsigned long long kmo) {
  extern mpz_t A, N;
  unsigned long long size5_to_beat = 0;
  extern unsigned long long size5_ultimate;
  unsigned long long size5_runnerup = 0;
  unsigned long long size5 = 0;
  unsigned long long upper2e = 0;
  unsigned long long try2e = 0;
  unsigned long long tt = 0;
  extern unsigned int debug_flag;
  mpz_t C2E_MOD;
  mpz_t T2E_MOD;
  mpz_init(C2E_MOD);
  mpz_powm_ui(C2E_MOD,A,c2e,N);
  size5_to_beat = mpz_sizeinbase(C2E_MOD,5);
  upper2e = kmo / 4;
  size5_ultimate = size5_to_beat;
  size5_runnerup = size5_to_beat;
  mpz_init(T2E_MOD);
  try2e = upper2e;
  for(tt = 1; tt < 15; tt++) {
	 if ((c2e + (tt*c2e)) > upper2e) {
		if (debug_flag > 0) {
		  printf("this tt will not be attempted. break.\n");
		}
		break;
	 }
	 try2e = try2e - (tt*c2e);
	 mpz_init(T2E_MOD);
	 mpz_powm_ui(T2E_MOD,A,try2e,N);
	 size5 = mpz_sizeinbase(T2E_MOD,5);
	 if (size5 < size5_ultimate) {
		size5_runnerup = size5_ultimate;
		size5_ultimate = size5;
		break;
	 } else {
		if (debug_flag > 0) {
		  printf("this tt is unable to beat c2e\n");
		}
	 }
  }
  if (debug_flag > 0) {
	 printf("size5_ultimate=%lld >= size5_runnerup=%lld\n",
			  size5_ultimate,size5_runnerup);
  }
  if (size5_ultimate < size5_to_beat) {
	 if (debug_flag > 0) {
		printf("try2e=%lld beats c2e=%lld\n",try2e,c2e);
	 }
	 return try2e;
  } else {
	 if (debug_flag > 0) {
		printf("c2e=%lld having size in base 5=%lld is unbeaten\n",
				 c2e,size5_to_beat);
	 }
  }
  return c2e;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_2exp_unimprove__doc__,
"Attempt to 'improve' on ideal 2exp to raise A to in order to give remainder numerically small.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_2exp_unimprove(PyObject *self, PyObject *args)
{
  /* The function chunk_2exp_improve() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long impresult;
	unsigned long num_l;
   unsigned long long k_m_o;
	/* "args" signature is long, long */
	/* ':chunk_2exp_unimprove' for error messages */
	if (!PyArg_ParseTuple(args, "ll:chunk_2exp_unimprove", &num_l, &k_m_o))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	impresult = chunk_2exp_unimprove((unsigned long long)num_l,
											 (unsigned long long)k_m_o);

	if (impresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)impresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_exp_improve(unsigned long long cexp,
												 unsigned long long kmo, unsigned int kmo_divisor) {
  extern mpz_t A, N;
  unsigned long long size5_to_beat = 0;
  extern unsigned long long size5_ultimate;
  unsigned long long size5_runnerup = 0;
  unsigned long long size5 = 0;
  unsigned long long upper = 0;
  unsigned long long u2e = 0;
  unsigned long long trymul = 0;
  unsigned long long trymul_ultimate = 0;
  unsigned long long tm = 0;
  extern unsigned int debug_flag;
  mpz_t CEXP_MOD;
  mpz_t TM_MOD;

  if (debug_flag > 0) {
	 printf("chunk_exp_improve(%lld,%lld,%d) now processing\n",
			  cexp,kmo,kmo_divisor);
  }

  mpz_init(CEXP_MOD);
  mpz_powm_ui(CEXP_MOD,A,cexp,N);
  size5_to_beat = mpz_sizeinbase(CEXP_MOD,5);
  if (debug_flag > 0) {
	 printf("size5_to_beat=%lld - starting the tm contest now\n",
			  size5_to_beat);
	 if (size5_to_beat < 100) {
		gmp_printf("CEXP_MOD=%Zd\n",CEXP_MOD);
	 }
  }

  trymul_ultimate = cexp;
  u2e = kmo / kmo_divisor;
  if (debug_flag > 0) {
	 printf("tm processing u2e=%lld\n",u2e);
  }
  if (u2e > 63) {
	 upper = ULLONG_MAX / 10;
  } else {
	 upper = pow(2,u2e);
	 printf("tm processing will not exceed upper based on u2e=%lld\n",
			  u2e);
  }
  if (debug_flag > 0) {
	 printf("tm processing will not exceed upper=%lld\n",upper);
  }
  size5_ultimate = size5_to_beat;
  size5_runnerup = size5_to_beat;
  mpz_init(TM_MOD);
  trymul = upper;
  for(tm = 1; tm < 15; tm++) {
	 if ((cexp + (tm*cexp)) > upper) {
		if (debug_flag > 0) {
		  printf("this tm will not be attempted. break.\n");
		}
		break;
	 }
	 trymul = trymul - cexp;
	 mpz_init(TM_MOD);
	 mpz_powm_ui(TM_MOD,A,trymul,N);
	 size5 = mpz_sizeinbase(TM_MOD,5);
	 if (size5 < size5_ultimate) {
		size5_runnerup = size5_ultimate;
		size5_ultimate = size5;
		trymul_ultimate = trymul;
		if (debug_flag > 0) {
		  printf("this tm trymul=%lld tops leaderboard.\n",trymul);
		}
	 } else {
		if (debug_flag > 0) {
		  printf("this tm trymul=%lld is unable to beat cexp\n",
					trymul);
		  if (size5 < 100) {
			 gmp_printf("this tm trymul gave TM_MOD=%Zd\n",TM_MOD);
		  }
		}
	 }
  }
  if (debug_flag > 0) {
	 printf("size5_ultimate=%lld smaller than runner up size5_runnerup=%lld\n",
			  size5_ultimate,size5_runnerup);
  }
  if (size5_ultimate < size5_to_beat) {
	 if (debug_flag > 0) {
		printf("trymul=%lld beats cexp=%lld\n",trymul_ultimate,cexp);
	 }
	 return trymul_ultimate;
  } else {
	 if (debug_flag > 0) {
		printf("cexp=%lld having size in base 5=%lld is unbeaten\n",
				 cexp,size5_to_beat);
	 }
  }
  return cexp;
}


/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_exp_improve__doc__,
"Attempt to 'improve' on ideal exp to raise A to in order to give remainder numerically small.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_exp_improve(PyObject *self, PyObject *args)
{
  /* The function chunk_exp_improve() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long impresult;
	unsigned long num_l;
   unsigned long long k_m_o;
   unsigned int k_m_o_divisor;
	/* "args" signature is long, long, int */
	/* ':chunk_exp_improve' for error messages */
	if (!PyArg_ParseTuple(args, "lli:chunk_exp_improve", &num_l, &k_m_o,
								 &k_m_o_divisor))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	impresult = chunk_exp_improve((unsigned long long)num_l,
											(unsigned long long)k_m_o,
											(unsigned long long)k_m_o_divisor);

	if (impresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)impresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_mod_given_chunk_2exp(unsigned long long c2e) {

	 extern mpz_t A, N;
	 extern const unsigned long NINETYNINEMILLION;
	 extern unsigned long long c2e_candidate;
	 /* use global CHUNK_MOD_CANDIDATE as storage */
	 extern mpz_t		CHUNK_MOD_CANDIDATE;
	 extern mpz_t		ONE;
	 mpz_t		CHUNK_EXP;
	 mpz_t		A_TO_CHUNK_EXP;
	 unsigned long long chunk_exp = 1;
	 unsigned long long size10cexp = 0;
	 unsigned long long branch_function_return = 0;

	 /* The following 3 variables are an attempt
		 to observe/learn/document the behaviour of
		 expiriments.
		 They are subjective and perhaps based
		 on too few experiments, but are intended
		 to reflect observation where possible. */
	 unsigned int branch_number = 0;
	 /* branch_number will affect the call chain.
		 Certainly branch_number is involved in
		 choice of straight mpz_powm
		 or instead mpz_pow_ui() then mpz_mod */
	 unsigned int difficulty_level = 1;
	 unsigned int difficulty_adjustment = 0;

	 extern unsigned int	debug_flag;
	 extern FILE	*outfnotes;
	 extern FILE	*outfchunkmod;

  unsigned long long size10n = 0;

	 long clock_r_given = 0;
	 long clocks_r_given = 0;
	 long elapsed_secs = 0;

	 extern char      ndesc[31];
	 /* extern char      *ndesc_unlimited; */

	 long long remainder5size = 0;
	 unsigned long long size5_of_chunk_mod_candidate = 0;

	 unsigned int a_ui = 1;
	 char *dividend = NULL;
	 char base36head[16] = "head";
	 char base36tail[16] = "tail";
	 char *outCHUNK_MOD_CANDIDATE36;
	 unsigned long long outlen;
	 char *outA_TO_CHUNK_EXP;
	 unsigned long long outlendiv;
	 char divhead12[13] = "head";
	 char divtail12[13] = "tail";

	 unsigned int printf_rc;

	 char *csv_line;

   unsigned int dividend_mod12 = 13;
   unsigned int dividend_mod24 = 25;
   unsigned int dividend_mod30 = 31;
   unsigned int dividend_mod32 = 33;
   unsigned int dividend_mod36 = 37;
   unsigned int dividend_modsum129 = 130;

   unsigned int c_mod12 = 13;
   unsigned int c_mod24 = 25;
   unsigned int c_mod30 = 31;
   unsigned int c_mod32 = 33;
   unsigned int c_mod36 = 37;
   unsigned int c_modsum129 = 130;

  mpz_t MOD_NULL;
   
  c2e_candidate = c2e;
  /* Vital that c2e_candidate and CHUNK_MOD_CANDIDATE are
	  kept in step */

  mpz_init(CHUNK_EXP);
  mpz_mul_2exp(CHUNK_EXP,ONE,c2e);
  /* mpz_ui_pow_ui(CHUNK_EXP,2,c2e); */
  size10cexp = mpz_sizeinbase(CHUNK_EXP,10);

  if (size10cexp < 80) {
	 if (debug_flag > 0) {
		gmp_printf("cm_given_chunk_2exp(%lld) derived CHUNK_EXP=%Zd\n",
					  c2e,CHUNK_EXP);
	 }
  } else {
	 if (debug_flag > 0) {
		printf("cm_given_chunk_2exp(%lld) derived CHUNK_EXP.\n",c2e);
	 }
  }

  /* if (size10cexp > 19) { */
  if (c2e > 63) {
	 if (debug_flag > 0) {
		printf("cm_given_chunk_2exp(%lld) is aborting with return code=0"
				 " as size10cexp > limit of 63 (or 19 whatever).\n",c2e);
	 }
	 fprintf(outfnotes,"cm_given_chunk_2exp(%lld) is aborting with"
				" return code=0 as size10cexp > limit"
				" of 63 (or 19 whatever).\n",c2e);
	 return 0; 
  } else {
	 chunk_exp = mpz_get_ui(CHUNK_EXP);
  }

  size10n = mpz_sizeinbase(N,10);

  /* if (c2e < 32 && size10n < 10000) { branch_number = 1; } */
  /* } else if (c2e < 768) { branch_number = 2; } */
  /* } else if (c2e < 128 && size10cexp < 16) { would be illogical } */
  /* Reminder: two_to_thirty = 1073741824 has 10 decimal digits */
  if (c2e < 32) {
	 branch_number = 1;
  } else if (size10cexp < 16) {
	 branch_number = 2;
  } else {
	 branch_number = 9;
  }

  mpz_init_set_ui(A_TO_CHUNK_EXP,1);

  switch(branch_number) {

	 case 0:

		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) branch_number not set error.",c2e);
		}

		break; /* break this case */

	 case 1:

		/* Even for gigantic cases doing pow_ui then mod seems to be 
			a quick way when compared to the other option powm */

		mpz_clear(A_TO_CHUNK_EXP); mpz_init(A_TO_CHUNK_EXP);
		clock_r_given = clock();
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) branch 1 pow_ui begins.\n",c2e);
		}
		mpz_pow_ui(A_TO_CHUNK_EXP,A,chunk_exp);
		clocks_r_given = (clock() - clock_r_given);
		elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) pow_ui elapsed secs=%ld.\n",
					c2e,elapsed_secs);
		  if (size10n > NINETYNINEMILLION) {
			 printf("cm_given_chunk_2exp(%lld) mod involving A_TO_CHUNK_EXP"
					  " next should..\n..take about twice as long as pow_ui"
					  " step just completed.\n",c2e);
			 /* Helpful messages about time prediction only for gigantic n. */
		  }
		}

		clock_r_given = clock();
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) mod involving"
					" A_TO_CHUNK_EXP begins.\n",c2e);
		}
		mpz_mod(CHUNK_MOD_CANDIDATE,A_TO_CHUNK_EXP,N);
		/* mpz_clear(A_TO_CHUNK_EXP); */  /* Have used it or cleared it by now */

		clocks_r_given = (clock() - clock_r_given);
		elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) mod involving"
					" A_TO_CHUNK_EXP elapsed secs=%ld.\n",
					c2e,elapsed_secs);
		}

		break; /* break this case */

	 case 2:

		/* Even for gigantic cases doing pow_ui then mod seems to be 
			a quick way when compared to the other option powm */

		mpz_clear(A_TO_CHUNK_EXP); mpz_init(A_TO_CHUNK_EXP);
		clock_r_given = clock();
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) branch 2 a_pow_2exp_limited"
					" begins.\n",c2e);
		}
		branch_function_return = a_pow_2exp_limited(0,c2e);
		if (branch_function_return > 0) {
		  mpz_set(A_TO_CHUNK_EXP,A_LL_TO_EXP);
		} else {
		  if (debug_flag > 0) {
			 printf("cm_given_chunk_2exp(%lld) branch_function_return=%lld"
					  " which is not clever\n",c2e,branch_function_return);
		  }
		}
		mpz_clear(A_LL_TO_EXP); /* Have used it or cleared it by now */
		/* a_pow_2exp_limited(0,c2e) can be time consuming.
			On a oldish dual core (2009 release) calls to a_pow_2exp_limited
			will likely take a minute to two minutes each.
			On Bulldozer those times should be much lower.
			If your call to a_pow_2exp_limited() completes in under 15 seconds
			then that does make experiments much more pleasant. */

		clocks_r_given = (clock() - clock_r_given);
		elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) branch 2 a_pow_2exp_limited"
					" pow_ui elapsed secs=%ld.\n",c2e,elapsed_secs);
		  if (size10n > NINETYNINEMILLION) {
			 printf("cm_given_chunk_2exp(%lld) mod involving A_TO_CHUNK_EXP"
					  " next should..\n..take about twice as long as pow_ui"
					  " step just completed.\n",c2e);
			 /* Helpful messages about time prediction only for gigantic n. */
		  }
		}

		clock_r_given = clock();
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) mod involving"
					" A_TO_CHUNK_EXP begins.\n",c2e);
		}
		mpz_mod(CHUNK_MOD_CANDIDATE,A_TO_CHUNK_EXP,N);

		clocks_r_given = (clock() - clock_r_given);
		elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) mod involving"
					" A_TO_CHUNK_EXP elapsed secs=%ld.\n",
					c2e,elapsed_secs);
		}
		break; /* break this case */

	 default:

		clock_r_given = clock();
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) branch 'default' powm involving"
					" A and CHUNK_EXP begins.\n",c2e);
		}
		mpz_powm(CHUNK_MOD_CANDIDATE,A,CHUNK_EXP,N);
		clocks_r_given = (clock() - clock_r_given);
		elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
		if (debug_flag > 0) {
		  printf("cm_given_chunk_2exp(%lld) powm involving"
					" A and CHUNK_EXP elapsed secs=%ld.\n",
					c2e,elapsed_secs);
		}
		break; /* break this case */

  } /* end of switch */

  a_ui = mpz_get_ui(A);

  printf_rc = asprintf(&dividend,"%i**2^%llu",a_ui,c2e);
  if (-1 == printf_rc) {
    printf("asprintf returned %i whilst building dividend string.\n",
	   printf_rc);
  } else {

    outA_TO_CHUNK_EXP = mpz_get_str(NULL,10,A_TO_CHUNK_EXP);
    outlendiv = strlen(outA_TO_CHUNK_EXP);

    printf_rc = snprintf(divhead12,13,"%-12s",outA_TO_CHUNK_EXP);
    if (-1 == printf_rc) {
      printf("snprintf returned %i whilst working divhead12\n",printf_rc);
    }

    printf_rc = sprintf(divtail12,"%s",
		      &outA_TO_CHUNK_EXP[(outlendiv-12)]);
    if (-1 == printf_rc) {
      printf("sprintf returned %i whilst working divtail12\n",printf_rc);
    }

    outCHUNK_MOD_CANDIDATE36 = mpz_get_str(NULL,36,CHUNK_MOD_CANDIDATE);
    outlen = strlen(outCHUNK_MOD_CANDIDATE36);

    if (debug_flag > 1) {
      printf("in base36 CHUNK_MOD_CANDIDATE has length of %llu.\n",
	outlen);
    }

    printf_rc = snprintf(base36head,15,"%-15s",outCHUNK_MOD_CANDIDATE36);
    if (-1 == printf_rc) {
      printf("snprintf returned %i whilst working base36head\n",printf_rc);
    }

    printf_rc = sprintf(base36tail,"%s",
		      &outCHUNK_MOD_CANDIDATE36[(outlen-15)]);
    if (-1 == printf_rc) {
      printf("sprintf returned %i whilst working base36tail\n",printf_rc);
    }

    size5_of_chunk_mod_candidate =
      (unsigned long long)mpz_sizeinbase(CHUNK_MOD_CANDIDATE,5);

    if (debug_flag > 1) {
      printf("in base5 CHUNK_MOD_CANDIDATE has length of %llu.\n",
	size5_of_chunk_mod_candidate);
    }

    mpz_init(MOD_NULL);

    dividend_mod12 = mpz_mod_ui(MOD_NULL,A_TO_CHUNK_EXP,12);
    dividend_mod24 = mpz_mod_ui(MOD_NULL,A_TO_CHUNK_EXP,24);
    dividend_mod30 = mpz_mod_ui(MOD_NULL,A_TO_CHUNK_EXP,30);
    dividend_mod32 = mpz_mod_ui(MOD_NULL,A_TO_CHUNK_EXP,32);
    dividend_mod36 = mpz_mod_ui(MOD_NULL,A_TO_CHUNK_EXP,36);

    mpz_clear(A_TO_CHUNK_EXP);

    dividend_modsum129 = dividend_mod12 + dividend_mod24 +
      dividend_mod30 + dividend_mod32 + dividend_mod36;

    c_mod12 = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,12);
    c_mod24 = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,24);
    c_mod30 = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,30);
    c_mod32 = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,32);
    c_mod36 = mpz_mod_ui(MOD_NULL,CHUNK_MOD_CANDIDATE,36);

    c_modsum129 = c_mod12 + c_mod24 + c_mod30 + c_mod32 + c_mod36;

    printf_rc = asprintf(&csv_line,
			 "%s|%u|%u|%u|%u|%u|%u|%s|%s",
			 dividend,dividend_mod12,dividend_mod24,dividend_mod30,
			 dividend_mod32,dividend_mod36,dividend_modsum129,
			 divhead12,divtail12);


    if (-1 == printf_rc) {
      printf("asprintf returned %i whilst building dividend csv_line.\n",
	     printf_rc);
    } else {
      printf("%s\n",csv_line);
      fprintf(outfchunkmod,"%s\n",csv_line);
      fflush(outfchunkmod);
    }

    printf_rc = asprintf(&csv_line,
			 "%s|%s|%u|%u|%u|%u|%u|%u|%s|%s|%llu",
			 ndesc,dividend,
			 c_mod12,c_mod24,c_mod30,c_mod32,c_mod36,c_modsum129,
			 base36head,base36tail,size5_of_chunk_mod_candidate);

    if (-1 == printf_rc) {
      printf("asprintf returned %i whilst building modulo csv_line.\n",
	     printf_rc);
    } else {
      printf("%s\n",csv_line);
      fprintf(outfchunkmod,"%s\n",csv_line);
      fflush(outfchunkmod);
    }

  }

  return (unsigned long long)mpz_sizeinbase(CHUNK_MOD_CANDIDATE,5);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_mod_given_chunk_2exp__doc__,
"Calculate remainder of a^r mod(n) using chunk algorithm.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_mod_given_chunk_2exp(PyObject *self, PyObject *args)
{
  /* The function chunk_mod_given_chunk_2exp() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long rresult;
	unsigned long chunk_2exp;
	/* "args" signature is long */
	/* ':chunk_mod_given_chunk_2exp' for error messages */
	if (!PyArg_ParseTuple(args, "l:chunk_mod_given_chunk_2exp", &chunk_2exp))
		return NULL;

	if (chunk_2exp < 0 || chunk_2exp > ULONG_MAX) {
	  return NULL;
	}

	rresult = chunk_mod_given_chunk_2exp((unsigned long long)chunk_2exp);

	if (rresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)rresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_2exp_improve_size5(unsigned long long c2e,
												  unsigned long long kmo,
												  unsigned long long size5_to_beat,
												  unsigned int kmo_divisor){
  extern mpz_t A, N;
  unsigned long long size5_ultimate = 0;
  unsigned long long size5_runnerup = 0;
  long long size5_difference = 0;
  unsigned long long size5cm = 999;
  unsigned long long upper2e = 0;
  unsigned long long try2e = 0;
  unsigned long long try2e_ultimate = 0;
  extern unsigned int debug_flag;
  extern FILE		*outfchunkmod;
  /* extern unsigned long long c2e_candidate; */
  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_CANDIDATE;
  extern mpz_t		CHUNK_MOD_ULTIMATE;
  mpz_t CHUNK_EXP;

  if (debug_flag > 0) {
	 printf("chunk_2exp_improve_size5(%llu,%llu,%llu,%u) starts search\n",
			  c2e,kmo,size5_to_beat,kmo_divisor);
  }

  try2e_ultimate = c2e;
  
  upper2e = kmo / kmo_divisor;
  if (upper2e > 62) { upper2e = 33; } /* 2^63 is less than ULLONG_MAX */

  size5_ultimate = size5_to_beat;
  size5_runnerup = size5_to_beat;
  try2e = upper2e;
  /* for(try2e = upper2e; try2e > c2e; try2e--) { */
  for(try2e = upper2e; try2e > 26; try2e--) {
	 mpz_init(CHUNK_EXP);
	 mpz_init(CHUNK_MOD_CANDIDATE);
	 size5cm = chunk_mod_given_chunk_2exp(try2e);
	 if (size5cm < size5_ultimate) {
		size5_difference = (size5_ultimate - size5cm);
		size5_runnerup = size5_ultimate;
		size5_ultimate = size5cm;
		try2e_ultimate = try2e;
		/* Important to keep the next two assignements in step. */
		c2e_ultimate = c2e_candidate;
		if (debug_flag > 0) {
		  printf("chunk_2exp_improve_size5(%llu,%llu,%llu,%u) improvement in size5 of %lld found.\n",
					c2e,kmo,size5_to_beat,kmo_divisor,size5_difference);

		  chunk_mod_prefix_suffix_outfile_wrapper(27,9,2,1,0,kmo);
		  /*
		  gmp_fprintf(outfchunkmod,"kmo=%llu ...size5() says that %Zd beats"
						  " %Zd", kmo, CHUNK_MOD_CANDIDATE, CHUNK_MOD_ULTIMATE);
		  fflush(outfchunkmod);
		  */
		}
		mpz_set(CHUNK_MOD_ULTIMATE,CHUNK_MOD_CANDIDATE);
		/* chunk_mod_given_chunk_2exp stores in CHUNK_MOD_CANDIDATE global.
			Above we copy that results into CHUNK_MOD_ULTIMATE global.    */
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld tops leaderboard.\n",try2e);
		}
	 } else {
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld is unable to beat try2e_ultimate\n",
					try2e);
		}
	 }
	 if (debug_flag > 0) {
		if (size5cm < 100) {
		  gmp_printf("this tm try2e=%llu (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
						 "=%Zd\n",try2e,size5cm,CHUNK_MOD_CANDIDATE);
		} else {
		  printf("this tm try2e=%llu (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
					" longer than 100 decimal digits.\n",try2e,size5cm);
		}
	 }
	 mpz_clear(CHUNK_MOD_CANDIDATE);  /* Have used it or cleared it by now */
  }
  if (debug_flag > 0) {
	 printf("...improve_size5(,,,) size5_ultimate=%lld beats"
			  " size5_runnerup=%lld\n",size5_ultimate,size5_runnerup);
  }
  if (size5_ultimate < size5_to_beat) {
	 if (debug_flag > 0) {
		printf("try2e=%lld beats c2e=%lld\n",try2e_ultimate,c2e);
	 }
	 return try2e_ultimate;
  } else {
	 if (debug_flag > 0) {
		printf("c2e=%lld having size in base 5=%lld is unbeaten\n",
				 c2e,size5_to_beat);
	 }
  }
  return c2e;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_2exp_improve_size5__doc__,
"Attempt to 'improve' on ideal 2exp to raise A to in order to give remainder numerically small.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_2exp_improve_size5(PyObject *self, PyObject *args)
{
  /* The function chunk_2exp_improve_size5() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long impresult;
	unsigned long num_l;
   unsigned long long k_m_o;
   unsigned long long size5now;
   unsigned int k_m_o_divisor = 0;
	/* "args" signature is long, long, optional int */
	/* ':chunk_2exp_improve_size5' for error messages */
	if (!PyArg_ParseTuple(args, "lll|i:chunk_2exp_improve_size5", &num_l,
								 &k_m_o, &size5now, &k_m_o_divisor))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	if (k_m_o_divisor < 1) {
	  k_m_o_divisor = 4;
	}

	impresult = chunk_2exp_improve_size5((unsigned long long)num_l,
											 (unsigned long long)k_m_o,
											 (unsigned long long)size5now,
											 (unsigned long long)k_m_o_divisor);

	if (impresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)impresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long chunk_2exp_improve_size5_range(unsigned long long c2e,
												  unsigned long long size5_to_beat,
												  unsigned int rlower2e,
												  unsigned int rupper2e){
  extern mpz_t A, N;
  unsigned long long size5_ultimate = 0;
  unsigned long long size5_runnerup = 0;
  unsigned long long size5cm = 999;
  unsigned long long upper2e = 0;
  unsigned long long try2e = 0;
  unsigned long long try2e_ultimate = 0;
  extern unsigned int debug_flag;
  /* extern unsigned long long c2e_candidate; */
  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_CANDIDATE;
  extern mpz_t		CHUNK_MOD_ULTIMATE;
  mpz_t CHUNK_EXP;

  try2e_ultimate = c2e;
  
  if (rupper2e > 62) { rupper2e = 62; } /* 2^63 is less than ULLONG_MAX */

  size5_ultimate = size5_to_beat;
  size5_runnerup = size5_to_beat;
  try2e = upper2e;
  for(try2e = rupper2e; try2e >= rlower2e; try2e--) {
	 mpz_init(CHUNK_EXP);
	 size5cm = chunk_mod_given_chunk_2exp(try2e);
	 if (size5cm < size5_ultimate) {
		size5_runnerup = size5_ultimate;
		size5_ultimate = size5cm;
		try2e_ultimate = try2e;
		/* Important to keep the next two assignements in step. */
		c2e_ultimate = c2e_candidate;
		mpz_set(CHUNK_MOD_ULTIMATE,CHUNK_MOD_CANDIDATE);
		/* chunk_mod_given_chunk_2exp stores in CHUNK_MOD_CANDIDATE global.
			Above we copy that results into CHUNK_MOD_ULTIMATE global.    */
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld tops leaderboard.\n",try2e);
		}
	 } else {
		if (debug_flag > 0) {
		  printf("this tm try2e=%lld is unable to beat try2e_ultimate\n",
					try2e);
		}
	 }
	 if (debug_flag > 0) {
		if (size5cm < 100) {
		  gmp_printf("this tm try2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
						 "=%Zd\n",size5cm,CHUNK_MOD_CANDIDATE);
		} else {
		  printf("this tm try2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
					" longer than 100 decimal digits.\n",size5cm);
		}
	 }
  }
  if (debug_flag > 0) {
	 printf("...improve_size5_range(,,,) size5_ultimate=%lld beats"
			  " size5_runnerup=%lld\n",size5_ultimate,size5_runnerup);
  }
  if (size5_ultimate < size5_to_beat) {
	 if (debug_flag > 0) {
		printf("try2e=%lld beats c2e=%lld\n",try2e_ultimate,c2e);
	 }
	 return try2e_ultimate;
  } else {
	 if (debug_flag > 0) {
		printf("c2e=%lld having size in base 5=%lld is unbeaten\n",
				 c2e,size5_to_beat);
	 }
  }
  return c2e;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(chunk_2exp_improve_size5_range__doc__,
"Attempt to 'improve' on ideal 2exp to raise A to in order to give remainder numerically small.");

/* Wrapper around the underlying C function */
static PyObject *
py_chunk_2exp_improve_size5_range(PyObject *self, PyObject *args)
{
  /* The function chunk_2exp_improve_size5_range() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long impresult;
	unsigned long num_l;
   unsigned long long size5now;
	unsigned int start2e;
	unsigned int end2e;
	/* "args" signature is long, long, optional int */
	/* ':chunk_2exp_improve_size5_range' for error messages */
	if (!PyArg_ParseTuple(args, "llii:chunk_2exp_improve_size5_range", &num_l,
								 &size5now, &start2e, &end2e))
		return NULL;

	if (num_l < 0 || num_l > ULONG_MAX) {
	  return NULL;
	}

	if (start2e >= end2e) { return NULL; }

	impresult = chunk_2exp_improve_size5_range((unsigned long long)num_l,
											 (unsigned long long)size5now,
											 (unsigned int)start2e,
											 (unsigned long long)end2e);

	if (impresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)impresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long r_given_chunk_2exp_and_kmo(unsigned long long c2e,
														  unsigned long long kmo) {

	 extern mpz_t A, N, RA;
	 extern const unsigned long NINETYNINEMILLION;
	 extern   unsigned long multiple_of_1365;
	 extern mpz_t		HALF_OF_TWO_TO_K;
	 mpz_t		CHUNK_MOD;

  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_ULTIMATE;

	 mpz_t		CHUNK_MOD_POWERED_MOD;
	 mpz_t		CHUNK_EXP;
	 mpz_t		CHUNK_EXP_QUOTIENT;
	 unsigned long long chunk_exp = 1;
	 unsigned long long size10cexp = 0;
	 unsigned long long size10ceq = 0;
	 unsigned long long size5cm = 0;
	 unsigned long long size5returned = 0;
	 unsigned int	two_exp = 0;
	 unsigned int	two_to_two_exp = 0;
	 unsigned int  low2e;
	 unsigned int  high2e;
	 extern unsigned int	debug_flag;

	extern FILE      *outfnotes;

  unsigned long long outCHUNK_EXP_QUOTIENTlen = 0;
  char      *outCHUNK_EXP_QUOTIENT;
  char      *outCHUNK_EXP_QUOTIENTtail;

  unsigned long long size10n = 0;

	 long clock_r_given = 0;
	 long clocks_r_given = 0;
	 long elapsed_secs = 0;

  mpz_init(CHUNK_MOD);

  size10n = mpz_sizeinbase(N,10);

  size5cm = chunk_mod_given_chunk_2exp(c2e);

  if (size5cm < 100) {
	  gmp_printf("Unchallenged c2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
					 "=%Zd\n",size5cm,CHUNK_MOD_CANDIDATE);
  } else {
	  printf("Unchallenged c2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
				" longer than 100 decimal digits.\n",size5cm);
  }


  /*
  upper2e = kmo / kmo_divisor;
  if (upper2e > 63) { upper2e = 36; }
  */
 /* 2^63 is less than ULLONG_MAX */

  if (c2e < 21) { /* if (c2e < 21) { */

		high2e = 30;
		low2e = 1 + high2e - 10;

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod using c2e"
					" range of 31 downward %d..%d\n",low2e,high2e);
		}
	 /* do range of ten 21..31 excluding 31 */
		size5returned = chunk_2exp_improve_size5_range(c2e, size5cm,
																	  low2e, high2e);

		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);



  } else if (c2e < 63) {

	 /* for(two_exp = 3; two_exp >= 1; two_exp--) { */
	 for(two_exp = 1; two_exp >= 1; two_exp--) {

		two_to_two_exp = pow(2,two_exp);

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod with final"
					" arg to ...improve_size5 of %d\n",two_to_two_exp);
		}
		size5returned = chunk_2exp_improve_size5(c2e, kmo,
															  size5cm, two_to_two_exp);
		/* Fourth arg (last) in above is 8 then 4 */
		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);

	 } /* end for(;;) */

  } else {

		high2e = 62;
		low2e = 1 + high2e - 15;

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod using c2e"
					" range of 62 downward %d..%d\n",low2e,high2e);
		}

	 /* do range of fifteen 48..63 excluding 63 */
		size5returned = chunk_2exp_improve_size5_range(c2e, size5cm,
																	  low2e, high2e);
		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);
  }


  mpz_init(CHUNK_EXP);
  mpz_ui_pow_ui(CHUNK_EXP,2,c2e);
  size10cexp = mpz_sizeinbase(CHUNK_EXP,10);

  if (size10cexp < 80) {
	 if (debug_flag > 0) {
		gmp_printf("r_given_chunk_2exp_and_kmo(%lld) derived CHUNK_EXP=%Zd\n",
					  c2e,CHUNK_EXP);
	 }
  } else {
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) derived CHUNK_EXP.\n",c2e);
	 }
  }

  if (size10cexp > 19) {
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) aborting as considers"
				 " size10cexp to be too large to deal with - check this!!!\n",c2e);
	 }
	 return 0; 
  } else {
	 chunk_exp = mpz_get_ui(CHUNK_EXP);
  }

	 clock_r_given = clock();

	 if (debug_flag > 0) {
		if (size10n > NINETYNINEMILLION) {
		  printf("r_given_chunk_2exp_and_kmo(%lld) tdiv_q next should have"
					" negligible runtime - a second or two?.\n",c2e);
		  /* Helpful messages about time prediction only for gigantic n. */
		}
		printf("r_given_chunk_2exp_and_kmo(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP begins.\n",c2e);
	 }

	 mpz_init(CHUNK_EXP_QUOTIENT);
	 mpz_tdiv_q(CHUNK_EXP_QUOTIENT,HALF_OF_TWO_TO_K,CHUNK_EXP);
	 mpz_clear(CHUNK_EXP);

	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }


	 size10ceq = mpz_sizeinbase(CHUNK_EXP_QUOTIENT,10);

	 if (size10ceq < 1000000) {

		outCHUNK_EXP_QUOTIENT = mpz_get_str(NULL,10,CHUNK_EXP_QUOTIENT);
		outCHUNK_EXP_QUOTIENTlen = strlen(outCHUNK_EXP_QUOTIENT);
		if (outCHUNK_EXP_QUOTIENTlen < 81) {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and" 
					  " in full CHUNK_EXP_QUOTIENT=%s\n",
					  outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  }
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and in full CHUNK_EXP_QUOTIENT=%s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  fflush(outfnotes);
		} else {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and ends %s\n",
					  outCHUNK_EXP_QUOTIENTlen,
					  &outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  }
		  asprintf(&outCHUNK_EXP_QUOTIENTtail,
					  "%s",&outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and ending %s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENTtail);
		}

	 }

	 mpz_init(CHUNK_MOD_POWERED_MOD);
	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT begins...\n"
				 "powm Attempt will raise CHUNK_MOD to exponent having"
				 " %lld decimal digits.\n",c2e,size10ceq);
	 }
	 mpz_powm(CHUNK_MOD_POWERED_MOD,CHUNK_MOD,CHUNK_EXP_QUOTIENT,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

	 mpz_clear(CHUNK_MOD);

	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) powm_ui involving"
				 " multiple_of_1365 is next.\n",c2e);
	 }
	 mpz_init(RA);
	 clock_r_given = clock();
	 mpz_powm_ui(RA,CHUNK_MOD_POWERED_MOD,multiple_of_1365,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo(%lld) powm_ui involving"
				 " multiple_of_1365 elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }


	 mpz_clear(CHUNK_EXP_QUOTIENT);
	 mpz_clear(CHUNK_MOD_POWERED_MOD);
	 return (unsigned long long)mpz_sizeinbase(RA,10);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(r_given_chunk_2exp_and_kmo__doc__,
"Calculate remainder of a^r mod(n) using chunk algorithm.");

/* Wrapper around the underlying C function */
static PyObject *
py_r_given_chunk_2exp_and_kmo(PyObject *self, PyObject *args)
{
  /* The function r_given_chunk_2exp_and_kmo() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long rresult;
	unsigned long chunk_2exp;
	unsigned long k_m_o;
	/* "args" signature is long, long */
	/* ':r_given_chunk_2exp_and_kmo' for error messages */
	if (!PyArg_ParseTuple(args, "ll:r_given_chunk_2exp_and_kmo",
								 &chunk_2exp, &k_m_o))
		return NULL;

	if (chunk_2exp < 0 || chunk_2exp > ULONG_MAX) {
	  return NULL;
	}

	if (k_m_o < 0 || k_m_o > ULONG_MAX) {
	  return NULL;
	}

	rresult = r_given_chunk_2exp_and_kmo((unsigned long long)chunk_2exp,
													 (unsigned long long)k_m_o);

	if (rresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)rresult);
}
/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long r_given_chunk_2exp_and_kmo_staged(unsigned long long c2e,
						     unsigned long long kmo, unsigned int stages) {

	 extern mpz_t A, N, RA;
	 extern const unsigned long NINETYNINEMILLION;
	 extern   unsigned long multiple_of_1365;
	 extern mpz_t		HALF_OF_TWO_TO_K;
	 mpz_t		CHUNK_MOD;

  extern unsigned long long c2e_ultimate;
  extern mpz_t		CHUNK_MOD_ULTIMATE;

	 mpz_t		CHUNK_MOD_POWERED_MOD;
	 mpz_t		CHUNK_EXP;
	 mpz_t		CHUNK_EXP_QUOTIENT;
	 unsigned long long chunk_exp = 1;
	 unsigned long long size10cexp = 0;
	 unsigned long long size10ceq = 0;
	 unsigned long long size5cm = 0;
	 unsigned long long size5returned = 0;
	 unsigned int	two_exp = 0;
	 unsigned int	two_to_two_exp = 0;
	 unsigned int  low2e;
	 unsigned int  high2e;
	 extern unsigned int	debug_flag;

	extern FILE      *outfnotes;

  unsigned long long outCHUNK_EXP_QUOTIENTlen = 0;
  char      *outCHUNK_EXP_QUOTIENT;
  char      *outCHUNK_EXP_QUOTIENTtail;

  unsigned long long size10n = 0;

	 long clock_r_given = 0;
	 long clocks_r_given = 0;
	 long elapsed_secs = 0;

  mpz_init(CHUNK_MOD);

  size10n = mpz_sizeinbase(N,10);

  size5cm = chunk_mod_given_chunk_2exp(c2e);

  if (size5cm < 100) {
	  gmp_printf("Unchallenged c2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
					 "=%Zd\n",size5cm,CHUNK_MOD_CANDIDATE);
  } else {
	  printf("Unchallenged c2e (size5cm=%lld) gave CHUNK_MOD_CANDIDATE"
				" longer than 100 decimal digits.\n",size5cm);
  }


  /*
  upper2e = kmo / kmo_divisor;
  if (upper2e > 63) { upper2e = 36; }
  */
 /* 2^63 is less than ULLONG_MAX */

  if (c2e < 21) { /* if (c2e < 21) { */

		high2e = 30;
		low2e = 1 + high2e - 10;

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod using c2e"
					" range of 31 downward %d..%d\n",low2e,high2e);
		}
	 /* do range of ten 21..31 excluding 31 */
		size5returned = chunk_2exp_improve_size5_range(c2e, size5cm,
																	  low2e, high2e);

		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);



  } else if (c2e < 63) {

	 /* for(two_exp = 3; two_exp >= 1; two_exp--) { */
	 for(two_exp = 1; two_exp >= 1; two_exp--) {

		two_to_two_exp = pow(2,two_exp);

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod with final"
					" arg to ...improve_size5 of %d\n",two_to_two_exp);
		}
		size5returned = chunk_2exp_improve_size5(c2e, kmo,
															  size5cm, two_to_two_exp);
		/* Fourth arg (last) in above is 8 then 4 */
		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);

	 } /* end for(;;) */

  } else {

		high2e = 62;
		low2e = 1 + high2e - 15;

		if (debug_flag > 0) {
		  printf("Attempting to improve on initial 2exp chunk_mod using c2e"
					" range of 62 downward %d..%d\n",low2e,high2e);
		}

	 /* do range of fifteen 48..63 excluding 63 */
		size5returned = chunk_2exp_improve_size5_range(c2e, size5cm,
																	  low2e, high2e);
		if (size5returned < size5cm) {
		  c2e = c2e_ultimate;
		  mpz_set(CHUNK_MOD,CHUNK_MOD_ULTIMATE);
		}
		mpz_clear(CHUNK_MOD_ULTIMATE);
  }

  if (stages < 2) { return 0; }

  mpz_init(CHUNK_EXP);
  mpz_ui_pow_ui(CHUNK_EXP,2,c2e);
  size10cexp = mpz_sizeinbase(CHUNK_EXP,10);

  if (size10cexp < 80) {
	 if (debug_flag > 0) {
		gmp_printf("r_given_chunk_2exp_and_kmo_staged(%lld) derived CHUNK_EXP=%Zd\n",
					  c2e,CHUNK_EXP);
	 }
  } else {
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) derived CHUNK_EXP.\n",c2e);
	 }
  }

  if (size10cexp > 19) {
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) aborting as considers"
				 " size10cexp to be too large to deal with - check this!!!\n",c2e);
	 }
	 return 0; 
  } else {
	 chunk_exp = mpz_get_ui(CHUNK_EXP);
  }

	 clock_r_given = clock();

  if (stages < 3) { return 0; }

	 if (debug_flag > 0) {
		if (size10n > NINETYNINEMILLION) {
		  printf("r_given_chunk_2exp_and_kmo_staged(%lld) tdiv_q next should have"
					" negligible runtime - a second or two?.\n",c2e);
		  /* Helpful messages about time prediction only for gigantic n. */
		}
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP begins.\n",c2e);
	 }

	 mpz_init(CHUNK_EXP_QUOTIENT);
	 mpz_tdiv_q(CHUNK_EXP_QUOTIENT,HALF_OF_TWO_TO_K,CHUNK_EXP);
	 mpz_clear(CHUNK_EXP);

	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

  if (stages < 4) { return 0; }

	 size10ceq = mpz_sizeinbase(CHUNK_EXP_QUOTIENT,10);

	 if (size10ceq < 1000000) {

		outCHUNK_EXP_QUOTIENT = mpz_get_str(NULL,10,CHUNK_EXP_QUOTIENT);
		outCHUNK_EXP_QUOTIENTlen = strlen(outCHUNK_EXP_QUOTIENT);
		if (outCHUNK_EXP_QUOTIENTlen < 81) {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and" 
					  " in full CHUNK_EXP_QUOTIENT=%s\n",
					  outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  }
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and in full CHUNK_EXP_QUOTIENT=%s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  fflush(outfnotes);
		} else {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and ends %s\n",
					  outCHUNK_EXP_QUOTIENTlen,
					  &outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  }
		  asprintf(&outCHUNK_EXP_QUOTIENTtail,
					  "%s",&outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and ending %s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENTtail);
		}

	 }

  if (stages < 5) { return 0; }

	 mpz_init(CHUNK_MOD_POWERED_MOD);
	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT begins...\n"
				 "powm Attempt will raise CHUNK_MOD to exponent having"
				 " %lld decimal digits.\n",c2e,size10ceq);
	 }
	 mpz_powm(CHUNK_MOD_POWERED_MOD,CHUNK_MOD,CHUNK_EXP_QUOTIENT,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

	 mpz_clear(CHUNK_MOD);

  if (stages < 6) { return 0; }

	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) powm_ui involving"
				 " multiple_of_1365 is next.\n",c2e);
	 }
	 mpz_init(RA);
	 clock_r_given = clock();
	 mpz_powm_ui(RA,CHUNK_MOD_POWERED_MOD,multiple_of_1365,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp_and_kmo_staged(%lld) powm_ui involving"
				 " multiple_of_1365 elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }


	 mpz_clear(CHUNK_EXP_QUOTIENT);
	 mpz_clear(CHUNK_MOD_POWERED_MOD);
	 return (unsigned long long)mpz_sizeinbase(RA,10);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(r_given_chunk_2exp_and_kmo_staged__doc__,
"Calculate remainder of a^r mod(n) using chunk algorithm.");

/* Wrapper around the underlying C function */
static PyObject *
py_r_given_chunk_2exp_and_kmo_staged(PyObject *self, PyObject *args)
{
  /* The function r_given_chunk_2exp_and_kmo_staged() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long rresult;
	unsigned long chunk_2exp;
	unsigned long k_m_o;
	unsigned int stages = 9; /* default to 9 which means all stages */
	/* "args" signature is long, long */
	/* ':r_given_chunk_2exp_and_kmo_staged' for error messages */
	if (!PyArg_ParseTuple(args, "ll|i:r_given_chunk_2exp_and_kmo_staged",
			      &chunk_2exp, &k_m_o, &stages))
		return NULL;

	if (chunk_2exp < 0 || chunk_2exp > ULONG_MAX) {
	  return NULL;
	}

	if (k_m_o < 0 || k_m_o > ULONG_MAX) {
	  return NULL;
	}

	rresult = r_given_chunk_2exp_and_kmo_staged((unsigned long long)chunk_2exp,
						    (unsigned long long)k_m_o,
						    (unsigned int)stages);

	if (rresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)rresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long r_given_chunk_2exp(unsigned long long c2e) {

	 extern mpz_t A, N, RA;
	 extern const unsigned long NINETYNINEMILLION;
	 extern   unsigned long multiple_of_1365;
	 extern mpz_t		HALF_OF_TWO_TO_K;
	 mpz_t		CHUNK_MOD;
	 mpz_t		CHUNK_MOD_POWERED_MOD;
	 mpz_t		CHUNK_EXP;
	 mpz_t		A_TO_CHUNK_EXP;
	 mpz_t		CHUNK_EXP_QUOTIENT;
	 unsigned long long chunk_exp = 1;
	 unsigned long long size10cexp = 0;
	 unsigned long long size10ceq = 0;
	 extern unsigned int	debug_flag;

  unsigned long long outCHUNK_EXP_QUOTIENTlen = 0;
  char      *outCHUNK_EXP_QUOTIENT;
  char      *outCHUNK_EXP_QUOTIENTtail;

  unsigned long long size10n = 0;

	 long clock_r_given = 0;
	 long clocks_r_given = 0;
	 long elapsed_secs = 0;

  mpz_init(CHUNK_EXP);
  mpz_ui_pow_ui(CHUNK_EXP,2,c2e);
  size10cexp = mpz_sizeinbase(CHUNK_EXP,10);

  if (size10cexp < 80) {
	 if (debug_flag > 0) {
		gmp_printf("r_given_chunk_2exp(%lld) derived CHUNK_EXP=%Zd\n",
					  c2e,CHUNK_EXP);
	 }
  } else {
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) derived CHUNK_EXP.\n",c2e);
	 }
  }

  if (size10cexp > 19) {
	 return 0; 
  } else {
	 chunk_exp = mpz_get_ui(CHUNK_EXP);
  }

  mpz_init(CHUNK_MOD);

  size10n = mpz_sizeinbase(N,10);

  /* if (c2e < 32 && size10n < 10000) { */
  if (c2e < 768) {

	 /* Even for gigantic cases doing pow_ui then mod seems to be 
		 a quick way when compared to the other option powm */

	 mpz_init(A_TO_CHUNK_EXP);
	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) pow_ui begins.\n",c2e);
	 }
	 mpz_pow_ui(A_TO_CHUNK_EXP,A,chunk_exp);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) pow_ui elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
		if (size10n > NINETYNINEMILLION) {
		  printf("r_given_chunk_2exp(%lld) mod involving A_TO_CHUNK_EXP"
					" next should..\n..take about twice as long as pow_ui"
					" step just completed.\n",c2e);
		  /* Helpful messages about time prediction only for gigantic n. */
		}
	 }

	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) mod involving"
				 " A_TO_CHUNK_EXP begins.\n",c2e);
	 }
	 mpz_mod(CHUNK_MOD,A_TO_CHUNK_EXP,N);
	 mpz_clear(A_TO_CHUNK_EXP);

	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) mod involving"
				 " A_TO_CHUNK_EXP elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

  } else {

	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) powm involving"
				 " A and CHUNK_EXP begins.\n",c2e);
	 }
	 mpz_powm(CHUNK_MOD,A,CHUNK_EXP,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) powm involving"
				 " A and CHUNK_EXP elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }
  }

	 clock_r_given = clock();

	 if (debug_flag > 0) {
		if (size10n > NINETYNINEMILLION) {
		  printf("r_given_chunk_2exp(%lld) tdiv_q next should have"
					" negligible runtime - a second or two?.\n",c2e);
		  /* Helpful messages about time prediction only for gigantic n. */
		}
		printf("r_given_chunk_2exp(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP begins.\n",c2e);
	 }

	 mpz_init(CHUNK_EXP_QUOTIENT);
	 mpz_tdiv_q(CHUNK_EXP_QUOTIENT,HALF_OF_TWO_TO_K,CHUNK_EXP);
	 mpz_clear(CHUNK_EXP);

	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) tdiv_q involving"
				 " HALF_OF_TWO_TO_K and CHUNK_EXP elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }


	 size10ceq = mpz_sizeinbase(CHUNK_EXP_QUOTIENT,10);

	 if (size10ceq < 1000000) {

		outCHUNK_EXP_QUOTIENT = mpz_get_str(NULL,10,CHUNK_EXP_QUOTIENT);
		outCHUNK_EXP_QUOTIENTlen = strlen(outCHUNK_EXP_QUOTIENT);
		if (outCHUNK_EXP_QUOTIENTlen < 81) {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and" 
					  " in full CHUNK_EXP_QUOTIENT=%s\n",
					  outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  }
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and in full CHUNK_EXP_QUOTIENT=%s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
		  fflush(outfnotes);
		} else {
		  if (debug_flag > 0) {
			 printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and ends %s\n",
					  outCHUNK_EXP_QUOTIENTlen,
					  &outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  }
		  asprintf(&outCHUNK_EXP_QUOTIENTtail,
					  "%s",&outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
		  fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
					 " digits and ending %s\n",
					 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENTtail);
		}

	 }

	 mpz_init(CHUNK_MOD_POWERED_MOD);
	 clock_r_given = clock();
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT begins...\n"
				 "powm Attempt will raise CHUNK_MOD to exponent having"
				 " %lld decimal digits.\n",c2e,size10ceq);
	 }
	 mpz_powm(CHUNK_MOD_POWERED_MOD,CHUNK_MOD,CHUNK_EXP_QUOTIENT,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) powm involving CHUNK_MOD"
				 " and CHUNK_EXP_QUOTIENT elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

	 clock_r_given = clock();
	 mpz_powm_ui(RA,CHUNK_MOD_POWERED_MOD,multiple_of_1365,N);
	 clocks_r_given = (clock() - clock_r_given);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("r_given_chunk_2exp(%lld) powm_ui involving"
				 " multiple_of_1365 elapsed secs=%ld.\n",
				 c2e,elapsed_secs);
	 }

	 mpz_clear(CHUNK_MOD);
	 mpz_clear(CHUNK_EXP_QUOTIENT);
	 mpz_clear(CHUNK_MOD_POWERED_MOD);
	 return (unsigned long long)mpz_sizeinbase(RA,10);
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(r_given_chunk_2exp__doc__,
"Calculate remainder of a^r mod(n) using chunk algorithm.");

/* Wrapper around the underlying C function */
static PyObject *
py_r_given_chunk_2exp(PyObject *self, PyObject *args)
{
  /* The function r_given_chunk_2exp() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long rresult;
	unsigned long chunk_2exp;
	/* "args" signature is long */
	/* ':r_given_chunk_2exp' for error messages */
	if (!PyArg_ParseTuple(args, "l:r_given_chunk_2exp", &chunk_2exp))
		return NULL;

	if (chunk_2exp < 0 || chunk_2exp > ULONG_MAX) {
	  return NULL;
	}

	rresult = r_given_chunk_2exp((unsigned long long)chunk_2exp);

	if (rresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)rresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long r_given_chunk_2exp_low(unsigned long long c2e) {
  extern mpz_t A, N, RA;
  extern   unsigned long multiple_of_1365;
  extern mpz_t HALF_OF_TWO_TO_K;
  mpz_t CHUNK_MOD;
  mpz_t CHUNK_MOD_POWERED_MOD;
  mpz_t A_TO_CHUNK_EXP;
  mpz_t CHUNK_EXP_QUOTIENT;
  unsigned long long chunk_exp = 0;
  extern unsigned int	debug_flag;

  unsigned long long outCHUNK_EXP_QUOTIENTlen = 0;
  char      *outCHUNK_EXP_QUOTIENT;
  char      *outCHUNK_EXP_QUOTIENTtail;

  /*
  unsigned long long chunk_exp_howmany = 1;
  unsigned long chunk_extra_2exp = 0;
  unsigned long long chunk_extra_exp = 0;
  */

	 long clock_rgc_start = 0;
	 long clocks_rgc = 0;
	 long elapsed_secs_rgc = 0;

	extern unsigned int	debug_flag;

  chunk_exp = pow(2,c2e);

  if (debug_flag > 0) {
	 printf("r_given_chunk_2exp_low(%lld) derived chunk_exp=%lld\n",
			  c2e,chunk_exp);
  }

  mpz_init(A_TO_CHUNK_EXP);
  mpz_pow_ui(A_TO_CHUNK_EXP,A,chunk_exp);
  mpz_init(CHUNK_MOD);
  mpz_mod(CHUNK_MOD,A_TO_CHUNK_EXP,N);
  mpz_init(CHUNK_EXP_QUOTIENT);
  mpz_tdiv_q_ui(CHUNK_EXP_QUOTIENT,HALF_OF_TWO_TO_K,chunk_exp);

  outCHUNK_EXP_QUOTIENT = mpz_get_str(NULL,10,CHUNK_EXP_QUOTIENT);
  outCHUNK_EXP_QUOTIENTlen = strlen(outCHUNK_EXP_QUOTIENT);
  if (outCHUNK_EXP_QUOTIENTlen < 81) {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and" 
				 " in full CHUNK_EXP_QUOTIENT=%s\n",
				 outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
	 }
	 fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
				" digits and in full CHUNK_EXP_QUOTIENT=%s\n",
				outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENT);
	 fflush(outfnotes);
  } else {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_QUOTIENT has %lld decimal digits and ends %s\n",
				 outCHUNK_EXP_QUOTIENTlen,
				 &outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
	 }
 	 asprintf(&outCHUNK_EXP_QUOTIENTtail,
				 "%s",&outCHUNK_EXP_QUOTIENT[(outCHUNK_EXP_QUOTIENTlen-10)]);
	 fprintf(outfnotes,"CHUNK_EXP_QUOTIENT having %lld decimal"
				" digits and ending %s\n",
				outCHUNK_EXP_QUOTIENTlen,outCHUNK_EXP_QUOTIENTtail);
  }

  mpz_init(CHUNK_MOD_POWERED_MOD);
  mpz_powm(CHUNK_MOD_POWERED_MOD,CHUNK_MOD,CHUNK_EXP_QUOTIENT,N);
  clocks_rgc = (clock() - clock_rgc_start);
  elapsed_secs_rgc = clocks_rgc / CLOCKS_PER_SEC;
  if (debug_flag > 0) {
	 printf("r_given_chunk_2exp_low powm(,,CHUNK_EXP_QUOTIENT,N)"
			 " elapsed %ld seconds.\n",elapsed_secs_rgc);
  }

  mpz_powm_ui(RA,CHUNK_MOD_POWERED_MOD,multiple_of_1365,N);
  clocks_rgc = (clock() - clock_rgc_start);
  elapsed_secs_rgc = clocks_rgc / CLOCKS_PER_SEC;
  if (debug_flag > 0) {
	 printf("r_given_chunk_2exp_low powm_ui(,,multiple_of_1365,N)"
			 " elapsed %ld seconds.\n",elapsed_secs_rgc);
  }

  mpz_clear(A_TO_CHUNK_EXP);
  mpz_clear(CHUNK_MOD);
  mpz_clear(CHUNK_EXP_QUOTIENT);
  mpz_clear(CHUNK_MOD_POWERED_MOD);
  return (unsigned long long)mpz_sizeinbase(RA,10);
}


/* Short description of the function (one liner). */
PyDoc_STRVAR(r_given_chunk_2exp_low__doc__,
"Calculate remainder of a^r mod(n) using chunk algorithm.");

/* Wrapper around the underlying C function */
static PyObject *
py_r_given_chunk_2exp_low(PyObject *self, PyObject *args)
{
  /* The function r_given_chunk_2exp_low() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long rresult;
	unsigned long chunk_2exp;
	/* "args" signature is long */
	/* ':r_given_chunk_2exp_low' for error messages */
	if (!PyArg_ParseTuple(args, "l:r_given_chunk_2exp_low", &chunk_2exp))
		return NULL;

	if (chunk_2exp < 0 || chunk_2exp > ULONG_MAX) {
	  return NULL;
	}

	rresult = r_given_chunk_2exp_low((unsigned long long)chunk_2exp);

	if (rresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)rresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned int mod_where_multiple_of_1365_in_exponent_chunked(unsigned long long expk,
																				unsigned long long kmo) {
  extern mpz_t A, N, RA;  /* RA is abbreviation for R obtained by algorithm */
  extern mpz_t HALF_OF_TWO_TO_K;
  mpz_t CHUNK_EXP_HOWMANY;
  extern   unsigned long multiple_of_1365;
  extern unsigned long long size5_ultimate;
  extern unsigned int	debug_flag;

  unsigned long long outRAlen = 0;
  char      *outRA;
  char      *outRAtail;
  unsigned long long size10n = 0;

  long clock_mod_where_start = 0;
  long clocks_r_given = 0;
  long elapsed_secs = 0;

  unsigned long long chunk_2exp = 0;
  unsigned long long chunk_exp = 0;
  unsigned long long chunk_exp_original = 0;
  unsigned long long chunk_exp_returned = 0;
  unsigned long long chunk_exp_improved = 0;
  unsigned long long chunk_exp_howmany = 1;
  unsigned long chunk_extra_2exp = 0;
  unsigned long long chunk_extra_exp = 0;
  unsigned long long logish_a_of_n = 0;

  unsigned long long outCHUNK_EXP_HOWMANYlen = 0;
  char      *outCHUNK_EXP_HOWMANY;
  char      *outCHUNK_EXP_HOWMANYtail;

  size10n = mpz_sizeinbase(N,10);

  if (size10n < 10000) {
	 logish_a_of_n = log_to_base_a_of_n_veryapprox();
	 if (debug_flag > 0) {
		printf("logish_a_of_n_veryapprox() returned %lld\n",logish_a_of_n);
	 }
  } else {
	 logish_a_of_n = log_to_base_a_of_n_based_on_size10(0);
	 /* passing 0 as arg means you do not override A and function will obtain
		 from mpz_get_ui(A) */
	 if (debug_flag > 0) {
		printf("logish_a_of_n_based_on_size10() returned %lld\n",logish_a_of_n);
	 }
  }

  while(pow(2,chunk_2exp) < logish_a_of_n) {
	 chunk_2exp = chunk_2exp + 1;
  }

  if (debug_flag > 0) {
	 printf("chunk_2exp=%lld\n",chunk_2exp);
  }

  /* if (size10n < 10000) { */
	 chunk_2exp = chunk_2exp_improve(chunk_2exp,kmo,4);
  /* } */

  if (debug_flag > 0) {
	 printf("chunk_2exp=%lld after 2exp_improve attempt\n",chunk_2exp);
  }

  chunk_exp = pow(2,chunk_2exp);
  if (debug_flag > 0) {
	 printf("chunk_exp=%lld\n",chunk_exp);
  }

  chunk_exp_original = chunk_exp;

  if (size10n < 10000) {

	 if (debug_flag > 0) {
		printf("exp_improve(,,2) called next\n");
		printf("before exp_improve(,,2) chunk_exp=%lld\n",chunk_exp);
	 }
	 chunk_exp = chunk_exp_improve(chunk_exp,kmo,2);
	 if (debug_flag > 0) {
		printf("after exp_improve(,,2) chunk_exp=%lld\n",chunk_exp);
	 }

	 if (chunk_exp == chunk_exp_original) {
		if (debug_flag > 0) { printf("exp_improve(,3) called next\n"); }
		chunk_exp = chunk_exp_improve(chunk_exp,kmo,3);
		if (debug_flag > 0) {
		  printf("chunk_exp=%lld after exp_improve(,3) completed\n",
					chunk_exp);
		}
	 }

	 if (chunk_exp == chunk_exp_original) {
		if (debug_flag > 0) { printf("exp_improve(,4) called next\n"); }
		chunk_exp = chunk_exp_improve(chunk_exp,kmo,4);
		if (debug_flag > 0) {
		  printf("chunk_exp=%lld after exp_improve(,4) completed\n",
					chunk_exp);
		}
	 }

  }

  mpz_init(CHUNK_EXP_HOWMANY);
  if (size10n < 10000) {
	 chunk_extra_exp = mpz_fdiv_q_ui(CHUNK_EXP_HOWMANY,HALF_OF_TWO_TO_K,chunk_exp);
  }

  outCHUNK_EXP_HOWMANY = mpz_get_str(NULL,10,CHUNK_EXP_HOWMANY);
  outCHUNK_EXP_HOWMANYlen = strlen(outCHUNK_EXP_HOWMANY);
  if (outCHUNK_EXP_HOWMANYlen < 81) {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_HOWMANY has %lld decimal digits and" 
				 " in full CHUNK_EXP_HOWMANY=%s\n",
				 outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANY);
	 }
	 fprintf(outfnotes,"CHUNK_EXP_HOWMANY having %lld decimal"
				" digits and in full CHUNK_EXP_HOWMANY=%s\n",
				outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANY);
	 fflush(outfnotes);
  } else {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_HOWMANY has %lld decimal digits and ends %s\n",
				 outCHUNK_EXP_HOWMANYlen,
				 &outCHUNK_EXP_HOWMANY[(outCHUNK_EXP_HOWMANYlen-10)]);
	 }
 	 asprintf(&outCHUNK_EXP_HOWMANYtail,
				 "%s",&outCHUNK_EXP_HOWMANY[(outCHUNK_EXP_HOWMANYlen-10)]);
	 fprintf(outfnotes,"CHUNK_EXP_HOWMANY having %lld decimal"
				" digits and ending %s\n",
				outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANYtail);
  }

  if (debug_flag > 0) {
	 printf("%ld + ...\n",multiple_of_1365);
	 printf("... %lld + ...\n",chunk_extra_exp);
	 printf("CHUNK_EXP_HOWMANY * ...\n");
	 printf("%lld is best prediction of ...chunked()\n",chunk_exp);
  }

  mpz_init_set_ui(RA,0);

  clock_mod_where_start = clock();

  r_given_chunk_2exp(chunk_2exp);

  clocks_r_given = (clock() - clock_mod_where_start);
  elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
  if (debug_flag > 0) {
	 printf("r_given_chunk_2exp completed in %ld seconds.\n",elapsed_secs);
	 printf("...exponent_chunked() algorithm completed and result is in RA.\n");
	 printf("RA initialised and populated using (mod N).\n");
  }

  outRA = mpz_get_str(NULL,10,RA);
  outRAlen = strlen(outRA);

  if (outRAlen < 81) {
	 if (debug_flag > 0) {
		printf("RA has %lld decimal digits and" 
				 " in full RA=%s\n",outRAlen,outRA);
	 }
	 fprintf(outfnotes,"expk=%lld gives RA having %lld decimal digits and"
				" in full RA=%s\n",expk,outRAlen,outRA);
	 fflush(outfnotes);
  } else {
	 if (debug_flag > 0) {
		printf("RA has %lld decimal digits and ends %s\n",
				 outRAlen,&outRA[(outRAlen-10)]);
	 }
 
	 asprintf(&outRAtail,"%s",&outRA[(outRAlen-10)]);
	 fprintf(outfnotes,"expk=%lld gives RA having %lld decimal digits and"
				" ending %s\n",expk,outRAlen,outRAtail);
	 fflush(outfnotes);
  }

  mpz_set(R, RA);

  /* return value for convenience only, see mpz R usually */
  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(mod_where_multiple_of_1365_in_exponent_chunked__doc__,
"mod_where_multiple_of_1365_in_exponent by chunked algorithm");

/* Wrapper around the underlying C function */
static PyObject *
py_mod_where_multiple_of_1365_in_exponent_chunked(PyObject *self, PyObject *args)
{
  /* The function mod_where_multiple_of_1365_in_exponent_chunked() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long mwresult;
	unsigned long e_k;
   unsigned long long k_m_o;
	/* "args" signature is long */
	/* ':mod_where_multiple_of_1365_in_exponent_chunked' for error messages */
	if (!PyArg_ParseTuple(args, "ll:mod_where_multiple_of_1365_in_exponent_chunked",
								 &e_k, &k_m_o))
		return NULL;

	if (e_k < 0 || e_k > ULONG_MAX) {
	  return NULL;
	}

	mwresult = mod_where_multiple_of_1365_in_exponent_chunked(
															 (unsigned long long)e_k,
															  (unsigned long long)k_m_o);

	if (mwresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)mwresult);
}
/* no static prefix as may be called by other functions defined in this .c file */
unsigned int mod_where_multiple_of_1365_in_exponent_chunked2(unsigned long long expk,
																				unsigned long long kmo) {

  extern const unsigned long two_to_twenty_seven;
  extern const unsigned long two_to_twenty_eight;
  extern const unsigned long two_to_twenty_nine;
  extern const unsigned long two_to_thirty;
  extern const unsigned long two_to_thirty_one;
  extern const unsigned long long two_to_thirty_two;
  extern const unsigned long long two_to_thirty_three;
  extern const unsigned long long two_to_thirty_four;
  extern const unsigned long long two_to_thirty_five;
  extern const unsigned long long two_to_thirty_six;
  extern const unsigned long long two_to_thirty_seven;
  extern const unsigned long long two_to_thirty_eight;
  extern const unsigned long long two_to_thirty_nine;
  extern const unsigned long long two_to_fourty;
  extern const unsigned long long two_to_fourty_one;
  extern const unsigned long long two_to_fourty_two;
  extern const unsigned long long two_to_fourty_three;
  extern const unsigned long long two_to_fourty_four;
  extern const unsigned long long two_to_fourty_five;
  extern const unsigned long long two_to_fourty_six;
  extern const unsigned long long two_to_fourty_seven;
  extern const unsigned long long two_to_fourty_eight;
  extern const unsigned long long two_to_fourty_nine;
  extern const unsigned long long two_to_fifty;
  extern const unsigned long long two_to_fifty_one;
  extern const unsigned long long two_to_fifty_two;
  extern const unsigned long long two_to_fifty_three;
  extern const unsigned long long two_to_fifty_four;
  extern const unsigned long long two_to_fifty_five;
  extern const unsigned long long two_to_fifty_six;
  extern const unsigned long long two_to_fifty_seven;
  extern const unsigned long long two_to_fifty_eight;
  extern const unsigned long long two_to_fifty_nine;
  extern const unsigned long long two_to_sixty;
  extern const unsigned long long two_to_sixty_one;
  extern const unsigned long long two_to_sixty_two;
  extern const unsigned long long two_to_sixty_three;

  extern mpz_t A, N, RA;  /* RA is abbreviation for R obtained by algorithm */
  extern mpz_t HALF_OF_TWO_TO_K;
  mpz_t CHUNK_EXP_HOWMANY;
  extern   unsigned long multiple_of_1365;
  extern unsigned long long size5_ultimate;
  extern unsigned int	debug_flag;

  unsigned long long outRAlen = 0;
  char      *outRA;
  char      *outRAtail;
  unsigned long long size10n = 0;

  long clock_mod_where_start = 0;
  long clocks_r_given = 0;
  long elapsed_secs = 0;

  unsigned long long chunk_2exp = 0;
  unsigned long long chunk_exp = 0;
  unsigned long long chunk_extra_exp = 0;
  unsigned long long logish_a_of_n = 0;

  unsigned long long outCHUNK_EXP_HOWMANYlen = 0;
  char      *outCHUNK_EXP_HOWMANY;
  char      *outCHUNK_EXP_HOWMANYtail;

  size10n = mpz_sizeinbase(N,10);

  if (size10n < 10000) {
	 logish_a_of_n = log_to_base_a_of_n_veryapprox();
	 if (debug_flag > 0) {
		printf("logish_a_of_n_veryapprox() returned %lld\n",logish_a_of_n);
	 }
  } else {
	 logish_a_of_n = log_to_base_a_of_n_based_on_size10(0);
	 /* passing 0 as arg means you do not override A and function will obtain
		 from mpz_get_ui(A) */
	 if (debug_flag > 0) {
		printf("logish_a_of_n_based_on_size10() returned %lld\n",logish_a_of_n);
	 }
  }

  while(pow(2,chunk_2exp) < logish_a_of_n) {
	 chunk_2exp = chunk_2exp + 1;
  }

  if (debug_flag > 0) {
	 printf("chunk_2exp=%lld\n",chunk_2exp);
  }

  switch(chunk_2exp) {
  case 27:
	 chunk_exp = two_to_twenty_seven;
	 break;
  case 28:
	 chunk_exp = two_to_twenty_eight;
	 break;
  case 29:
	 chunk_exp = two_to_twenty_nine;
	 break;
  case 30:
	 chunk_exp = two_to_thirty;
	 break;
  case 31:
	 chunk_exp = two_to_thirty_one;
	 break;
  case 32:
	 chunk_exp = two_to_thirty_two;
	 break;
  case 33:
	 chunk_exp = two_to_thirty_three;
	 break;
  case 34:
	 chunk_exp = two_to_thirty_four;
	 break;
  case 35:
	 chunk_exp = two_to_thirty_five;
	 break;
  case 36:
	 chunk_exp = two_to_thirty_six;
	 break;
  case 37:
	 chunk_exp = two_to_thirty_seven;
	 break;
  case 38:
	 chunk_exp = two_to_thirty_eight;
	 break;
  case 39:
	 chunk_exp = two_to_thirty_nine;
	 break;
  case 40:
	 chunk_exp = two_to_fourty;
	 break;
  case 41:
	 chunk_exp = two_to_fourty_one;
	 break;
  case 42:
	 chunk_exp = two_to_fourty_two;
	 break;
  case 43:
	 chunk_exp = two_to_fourty_three;
	 break;
  case 44:
	 chunk_exp = two_to_fourty_four;
	 break;
  case 45:
	 chunk_exp = two_to_fourty_five;
	 break;
  case 46:
	 chunk_exp = two_to_fourty_six;
	 break;
  case 47:
	 chunk_exp = two_to_fourty_seven;
	 break;
  case 48:
	 chunk_exp = two_to_fourty_eight;
	 break;
  case 49:
	 chunk_exp = two_to_fourty_nine;
	 break;
  case 50:
	 chunk_exp = two_to_fifty;
	 break;
  case 51:
	 chunk_exp = two_to_fifty_one;
	 break;
  case 52:
	 chunk_exp = two_to_fifty_two;
	 break;
  case 53:
	 chunk_exp = two_to_fifty_three;
	 break;
  case 54:
	 chunk_exp = two_to_fifty_four;
	 break;
  case 55:
	 chunk_exp = two_to_fifty_five;
	 break;
  case 56:
	 chunk_exp = two_to_fifty_six;
	 break;
  case 57:
	 chunk_exp = two_to_fifty_seven;
	 break;
  case 58:
	 chunk_exp = two_to_fifty_eight;
	 break;
  case 59:
	 chunk_exp = two_to_fifty_nine;
	 break;
  case 60:
	 chunk_exp = two_to_sixty;
	 break;
  case 61:
	 chunk_exp = two_to_sixty_one;
	 break;
  case 62:
	 chunk_exp = two_to_sixty_two;
	 break;
  case 63:
	 chunk_exp = two_to_sixty_three;
	 break;

  default:
	 if (debug_flag > 0) {
		printf("switch(.) default will derive chunk_exp from chunk_2exp.\n");
	 }

	 clock_mod_where_start = clock();

	 chunk_exp = pow(2,chunk_2exp);

	 clocks_r_given = (clock() - clock_mod_where_start);
	 elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;

	 if (debug_flag > 0) {
		printf("switch(.) default derive chunk_exp completed ..."
				 " elapsed secs=%ld.\n",elapsed_secs);
	 }
  } /* end of switch */

  if (debug_flag > 0) {
	 printf("chunk_exp=%lld\n",chunk_exp);
  }

  mpz_init(CHUNK_EXP_HOWMANY);
  if (size10n < 10000) {
	 chunk_extra_exp = mpz_fdiv_q_ui(CHUNK_EXP_HOWMANY,HALF_OF_TWO_TO_K,chunk_exp);
  }

  outCHUNK_EXP_HOWMANY = mpz_get_str(NULL,10,CHUNK_EXP_HOWMANY);
  outCHUNK_EXP_HOWMANYlen = strlen(outCHUNK_EXP_HOWMANY);
  if (outCHUNK_EXP_HOWMANYlen < 81) {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_HOWMANY has %lld decimal digits and" 
				 " in full CHUNK_EXP_HOWMANY=%s\n",
				 outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANY);
	 }
	 fprintf(outfnotes,"CHUNK_EXP_HOWMANY having %lld decimal"
				" digits and in full CHUNK_EXP_HOWMANY=%s\n",
				outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANY);
	 fflush(outfnotes);
  } else {
	 if (debug_flag > 0) {
		printf("CHUNK_EXP_HOWMANY has %lld decimal digits and ends %s\n",
				 outCHUNK_EXP_HOWMANYlen,
				 &outCHUNK_EXP_HOWMANY[(outCHUNK_EXP_HOWMANYlen-10)]);
	 }
 	 asprintf(&outCHUNK_EXP_HOWMANYtail,
				 "%s",&outCHUNK_EXP_HOWMANY[(outCHUNK_EXP_HOWMANYlen-10)]);
	 fprintf(outfnotes,"CHUNK_EXP_HOWMANY having %lld decimal"
				" digits and ending %s\n",
				outCHUNK_EXP_HOWMANYlen,outCHUNK_EXP_HOWMANYtail);
  }

  if (debug_flag > 0) {
	 printf("%ld + ...\n",multiple_of_1365);
	 printf("... %lld + ...\n",chunk_extra_exp);
	 printf("CHUNK_EXP_HOWMANY * ...\n");
	 printf("%lld is best prediction of ...chunked2()\n",chunk_exp);
  }

  mpz_init_set_ui(RA,0);

  clock_mod_where_start = clock();

  r_given_chunk_2exp_and_kmo_staged(chunk_2exp,kmo,2);

  clocks_r_given = (clock() - clock_mod_where_start);
  elapsed_secs = clocks_r_given / CLOCKS_PER_SEC;
  if (debug_flag > 0) {
	 printf("r_given_chunk_2exp completed in %ld seconds.\n",elapsed_secs);
	 printf("...exponent_chunked2() algorithm completed and result is in RA.\n");
	 printf("RA initialised and populated using (mod N).\n");
  }

  outRA = mpz_get_str(NULL,10,RA);
  outRAlen = strlen(outRA);

  if (outRAlen < 81) {
	 if (debug_flag > 0) {
		printf("RA has %lld decimal digits and" 
				 " in full RA=%s\n",outRAlen,outRA);
	 }
	 fprintf(outfnotes,"expk=%lld gives RA having %lld decimal digits and"
				" in full RA=%s\n",expk,outRAlen,outRA);
	 fflush(outfnotes);
  } else {
	 if (debug_flag > 0) {
		printf("RA has %lld decimal digits and ends %s\n",
				 outRAlen,&outRA[(outRAlen-10)]);
	 }
 
	 asprintf(&outRAtail,"%s",&outRA[(outRAlen-10)]);
	 fprintf(outfnotes,"expk=%lld gives RA having %lld decimal digits and"
				" ending %s\n",expk,outRAlen,outRAtail);
	 fflush(outfnotes);
  }

  mpz_set(R, RA);

  /* return value for convenience only, see mpz R usually */
  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(mod_where_multiple_of_1365_in_exponent_chunked2__doc__,
"mod_where_multiple_of_1365_in_exponent by chunked algorithm");

/* Wrapper around the underlying C function */
static PyObject *
py_mod_where_multiple_of_1365_in_exponent_chunked2(PyObject *self, PyObject *args)
{
  /* The function mod_where_multiple_of_1365_in_exponent_chunked2() really only supports calls from
	  within this .c file itself, however a part functioning wrapper
	  is provided anyway.
  */
   unsigned long long mwresult;
	unsigned long e_k;
   unsigned long long k_m_o;
	/* "args" signature is long */
	/* ':mod_where_multiple_of_1365_in_exponent_chunked2' for error messages */
	if (!PyArg_ParseTuple(args, "ll:mod_where_multiple_of_1365_in_exponent_chunked2",
								 &e_k, &k_m_o))
		return NULL;

	if (e_k < 0 || e_k > ULONG_MAX) {
	  return NULL;
	}

	mwresult = mod_where_multiple_of_1365_in_exponent_chunked2(
															 (unsigned long long)e_k,
															  (unsigned long long)k_m_o);

	if (mwresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)mwresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned int calculate_split(unsigned int sibt, unsigned int tstbit) {
  /* sibt is short for size in base 2 */
  /* tstbit is the result of examining the (sibt-1)th bit */
  unsigned int ports = 1048576;
  unsigned int ports_2exp = 1;
  /* We will calculate ports, but worth remembering that
	  for gigantic exponents, portions = 8192 is not enough */
  extern unsigned int slice_size_max_2exp;
  extern unsigned int	debug_flag;
  if (sibt > 3) {
	 if (sibt > slice_size_max_2exp) {
		ports_2exp = sibt - slice_size_max_2exp;
	 } else {
		ports_2exp = sibt - 2;
	 }
  }
  /* There will be more splits if the (sibt-1)th bit is set */
  ports_2exp += tstbit;
  ports = pow(2,ports_2exp);
  if (debug_flag > 0) {
	 printf("calculate_split should return a split that means individual portions"
			  " are <= 2^%d in size\n",slice_size_max_2exp);
	 printf("calculate_split is running with sibt==%d and tstbit=%d\n",sibt,tstbit);
	 printf("returning ports=%d\n",ports);
  }
  return ports;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(calculate_split__doc__,
"Calculate (and return) number of portions.");

/* Wrapper around the underlying C function */
static PyObject *
py_calculate_split(PyObject *self, PyObject *args)
{
   unsigned int splitresult;
	unsigned int sibt_given;
	unsigned int tstbit_given;
	/* "args" signature is integer,integer */
	/* ':calculate_split' for error messages */
	if (!PyArg_ParseTuple(args, "ii:calculate_split", &sibt_given, &tstbit_given))
		return NULL;

  /* sibt_given is short for size in base 2 */
  /* tstbit_given is the result of examining the (sibt-1)th bit */
	if (tstbit_given < 0 || tstbit_given > 1) {
	  return NULL;
	}

	splitresult = calculate_split(sibt_given, tstbit_given);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)splitresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned int calculate_split_wrapper_int(unsigned int exp) {
  unsigned long size2exp = 0;
  unsigned long tstbit_working = 0;
  unsigned long tstbit_result = 0;
  unsigned int portions_int = 0;
  size2exp = size2gmp(exp);
  tstbit_working = exp >> (size2exp - 2);
  tstbit_result = tstbit_working & 1;
  portions_int = calculate_split(size2exp,tstbit_result);
  return portions_int;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(calculate_split_wrapper_int__doc__,
"Derive 2nd of argument of 2 for calculate_split() from just single argument input.");

/* Wrapper around the underlying C function */
static PyObject *
py_calculate_split_wrapper_int(PyObject *self, PyObject *args)
{
   unsigned long cswrapperresult;
	unsigned int exp_given;
	/* "args" signature is long */
	/* ':calculate_split_wrapper_int' for error messages */
	if (!PyArg_ParseTuple(args, "i:calculate_split_wrapper_int", &exp_given))
		return NULL;

	if (exp_given < 2) {
	  return NULL;
	}

	cswrapperresult = calculate_split_wrapper_int(exp_given);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)cswrapperresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long long calculate_split_wrapper_longlong(unsigned int exp) {
  unsigned long long size2exp = 0;
  unsigned long tstbit_working = 0;
  unsigned long tstbit_result = 0;
  unsigned int portions_int = 0;
  extern unsigned int	debug_flag;
  if (debug_flag > 0) {
	 printf("size2longlong() is next call.\n");
  }
  size2exp = size2longlong(exp);
  if (debug_flag > 0) {
	 printf("size2longlong() returned result, now continuing.\n");
  }
  tstbit_working = exp >> (size2exp - 2);
  tstbit_result = tstbit_working & 1;
  portions_int = calculate_split((int)size2exp,tstbit_result);
  return (long long)portions_int;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(calculate_split_wrapper_longlong__doc__,
"Derive 2nd of argument of 2 for calculate_split() from just single argument input.");

/* Wrapper around the underlying C function */
static PyObject *
py_calculate_split_wrapper_longlong(PyObject *self, PyObject *args)
{
  /* The function calculate_split_wrapper_longlong really only supports
	  calls from within this .c file itself, however
	  a part functioning wrapper is provided anyway.
  */
   unsigned long cswrapperresult;
	unsigned long exp_l;
	/* "args" signature is long */
	/* ':calculate_split_wrapper_longlong' for error messages */
	if (!PyArg_ParseTuple(args, "l:calculate_split_wrapper_longlong", &exp_l))
		return NULL;

	if (exp_l < 2 || exp_l > ULONG_MAX) {
	  return NULL;
	}

	cswrapperresult = \
	  calculate_split_wrapper_longlong((unsigned long long)exp_l);

	if (cswrapperresult > ULONG_MAX) {
	  /* Decision to return (long) only - no long long */
	  return NULL;
	}

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)cswrapperresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned long mod_where_multiple_of_1365_in_exponent_limited(
				 unsigned int portion_count_limit, mpz_t EXP, unsigned int exp_un2k) {

	 mpz_t		SL2K, EX2K;
	 extern mpz_t		R_IN_PROGRESS_LIMITED_INPUT;
	 extern mpz_t		R_IN_PROGRESS_LIMITED;
	 mpz_t		R_IN_PROGRESS_LTD; /* Used only internally within function */

	unsigned int portion_count_exp = 0;
	unsigned int portions_exp = 128;
	unsigned int slice = 0;
	unsigned int extra = 0;

	unsigned long size10long = 0;

	 long clock_mod_where_limited_start = 0;
	 long clocks_mod_where_limited = 0;
	 long elapsed_secs_limited = 0;

	extern unsigned int	debug_flag;

	if (debug_flag > 0) {
		printf("mod_where_multiple_of_1365_limited() processing exp_un2k=%d begins...\n",
				 exp_un2k);
		size10long = mpz_sizeinbase(N,10);
		printf("N has size %ld (approx)\n",size10long);
		size10long = mpz_sizeinbase(R_IN_PROGRESS_LIMITED_INPUT,10);
		printf("before processing (R_IN_PROGRESS_LIMITED_INPUT)"
				 " we were given a %ld digit (approx) starting point\n",
				 size10long);
		size10long = mpz_sizeinbase(EXP,10);
		if (size10long < 81) {
		  gmp_printf("EXP=%Zd\n",EXP);
		}
	}

	clock_mod_where_limited_start = clock();

	if (portion_count_limit > exp_un2k) {
	  if (debug_flag > 0) {
		 printf("mod_where_multiple_of_1365_limited() %d > exp_un2k ( %d > %d).\n",
				  portion_count_limit,portion_count_limit,exp_un2k);
		 printf("calculate_split call not required therefore.\n");
		 printf("mod_where_multiple_of_1365_limited() jumped straight to mpz_powm().\n");
	  }
	  mpz_powm(R_IN_PROGRESS_LIMITED, R_IN_PROGRESS_LIMITED_INPUT, EXP, N);
	  clocks_mod_where_limited = (clock() - clock_mod_where_limited_start);
	  elapsed_secs_limited = clocks_mod_where_limited / CLOCKS_PER_SEC;
	  if (debug_flag > 0) {

		 printf("mod_where_multiple_of_1365_limited(%d,,%d)"
				 " elapsed %ld seconds.\n",portion_count_limit,exp_un2k,
				 elapsed_secs_limited);

		 size10long = mpz_sizeinbase(R_IN_PROGRESS_LIMITED,10);
		 printf("after processing (R_IN_PROGRESS_LIMITED)"
				 " we have now a %ld digit (approx) result saved\n",
				 size10long);
		 if (size10long < 81) {
			gmp_printf("jump straight to mpz_powm for mod(blah^%Zd,N) resulted in"
						  " R_IN_PROGRESS_LIMITED=%Zd\n",EXP,R_IN_PROGRESS_LIMITED);
		 }
	  }
	  fprintf(outfnotes, "mod_where_multiple_of_1365_limited(%d,,%d)"
				 " elapsed %ld seconds.\n",portion_count_limit,exp_un2k,
				 elapsed_secs_limited);
	  fflush(outfnotes);
	  return 0;
	}

	portions_exp = calculate_split_wrapper_int(exp_un2k);
	if (portions_exp < 1) {
	  mpz_set(R_IN_PROGRESS_LIMITED, R_IN_PROGRESS_LIMITED_INPUT);
	  return 101;
	}

	 slice = exp_un2k / portions_exp;
	 extra = exp_un2k - ((portions_exp - 1) * slice);

	 if (debug_flag > 0) {
		printf("slice now populated.\n");
		printf("slice=%d now populated.\n",slice);
		printf("...limited() slice and extra now populated.\n");
		printf("slice=%d and extra=%d now populated.\n",
				 slice,extra);
	 }

	 if (pow(2,slice) > portion_count_limit) {
		/* slice = 9 making 2^9 > 256 would return 151 error here if
			you provided 256 as portion_count_limit to indicate that
			exponentiation should never be attempted for any exponent
			larger than 256. */
		return 151;
	 }

	 mpz_init(SL2K);
	 mpz_ui_pow_ui(SL2K,2,slice);
	 if (mpz_cmp_ui(SL2K,portion_count_limit) > 0) {
		return 151;
	 }

	 mpz_init(EX2K);
	 mpz_ui_pow_ui(EX2K,2,extra);

	 mpz_init(R_IN_PROGRESS_LTD);
	 mpz_powm(R_IN_PROGRESS_LTD, R_IN_PROGRESS_LIMITED_INPUT, EX2K, N);

	 for (portion_count_exp = 1; portion_count_exp < portions_exp; portion_count_exp++) {
		if (debug_flag > 0) {
		  printf("Iteration having portion_count=%d ( <= %d ) has started.\n",
				 portion_count_exp,portion_count_limit);
		}
		mpz_powm(R_IN_PROGRESS_LTD, R_IN_PROGRESS_LTD, SL2K, N); 
	 }

	 clocks_mod_where_limited = (clock() - clock_mod_where_limited_start);
	 elapsed_secs_limited = clocks_mod_where_limited / CLOCKS_PER_SEC;

	 mpz_set(R_IN_PROGRESS_LIMITED, R_IN_PROGRESS_LTD);
	 mpz_clear(R_IN_PROGRESS_LTD);

	 if (debug_flag > 0) {

		printf("mod_where_multiple_of_1365_limited(%d,,%d)"
				 " elapsed %ld seconds.\n",portion_count_limit,exp_un2k,
				 elapsed_secs_limited);

		size10long = mpz_sizeinbase(R_IN_PROGRESS_LIMITED,10);
		printf("after processing (R_IN_PROGRESS_LIMITED)"
				 " we have now a %ld digit (approx) result saved\n",
				 size10long);
		if (size10long < 81) {
		  gmp_printf("R_IN_PROGRESS_LIMITED=%Zd\n",
						  R_IN_PROGRESS_LIMITED);
		}
	 }

	 fprintf(outfnotes, "mod_where_multiple_of_1365_limited(%d,,%d)"
				 " elapsed %ld seconds.\n",portion_count_limit,exp_un2k,
				 elapsed_secs_limited);
	 fflush(outfnotes);

	 return 0;
 }

/* Short description of the function (one liner). */
PyDoc_STRVAR(mod_where_multiple_of_1365_in_exponent_limited__doc__,
"modulo of small to large exponent where exponent is 2 to some power utilising slice + extra");

/* Wrapper around the underlying C function */
static PyObject *
py_mod_where_multiple_of_1365_in_exponent_limited(PyObject *self, PyObject *args)
{
	unsigned int port_count_limit;
	unsigned int e_un2k;
	long mwresult;
	mpz_t E;
	/* "args" signature is integer, integer */
	/* ':mod_where' for error messages */
	if (!PyArg_ParseTuple(args, "ii:mod_where", &port_count_limit, &e_un2k))
		return NULL;

	/* parameters that are invalid might be corrected here */
	if (e_un2k < 1) e_un2k = 1;

	/* assumption here is that internal calls to the C function might
		already have initialised and set R_IN_PROGRESS_LIMITED_INPUT, however
		calls from Python (testing etc)
		will not have set R_IN_PROGRESS_LIMITED_INPUT.
	*/
	mpz_init_set_ui(R_IN_PROGRESS_LIMITED_INPUT,6);
	mpz_init(N);
	mpz_mul_2exp(N,FOURZERONINEFIVE,e_un2k);
	mpz_add(N,N,ONE);

	mpz_init(E);
	mpz_mul_2exp(E,ONE,e_un2k);
	
	mwresult = mod_where_multiple_of_1365_in_exponent_limited(
		port_count_limit,E,e_un2k);
	
	mpz_clear(E);

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)mwresult);
}

/* no static prefix as may be called by other functions defined in this .c file */
unsigned int nonresidue_value(unsigned int nrv_limit) {
  unsigned int nrv_candidate = 0;
  int nrv_result = -999;
  for(nrv_candidate = 2; nrv_candidate < nrv_limit ; nrv_candidate++) {
	 nrv_result = mpz_ui_kronecker(nrv_candidate, N);
	 if (nrv_result < 1)
		break;
  }
  /* function needs enhancing as does not deal properly 
	  with case where nrv_limit is set low
	  and/or for loop hits nrv_limit.
	  Suggest supplying nrv_limit as 1000 until enhanced. */
  return nrv_candidate;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(nonresidue_value__doc__,
"Non Residue Value. Supports single argument so process does not search forever.");

/* Wrapper around the underlying C function */
static PyObject *
py_nonresidue_value(PyObject *self, PyObject *args)
{
   unsigned long nrvresult;
	unsigned int nrv_lim;
	/* "args" signature is long */
	/* ':nonresidue_value' for error messages */
	if (!PyArg_ParseTuple(args, "i:nonresidue_value", &nrv_lim))
		return NULL;

	if (nrv_lim < 2) {
	  return NULL;
	}

	if (nrv_lim < 20) {
	  /* temporary lower limit until nonresidue_value() is enhanced */
	  return NULL;
	}

	nrvresult = nonresidue_value(nrv_lim);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)nrvresult);
}

unsigned long mod_where_multiple_of_1365_in_exponent_longway(unsigned long long exp) {
  /* ft is short for 512th - bit of a stretch but go with it */
  /* gt is the final portion k_minus_one - (511 * ft) */
  /* ft and gt where named before variable 'portions' was introduced
	  and I retain these names */
  mpz_t		FT2K, GT2K;
  mpz_t		FT2K_BOOSTED;
  extern mpz_t		A;
  extern mpz_t		N;
  extern mpz_t		R1, R2, R; 
  extern mpz_t		R_IN_PROGRESS_LIMITED_INPUT;
  extern	mpz_t		R_IN_PROGRESS_LIMITED;
  mpz_t		R_IN_PROGRESS;
  unsigned int multiple_of_1365_multiplier = 0;
  unsigned long long k_minus_one = 1;
  extern unsigned int	debug_flag;
  unsigned long long exp_done = 0;
  unsigned long long ft = 0;
  unsigned long long ft2k = 0;
  unsigned long long gt = 0;
  unsigned long long gt2k = 0;
  int ft2k_plus_gt2k_sign = 0;
  unsigned int portions_boost_marker = 0;
  /* gt2k as int and gt as long long seems like a mismatch - depends on usage */
  unsigned int portion_count = 0;
  unsigned int portions = 1048576;

  unsigned long size10long = 0;

  unsigned long long outR1len = 0;
  char      *outR1;
  char      *outR1tail;
  unsigned long long outR2len = 0;
  char      *outR2;
  char      *outR2tail;

  long clock_mod_where_start = 0;
  long clocks_mod_where = 0;
  long elapsed_secs = 0;

  k_minus_one = exp - 1;
  multiple_of_1365_multiplier = multiple_of_1365 / 1365;

  mpz_powm_ui(R1, A, multiple_of_1365_multiplier, N); /* modulo and 'powers of powers' */
  if (debug_flag > 0) {
	 printf("...longway() multiple_of_1365_multiplier=%d.\n",
			  multiple_of_1365_multiplier);
	 printf("...longway() R1 initialised and populated using (mod N).\n");

	 outR1 = mpz_get_str(NULL,10,R1);
	 outR1len = strlen(outR1);

	 if (outR1len < 81) {
		printf("R1 has %lld decimal digits and" 
				  " in full R1=%s\n",outR1len,outR1);
		fprintf(outfnotes,"exp=%lld gives R1 having %lld decimal digits and"
				  " in full R1=%s\n",exp,outR1len,outR1);
		fflush(outfnotes);
	 } else {
		printf("R1 has %lld decimal digits and ends %s\n",
				 outR1len,&outR1[(outR1len-10)]);

		asprintf(&outR1tail,"%s",&outR1[(outR1len-10)]);
		fprintf(outfnotes,"exp=%lld gives R1 having %lld decimal digits and"
				  " ending %s\n",exp,outR1len,outR1tail);
		fflush(outfnotes);
	 }
  }

  mpz_powm_ui(R2, R1, 1365, N); /* R2 has acounted for original multiple_of_1365 so far */
  if (debug_flag > 0) {
	 printf("...longway() R2 initialised and populated using (mod N).\n");

	 outR2 = mpz_get_str(NULL,10,R2);
	 outR2len = strlen(outR2);

	 if (outR2len < 81) {
		printf("R2 has %lld decimal digits and" 
				  " in full R2=%s\n",outR2len,outR2);
		fprintf(outfnotes,"exp=%lld gives R2 having %lld decimal digits and"
				  " in full R2=%s\n",exp,outR2len,outR2);
		fflush(outfnotes);
	 } else {
		printf("R2 has %lld decimal digits and ends %s\n",
				 outR2len,&outR2[(outR2len-10)]);

		asprintf(&outR2tail,"%s",&outR2[(outR2len-10)]);
		fprintf(outfnotes,"exp=%lld gives R2 having %lld decimal digits and"
				  " ending %s\n",exp,outR2len,outR2tail);
		fflush(outfnotes);
	 }

  }

  if (debug_flag > 0) {
	 printf("k_minus_one has binary size %lld\n",size2longlong(k_minus_one));
  }
  portions = calculate_split_wrapper_longlong(k_minus_one);
  if (debug_flag > 0) {
	 printf("portions now populated and equal to %d.\n",portions);
	 printf("k_minus_one has binary size %lld\n",size2longlong(k_minus_one));
  }
  ft = k_minus_one / portions;
  if (debug_flag > 0) {
	 printf("ft=%lld and known that %lld*%d = %lld.\n",
			  ft,ft,(portions-1),(ft*(portions-1)));
  }
  gt = k_minus_one - ((portions - 1) * ft);
  if (debug_flag > 0) { printf("gt=%lld now (provisionally) populated.\n",gt); }

  portions_boost_marker = portions;
  if ((2*gt) > (3*ft)) {
	 portions_boost_marker = (ft * (gt/ft));
	 if (debug_flag > 0) { 
		printf("portions_boost_marker=%d now populated.\n",
				 portions_boost_marker);
	 }
	 gt = gt - portions_boost_marker;
	 if (debug_flag > 0) {
		printf("gt has been lowered using portions_boost_marker=%d.\n",
			  portions_boost_marker);
	 }
	 portions_boost_marker = portions - portions_boost_marker - 1;
  }
  if (debug_flag > 0) {
	 printf("gt=%lld now populated.\n",gt);
	 printf("portions_boost_marker=%d ... think 'portions complement' - 1\n",
			  portions_boost_marker);
  }

  if (debug_flag > 0 && gt < 1) {
	 printf("gt=%lld meaning adjustment process malfunction!"
			  " Ignore results.\n",gt);
  }

  mpz_init(FT2K);
  mpz_ui_pow_ui(FT2K,2,ft);
  if (mpz_cmp_ui(FT2K,ULLONG_MAX) < 1) {
	 ft2k = pow(2,ft);
  }

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(FT2K,10);
	 if (size10long < 81) {
		gmp_printf("FT2K has size %d and equals %Zd\n",size10long,FT2K);
	 } else {
		printf("FT2K has size %ld\n",size10long);
	 }
  }

  mpz_init(FT2K_BOOSTED);
  mpz_ui_pow_ui(FT2K_BOOSTED,2,(ft+1));

  mpz_init(GT2K);
  mpz_ui_pow_ui(GT2K,2,gt);
  if (mpz_cmp_ui(GT2K,ULLONG_MAX) < 1) {
	 gt2k = pow(2,gt);
  }

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(FT2K,10);
	 if (size10long < 81) {
		gmp_printf("FT2K has size %d and equals %Zd\n",size10long,FT2K);
	 } else {
		printf("FT2K has size %ld\n",size10long);
	 }
  }

  if (ft2k > 0 && gt2k > 0) { ft2k_plus_gt2k_sign = 1; }

  size10long = mpz_sizeinbase(GT2K,10);
  if (debug_flag > 0) { printf("GT2K has size %ld\n",size10long); }

  mpz_init_set(R_IN_PROGRESS,R2);
  gmp_fprintf(outfrinprogress,"R_IN_PROGRESS=R2=%Zd\n",R_IN_PROGRESS);
  fflush(outfrinprogress);

  mpz_init_set(R_IN_PROGRESS_LIMITED_INPUT,R2);
  if (debug_flag > 0) { printf("R_IN_PROGRESS_LIMITED_INPUT=R2\n"); }

  /* because of division and rounding gt may well be significantly
	  larger than ft, so raise to gt should be attempted early */
  /* ensure R_IN_PROGRESS is set before making next function call. */
  mod_where_multiple_of_1365_in_exponent_limited(256,GT2K,gt);
  /* mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, GT2K, N); */

  if (debug_flag > 0) {
	 printf("...longway() continues now after gt2k's processed"
			  " via ...limited()\n");
  }

  mpz_set(R_IN_PROGRESS,R_IN_PROGRESS_LIMITED);
  if (debug_flag > 0) { printf("R_IN_PROGRESS=R_IN_PROGRESS_LIMITED\n"); }

  clock_mod_where_start = clock();
  /* clocks_mod_where = (clock() - clock_mod_where_start); */

  for (portion_count = 1; portion_count <= portions_boost_marker; portion_count++) {
	 clocks_mod_where = (clock() - clock_mod_where_start);
	 elapsed_secs = clocks_mod_where / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("%ld secs - Loop iter with portion_count=%d started.\n",
				 elapsed_secs,portion_count);
	 }
	 mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, FT2K, N); 
	 if (ft2k_plus_gt2k_sign > 0) { exp_done += ft2k; }
	 /*
		 exponent_size = mpz_sizeinbase(HALF_OF_TWO_TO_K,10);
		  gmp_printf("EXPONENT (reduction 1) has size %d\n",exponent_size);
	 */
  }
  
  if (debug_flag > 0) {
	 printf("...longway() exp_done=%lld at point where switch to boosted\n",exp_done);
  }

  for (portion_count = portions_boost_marker + 1; portion_count < portions; portion_count++) {
	 clocks_mod_where = (clock() - clock_mod_where_start);
	 elapsed_secs = clocks_mod_where / CLOCKS_PER_SEC;
	 if (debug_flag > 0) {
		printf("%ld secs - Loop iter (boosted) with portion_count=%d started.\n",
				 elapsed_secs,portion_count);
	 }
	 mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, FT2K_BOOSTED, N); 
	 if (ft2k_plus_gt2k_sign > 0) { exp_done = exp_done + 2*ft2k; }
  }

  if (debug_flag > 0) {
	 printf("...longway() exp_done=%lld after ft2k's processed\n",exp_done);
  }

  mpz_set(R, R_IN_PROGRESS);

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(R,10);
	 printf("...longway() R has size %ld\n",size10long);

  }

  mpz_clear(FT2K);
  mpz_clear(GT2K);
  mpz_clear(FT2K_BOOSTED);
  mpz_clear(R_IN_PROGRESS);
  /* return value for convenience only, see mpz R usually */
  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(mod_where_multiple_of_1365_in_exponent_longway__doc__,
"mod_where_multiple_of_1365_in_exponent with no optimisations");

/* Wrapper around the underlying C function */
static PyObject *
py_mod_where_multiple_of_1365_in_exponent_longway(PyObject *self, PyObject *args)
{
   unsigned long mwresult;
	unsigned long exp_l;
	/* "args" signature is long */
	/* ':mod_where_multiple_of_1365_in_exponent_longway' for error messages */
	if (!PyArg_ParseTuple(args, "l:mod_where_multiple_of_1365_in_exponent_longway", &exp_l))
		return NULL;

	if (exp_l < 2 || exp_l > ULONG_MAX) {
	  return NULL;
	}

	mwresult = \
	  mod_where_multiple_of_1365_in_exponent_longway((unsigned long long)exp_l);

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)mwresult);
}

unsigned long mod_where_multiple_of_1365_in_exponent_loopless(unsigned long long exp) {
  /* ft is short for 512th - bit of a stretch but go with it */
  /* gt is the final portion k_minus_one - (511 * ft) */
  /* ft and gt where named before variable 'portions' was introduced
	  and I retain these names */
  mpz_t		FT2K, GT2K;
  mpz_t		FT2K_BOOSTED;
  mpz_t		FT2K_POWERED;
  extern mpz_t		A;
  extern mpz_t		N;
  extern mpz_t		R1, R2, R; 
  extern mpz_t		R_IN_PROGRESS_LIMITED_INPUT;
  extern	mpz_t		R_IN_PROGRESS_LIMITED;
  mpz_t		R_IN_PROGRESS;
  unsigned int multiple_of_1365_multiplier = 0;
  unsigned long long k_minus_one = 1;
  extern unsigned int	debug_flag;
  unsigned long long exp_done = 0;
  unsigned long long ft = 0;
  unsigned long long ft2k = 0;
  unsigned long long gt = 0;
  unsigned long long gt2k = 0;
  int ft2k_plus_gt2k_sign = 0;
  unsigned int portions_boost_marker = 0;
  /* gt2k as int and gt as long long seems like a mismatch - depends on usage */
  unsigned int portions = 1048576;

  unsigned long size10long = 0;

  unsigned long long outR1len = 0;
  char      *outR1;
  char      *outR1tail;
  unsigned long long outR2len = 0;
  char      *outR2;
  char      *outR2tail;

  long clock_mod_where_start = 0;
  long clocks_mod_where = 0;
  long elapsed_secs = 0;

  k_minus_one = exp - 1;
  multiple_of_1365_multiplier = multiple_of_1365 / 1365;

  mpz_powm_ui(R1, A, multiple_of_1365_multiplier, N); /* modulo and 'powers of powers' */
  if (debug_flag > 0) {
	 printf("...loopless() multiple_of_1365_multiplier=%d.\n",
			  multiple_of_1365_multiplier);
	 printf("...loopless() R1 initialised and populated using (mod N).\n");

	 outR1 = mpz_get_str(NULL,10,R1);
	 outR1len = strlen(outR1);

	 if (outR1len < 81) {
		printf("R1 has %lld decimal digits and" 
				  " in full R1=%s\n",outR1len,outR1);
		fprintf(outfnotes,"exp=%lld gives R1 having %lld decimal digits and"
				  " in full R1=%s\n",exp,outR1len,outR1);
		fflush(outfnotes);
	 } else {
		printf("R1 has %lld decimal digits and ends %s\n",
				 outR1len,&outR1[(outR1len-10)]);

		asprintf(&outR1tail,"%s",&outR1[(outR1len-10)]);
		fprintf(outfnotes,"exp=%lld gives R1 having %lld decimal digits and"
				  " ending %s\n",exp,outR1len,outR1tail);
		fflush(outfnotes);
	 }
  }

  mpz_powm_ui(R2, R1, 1365, N); /* R2 has acounted for original multiple_of_1365 so far */
  if (debug_flag > 0) {
	 printf("...loopless() R2 initialised and populated using (mod N).\n");

	 outR2 = mpz_get_str(NULL,10,R2);
	 outR2len = strlen(outR2);

	 if (outR2len < 81) {
		printf("R2 has %lld decimal digits and" 
				  " in full R2=%s\n",outR2len,outR2);
		fprintf(outfnotes,"exp=%lld gives R2 having %lld decimal digits and"
				  " in full R2=%s\n",exp,outR2len,outR2);
		fflush(outfnotes);
	 } else {
		printf("R2 has %lld decimal digits and ends %s\n",
				 outR2len,&outR2[(outR2len-10)]);

		asprintf(&outR2tail,"%s",&outR2[(outR2len-10)]);
		fprintf(outfnotes,"exp=%lld gives R2 having %lld decimal digits and"
				  " ending %s\n",exp,outR2len,outR2tail);
		fflush(outfnotes);
	 }

  }

  if (debug_flag > 0) {
	 printf("k_minus_one has binary size %lld\n",size2longlong(k_minus_one));
  }
  portions = calculate_split_wrapper_longlong(k_minus_one);
  if (debug_flag > 0) {
	 printf("portions now populated and equal to %d.\n",portions);
	 printf("k_minus_one has binary size %lld\n",size2longlong(k_minus_one));
  }
  ft = k_minus_one / portions;
  if (debug_flag > 0) {
	 printf("ft=%lld and known that %lld*%d = %lld.\n",
			  ft,ft,(portions-1),(ft*(portions-1)));
  }
  gt = k_minus_one - ((portions - 1) * ft);
  if (debug_flag > 0) { printf("gt=%lld now (provisionally) populated.\n",gt); }

  portions_boost_marker = portions;
  if ((2*gt) > (3*ft)) {
	 portions_boost_marker = (ft * (gt/ft));
	 if (debug_flag > 0) { 
		printf("portions_boost_marker=%d now populated.\n",
				 portions_boost_marker);
	 }
	 gt = gt - portions_boost_marker;
	 if (debug_flag > 0) {
		printf("gt has been lowered using portions_boost_marker=%d.\n",
			  portions_boost_marker);
	 }
	 portions_boost_marker = portions - portions_boost_marker - 1;
  }
  if (debug_flag > 0) {
	 printf("gt=%lld now populated.\n",gt);
	 printf("portions_boost_marker=%d ... think 'portions complement' - 1\n",
			  portions_boost_marker);
  }

  if (debug_flag > 0 && gt < 1) {
	 printf("gt=%lld meaning adjustment process malfunction!"
			  " Ignore results.\n",gt);
  }

  mpz_init(FT2K);
  mpz_ui_pow_ui(FT2K,2,ft);
  if (mpz_cmp_ui(FT2K,ULLONG_MAX) < 1) {
	 ft2k = pow(2,ft);
  }

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(FT2K,10);
	 if (size10long < 81) {
		gmp_printf("FT2K has size %d and equals %Zd\n",size10long,FT2K);
	 } else {
		printf("FT2K has size %ld\n",size10long);
	 }
  }

  mpz_init(FT2K_BOOSTED);
  mpz_ui_pow_ui(FT2K_BOOSTED,2,(ft+1));

  mpz_init(GT2K);
  mpz_ui_pow_ui(GT2K,2,gt);
  if (mpz_cmp_ui(GT2K,ULLONG_MAX) < 1) {
	 gt2k = pow(2,gt);
  }

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(FT2K,10);
	 if (size10long < 81) {
		gmp_printf("FT2K has size %d and equals %Zd\n",size10long,FT2K);
	 } else {
		printf("FT2K has size %ld\n",size10long);
	 }
  }

  if (ft2k > 0 && gt2k > 0) { ft2k_plus_gt2k_sign = 1; }

  size10long = mpz_sizeinbase(GT2K,10);
  if (debug_flag > 0) { printf("GT2K has size %ld\n",size10long); }

  mpz_init_set(R_IN_PROGRESS,R2);
  gmp_fprintf(outfrinprogress,"R_IN_PROGRESS=R2=%Zd\n",R_IN_PROGRESS);
  fflush(outfrinprogress);

  mpz_init_set(R_IN_PROGRESS_LIMITED_INPUT,R2);
  if (debug_flag > 0) { printf("R_IN_PROGRESS_LIMITED_INPUT=R2\n"); }

  /* because of division and rounding gt may well be significantly
	  larger than ft, so raise to gt should be attempted early */
  /* ensure R_IN_PROGRESS is set before making next function call. */
  mod_where_multiple_of_1365_in_exponent_limited(256,GT2K,gt);
  /* mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, GT2K, N); */

  if (debug_flag > 0) {
	 printf("...loopless() continues now after gt2k's processed"
			  " via ...limited()\n");
  }

  mpz_set(R_IN_PROGRESS,R_IN_PROGRESS_LIMITED);
  if (debug_flag > 0) { printf("R_IN_PROGRESS=R_IN_PROGRESS_LIMITED\n"); }

  clock_mod_where_start = clock();
  /* clocks_mod_where = (clock() - clock_mod_where_start); */

  mpz_init(FT2K_POWERED);
  /* FT2K_POWERED is set in next line */
  mpz_pow_ui(FT2K_POWERED,FT2K,portions_boost_marker);

 clocks_mod_where = (clock() - clock_mod_where_start);
 elapsed_secs = clocks_mod_where / CLOCKS_PER_SEC;
 if (debug_flag > 0) {
	printf("%ld secs - loopless calc1 started.\n",elapsed_secs);
 }
 mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, FT2K_POWERED, N); 
 if (ft2k_plus_gt2k_sign > 0) { exp_done = exp_done + (ft2k * portions_boost_marker); }
  
  if (debug_flag > 0) {
	 printf("...loopless() exp_done=%lld at point where switch to boosted\n",exp_done);
  }

  /* FT2K_POWERED is set in next line */
  mpz_pow_ui(FT2K_POWERED,FT2K_BOOSTED,(portions - portions_boost_marker - 1));

 clocks_mod_where = (clock() - clock_mod_where_start);
 elapsed_secs = clocks_mod_where / CLOCKS_PER_SEC;
 if (debug_flag > 0) {
	printf("%ld secs - loopless calc2 started.\n",elapsed_secs);
 }
 mpz_powm(R_IN_PROGRESS, R_IN_PROGRESS, FT2K_POWERED, N); 
 if (ft2k_plus_gt2k_sign > 0) {
	exp_done = exp_done + (ft2k * (portions - portions_boost_marker - 1));
 }
  
  if (debug_flag > 0) {
	 printf("...loopless() exp_done=%lld\n",exp_done);
  }

  if (debug_flag > 0) {
	 printf("...loopless() exp_done=%lld after ft2k's processed\n",exp_done);
  }

  mpz_set(R, R_IN_PROGRESS);

  if (debug_flag > 0) {
	 size10long = mpz_sizeinbase(R,10);
	 printf("...loopless() R has size %ld\n",size10long);

  }

  mpz_clear(FT2K);
  mpz_clear(GT2K);
  mpz_clear(FT2K_BOOSTED);
  mpz_clear(R_IN_PROGRESS);
  /* return value for convenience only, see mpz R usually */
  return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(mod_where_multiple_of_1365_in_exponent_loopless__doc__,
"mod_where_multiple_of_1365_in_exponent with no optimisations");

/* Wrapper around the underlying C function */
static PyObject *
py_mod_where_multiple_of_1365_in_exponent_loopless(PyObject *self, PyObject *args)
{
   unsigned long mwresult;
	unsigned long exp_l;
	/* "args" signature is long */
	/* ':mod_where_multiple_of_1365_in_exponent_loopless' for error messages */
	if (!PyArg_ParseTuple(args, "l:mod_where_multiple_of_1365_in_exponent_loopless", &exp_l))
		return NULL;

	if (exp_l < 2 || exp_l > ULONG_MAX) {
	  return NULL;
	}

	mwresult = \
	  mod_where_multiple_of_1365_in_exponent_loopless((unsigned long long)exp_l);

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long)mwresult);
}

unsigned long process_expk(unsigned int e_inc, unsigned int proc_expk_optimisation) {

  /* This function process_expk() was originally designed with concurrency in mind - 
	  multiple calls at the same time were isolated from each other. However as the
	  design progressed, some of the functions called by process_expk() have been
	  rewritten / adapted to a requirement of the gigantic - Never repeat either
	  of the following two operations:

	  (1) Raising number to a very large exponent.
	  (2) As above but in modulo context - perhaps powm function.

	  In order to support this, the functions called by process_exp() may now make use
	  of more global variables, and so, do NOT assume isolation between different calls
	  to process_exp(), without following the call chain thoroughly to check.
  */

  int mod_where_return = -1;
  unsigned long long expk = 1;
  unsigned long long rshift_size10 = 0;
  extern unsigned long long exp_shift_start;
  unsigned long long k_minus_one = 0;
  unsigned int       nonresidue_val;
  unsigned int exponent_size10 = 0;
  unsigned long long size10n = 0;
  unsigned long long size10nmo = 0;
  unsigned long long outD36len = 0;
  extern int process_expk_optimisation;
  extern unsigned int	debug_flag;
  extern unsigned int	simulate_gigantic;

  mpz_t		K;
  mpz_t		TWO_TO_K;
  extern mpz_t HALF_OF_TWO_TO_K;
  mpz_t		NMO, NMO_HALVED;
  extern mpz_t		A;
  extern mpz_t		N;
  extern mpz_t		R1, R2, R; 

  extern const unsigned long NINETYNINEMILLION;

  long clock_nmohalved_start = 0;
  long clocks_nmohalved = 0;
  long elapsed_secs_nmohalved = 0;

  unsigned int printf_rc = -1;

  /* expk = k_minus_one + 1 + e_inc; */
  expk = multiple_of_1365 + exp_shift_start + e_inc;
  mpz_init_set_ui(K,expk);
  k_minus_one = expk - 1;
  if (debug_flag > 0) {
	 printf("e_inc+exp_shift_start+multiple_of_1365=%d+%lld+%ld=%lld.\n",
			  e_inc,exp_shift_start,multiple_of_1365,expk);
  }
  process_expk_optimisation = proc_expk_optimisation;
  mpz_init(HALF_OF_TWO_TO_K);
  mpz_init(TWO_TO_K);
  mpz_ui_pow_ui(HALF_OF_TWO_TO_K,2,k_minus_one);
  mpz_mul_ui(TWO_TO_K,HALF_OF_TWO_TO_K,2);
  mpz_init(NMO);
  mpz_init(N);
  mpz_mul(NMO,TWO_TO_K,MULTIPLE_OF_1365);
  if (debug_flag > 0) {
	 printf("NMO initialised and populated.\n");
	 size10nmo = mpz_sizeinbase(NMO,10);
	 printf("NMO has size %lld\n",size10nmo);
  }

  mpz_add_ui(N,NMO,1);
  size10n = mpz_sizeinbase(N,10);

  if (debug_flag > 0) {
	 printf("N initialised and populated.\n");
	 /*  mpz_init_set_str(N, "41", 10);*/
	 printf("N has size10 of %lld\n",size10n);
  }

  mpz_init(A);  /* A is the nonresidue value which we will raise to a power using EXPONENT */
  nonresidue_val = nonresidue_value(1000);
  mpz_set_ui(A, nonresidue_val);
  /*  mpz_init_set_str(A, "2", 10); */
  if (debug_flag > 0) {
	 printf("A=%d is being used as nonresidue value.\n",nonresidue_val);
  }

  mpz_init(NMO_HALVED);
  if (debug_flag > 0) {
	 printf("NMO_HALVED will be formed next using mpz_mul_ui().\n");
  }
  clock_nmohalved_start = clock();
  mpz_mul_ui(NMO_HALVED,HALF_OF_TWO_TO_K,multiple_of_1365);
  clocks_nmohalved = (clock() - clock_nmohalved_start);
  elapsed_secs_nmohalved = clocks_nmohalved / CLOCKS_PER_SEC;

  fprintf(outfnotes,"process_expk() expk=%lld time for NMO_HALVED forming"
			 " - elapsed secs=%ld\n",expk,elapsed_secs_nmohalved);
  fflush(outfnotes);

  exponent_size10 = mpz_sizeinbase(NMO_HALVED,10);

  if (debug_flag > 0) {
	 printf("process_expk() expk=%lld time for NMO_HALVED forming"
			 " - elapsed secs=%ld\n",expk,elapsed_secs_nmohalved);
	 printf("EXPONENT (original)=NMO_HALVED has size %d\n",exponent_size10);
  }

  gmp_fprintf(outfplanned,
				    "expk=%lld planned processing involves nonresidue A=%Zd\n"
				    "...which is then raised to exponent having %d decimal digits"
				  " labelled NMO_HALVED.\n",
				  expk,A,exponent_size10);
  /*
	   "...which is then raised to exponent %Zd.\n",
		  expk,A,NMO_HALVED);
  */
  fflush(outfplanned);

  if (debug_flag > 0) {
	 printf("EXPONENT (original)=NMO_HALVED summary in .planned file\n");
  }

  printf_rc = asprintf(&ndesc_unlimited,"%lld^2*%ld+1",expk,multiple_of_1365);
  if (-1 == printf_rc) {
    printf("asprintf returned %i\n",printf_rc);
    return 160;
  }

  printf_rc = sprintf(ndesc,"%-30s",ndesc_unlimited);
  if (-1 == printf_rc) {
    printf("sprintf to set ndesc returned %i\n",printf_rc);
    return 160;
  }

  /* next few lines are a very loose attempt to bound things (based
	    on exponent size) so that memory requirements
		 are no more than 4 gig (4096 megabytes */
  if (exponent_size10 > 9999999) {
	 slice_size_max_2exp = 5; /* 6 just too much, 8 way too much */
  }

  if (proc_expk_optimisation < 10) {
	 mod_where_return = mod_where_multiple_of_1365_in_exponent_longway(expk);
	 if (debug_flag > 0) {
		printf("mod_where_multiple_of_1365_in_exponent_longway() completed.\n");
	 }
  } else if (proc_expk_optimisation < 20) {
	 /* optimisation 1 */
	 /* mod_where_return = mod_where_multiple_of_1365_in_exponent(); */
	 mod_where_return = mod_where_multiple_of_1365_in_exponent_loopless(expk);
	 if (debug_flag > 0) {
		printf("mod_where_multiple_of_1365_in_exponent_loopless is processed"
				 " using single optimisations.\n");
	 }
	 /* } else if (size10n > NINETYNINEMILLION || simulate_gigantic > 0) { */
  } else if (proc_expk_optimisation < 30) {
	 /* optimisation 1 */
	 /* optimisation 2 */
	 /* mod_where_return = mod_where_multiple_of_1365_in_exponent(); */
	 mod_where_return = mod_where_multiple_of_1365_in_exponent_chunked(
																		 expk,k_minus_one);
	 if (debug_flag > 0) {
		printf("mod_where_multiple_of_1365_in_exponent_chunked(,) processed"
				 " using both optimisations.\n");
	 }
  } else {
	 /* optimisation 1 */
	 /* optimisation 2 */
	 /* mod_where_return = mod_where_multiple_of_1365_in_exponent(); */
	 mod_where_return = mod_where_multiple_of_1365_in_exponent_chunked2(
																		 expk,k_minus_one);
	 if (debug_flag > 0) {
		printf("mod_where_multiple_of_1365_in_exponent_chunked2(,) processed"
				 " using both optimisations.\n");
	 }
  }

  if (debug_flag > 0) {
	 printf("mod_where_multiple_of_1365_in_exponent_whatever()"
			  " returned %d.\n",mod_where_return);
  }
  fprintf(outfnotes,"mod_where_multiple_of_1365_in_exponent_whatever()"
			 " returned %d.\n",mod_where_return);
  fflush(outfnotes);

  if (mod_where_return != 0) { return mod_where_return; }

  mpz_clear(K);

  mpz_clear(TWO_TO_K);
  mpz_clear(HALF_OF_TWO_TO_K);
  mpz_clear(NMO);
  mpz_clear(NMO_HALVED);
  mpz_clear(N);
  mpz_clear(A);

  return 0;
}


/* Short description of the function (one liner). */
PyDoc_STRVAR(process_expk__doc__,"Process gigantic exponent.");

/* Wrapper around the underlying C function */
static PyObject *
py_process_expk(PyObject *self, PyObject *args)
{
   unsigned long procresult;
	unsigned int exp_inc;
	int p_expk_optimisation = -99;
	extern int process_expk_optimisation;

	/* "args" signature is integer,integer */
	/* ':process_expk' for error messages */
	if (!PyArg_ParseTuple(args, "i|i:process_expk", &exp_inc, &p_expk_optimisation))
		return NULL;

	if (p_expk_optimisation >= 0) {
	  process_expk_optimisation = p_expk_optimisation;
	} else {
	  process_expk_optimisation = 0;
	  /* zero, indicating 'no optimisation' should be set rather
		  than possible undefined value extern might hold currently */
	}

	if (exp_inc < 0) {
	  return NULL;
	}

	procresult = process_expk(exp_inc, p_expk_optimisation);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long)procresult);
}

/* static prefix if you only need to access it directly from python */
static long setz_esl_init(unsigned int m1365,  unsigned long long e_shift_start) {
	extern char      date8tee4 [13];
	extern FILE		*outfexpk;
	extern FILE		*outfout36;
	extern FILE		*outfplanned;
	extern FILE		*outfnotes;
	extern FILE		*outfrinprogress;
	extern FILE		*outfchunkmod;
   extern const unsigned long hundred_million;
   extern const unsigned long thousand_million;
	extern unsigned int	debug_flag;
	extern unsigned long multiple_of_1365;
   extern unsigned long long exp_shift_start;
	extern mpz_t		ONE;
	extern mpz_t		TWO;
	extern mpz_t      HUNDRED_MILLION;
	extern mpz_t		THOUSAND_MILLION;
	extern mpz_t		THIRTEENSIXTYFIVE;
	extern mpz_t		FOURZERONINEFIVE;
	extern mpz_t		FIVEFOURSIXTY;
	extern mpz_t		MULTIPLE_OF_1365; 

   extern mpz_t TWO_TO_TWENTY_SEVEN;
   extern mpz_t TWO_TO_TWENTY_EIGHT;
   extern mpz_t TWO_TO_TWENTY_NINE ;
   extern mpz_t TWO_TO_THIRTY      ;
   extern mpz_t TWO_TO_THIRTY_ONE  ;
   extern mpz_t TWO_TO_THIRTY_TWO  ;
   extern mpz_t TWO_TO_THIRTY_THREE;
   extern mpz_t TWO_TO_THIRTY_FOUR ;
   extern mpz_t TWO_TO_THIRTY_FIVE ;
   extern mpz_t TWO_TO_THIRTY_SIX  ;
   extern mpz_t TWO_TO_THIRTY_SEVEN;
   extern mpz_t TWO_TO_THIRTY_EIGHT;
   extern mpz_t TWO_TO_THIRTY_NINE ;
   extern mpz_t TWO_TO_FOURTY      ;
   extern mpz_t TWO_TO_FOURTY_ONE  ;
   extern mpz_t TWO_TO_FOURTY_TWO  ;
   extern mpz_t TWO_TO_FOURTY_THREE;
   extern mpz_t TWO_TO_FOURTY_FOUR ;
   extern mpz_t TWO_TO_FOURTY_FIVE ;
   extern mpz_t TWO_TO_FOURTY_SIX  ;
   extern mpz_t TWO_TO_FOURTY_SEVEN;
   extern mpz_t TWO_TO_FOURTY_EIGHT;
   extern mpz_t TWO_TO_FOURTY_NINE ;
   extern mpz_t TWO_TO_FIFTY       ;
   extern mpz_t TWO_TO_FIFTY_ONE   ;
   extern mpz_t TWO_TO_FIFTY_TWO   ;
   extern mpz_t TWO_TO_FIFTY_THREE ;
   extern mpz_t TWO_TO_FIFTY_FOUR  ;
   extern mpz_t TWO_TO_FIFTY_FIVE  ;
   extern mpz_t TWO_TO_FIFTY_SIX   ;
   extern mpz_t TWO_TO_FIFTY_SEVEN ;
   extern mpz_t TWO_TO_FIFTY_EIGHT ;
   extern mpz_t TWO_TO_FIFTY_NINE  ;
   extern mpz_t TWO_TO_SIXTY       ;
   extern mpz_t TWO_TO_SIXTY_ONE   ;
   extern mpz_t TWO_TO_SIXTY_TWO   ;
   extern mpz_t TWO_TO_SIXTY_THREE ;

	time_t t;
	struct tm *ltm;

	mpz_init_set_ui(ONE,1);
	mpz_init_set_ui(TWO,2);
	mpz_init_set_ui(HUNDRED_MILLION,hundred_million);
	mpz_init_set_ui(THOUSAND_MILLION,thousand_million);
	mpz_init(TEN_THOUSAND_MILLION);
	mpz_mul_ui(TEN_THOUSAND_MILLION,THOUSAND_MILLION,10);
	mpz_init_set_ui(THIRTEENSIXTYFIVE,1365);
	mpz_init_set_ui(FOURZERONINEFIVE,4095);
	mpz_init_set_ui(FIVEFOURSIXTY,5460);

   mpz_init(TWO_TO_TWENTY_SEVEN);
   mpz_init(TWO_TO_TWENTY_EIGHT);
   mpz_init(TWO_TO_TWENTY_NINE);
   mpz_init(TWO_TO_THIRTY);
   mpz_init(TWO_TO_THIRTY_ONE);
   mpz_init(TWO_TO_THIRTY_TWO);
   mpz_init(TWO_TO_THIRTY_THREE);
   mpz_init(TWO_TO_THIRTY_FOUR);
   mpz_init(TWO_TO_THIRTY_FIVE);
   mpz_init(TWO_TO_THIRTY_SIX);
   mpz_init(TWO_TO_THIRTY_SEVEN);
   mpz_init(TWO_TO_THIRTY_EIGHT);
   mpz_init(TWO_TO_THIRTY_NINE);
   mpz_init(TWO_TO_FOURTY);
   mpz_init(TWO_TO_FOURTY_ONE);
   mpz_init(TWO_TO_FOURTY_TWO);
   mpz_init(TWO_TO_FOURTY_THREE);
   mpz_init(TWO_TO_FOURTY_FOUR);
   mpz_init(TWO_TO_FOURTY_FIVE);
   mpz_init(TWO_TO_FOURTY_SIX);
   mpz_init(TWO_TO_FOURTY_SEVEN);
   mpz_init(TWO_TO_FOURTY_EIGHT);
   mpz_init(TWO_TO_FOURTY_NINE);
   mpz_init(TWO_TO_FIFTY);
   mpz_init(TWO_TO_FIFTY_ONE);
   mpz_init(TWO_TO_FIFTY_TWO);
   mpz_init(TWO_TO_FIFTY_THREE);
   mpz_init(TWO_TO_FIFTY_FOUR);
   mpz_init(TWO_TO_FIFTY_FIVE);
   mpz_init(TWO_TO_FIFTY_SIX);
   mpz_init(TWO_TO_FIFTY_SEVEN);
   mpz_init(TWO_TO_FIFTY_EIGHT);
   mpz_init(TWO_TO_FIFTY_NINE);
   mpz_init(TWO_TO_SIXTY);
   mpz_init(TWO_TO_SIXTY_ONE);
   mpz_init(TWO_TO_SIXTY_TWO);
   mpz_init(TWO_TO_SIXTY_THREE);

   mpz_mul_2exp(TWO_TO_TWENTY_SEVEN,ONE,27);
   mpz_mul_2exp(TWO_TO_TWENTY_EIGHT,ONE,28);
   mpz_mul_2exp(TWO_TO_TWENTY_NINE,ONE,29);
   mpz_mul_2exp(TWO_TO_THIRTY,ONE,30);
   mpz_mul_2exp(TWO_TO_THIRTY_ONE,ONE,31);
   mpz_mul_2exp(TWO_TO_THIRTY_TWO,ONE,32);
   mpz_mul_2exp(TWO_TO_THIRTY_THREE,ONE,33);
   mpz_mul_2exp(TWO_TO_THIRTY_FOUR,ONE,34);
   mpz_mul_2exp(TWO_TO_THIRTY_FIVE,ONE,35);
   mpz_mul_2exp(TWO_TO_THIRTY_SIX,ONE,36);
   mpz_mul_2exp(TWO_TO_THIRTY_SEVEN,ONE,37);
   mpz_mul_2exp(TWO_TO_THIRTY_EIGHT,ONE,38);
   mpz_mul_2exp(TWO_TO_THIRTY_NINE,ONE,39);
   mpz_mul_2exp(TWO_TO_FOURTY,ONE,40);
   mpz_mul_2exp(TWO_TO_FOURTY_ONE,ONE,41);
   mpz_mul_2exp(TWO_TO_FOURTY_TWO,ONE,42);
   mpz_mul_2exp(TWO_TO_FOURTY_THREE,ONE,43);
   mpz_mul_2exp(TWO_TO_FOURTY_FOUR,ONE,44);
   mpz_mul_2exp(TWO_TO_FOURTY_FIVE,ONE,45);
   mpz_mul_2exp(TWO_TO_FOURTY_SIX,ONE,46);
   mpz_mul_2exp(TWO_TO_FOURTY_SEVEN,ONE,47);
   mpz_mul_2exp(TWO_TO_FOURTY_EIGHT,ONE,48);
   mpz_mul_2exp(TWO_TO_FOURTY_NINE,ONE,49);
   mpz_mul_2exp(TWO_TO_FIFTY,ONE,50);
   mpz_mul_2exp(TWO_TO_FIFTY_ONE,ONE,51);
   mpz_mul_2exp(TWO_TO_FIFTY_TWO,ONE,52);
   mpz_mul_2exp(TWO_TO_FIFTY_THREE,ONE,53);
   mpz_mul_2exp(TWO_TO_FIFTY_FOUR,ONE,54);
   mpz_mul_2exp(TWO_TO_FIFTY_FIVE,ONE,55);
   mpz_mul_2exp(TWO_TO_FIFTY_SIX,ONE,56);
   mpz_mul_2exp(TWO_TO_FIFTY_SEVEN,ONE,57);
   mpz_mul_2exp(TWO_TO_FIFTY_EIGHT,ONE,58);
   mpz_mul_2exp(TWO_TO_FIFTY_NINE,ONE,59);
   mpz_mul_2exp(TWO_TO_SIXTY,ONE,60);
   mpz_mul_2exp(TWO_TO_SIXTY_ONE,ONE,61);
   mpz_mul_2exp(TWO_TO_SIXTY_TWO,ONE,62);
   mpz_mul_2exp(TWO_TO_SIXTY_THREE,ONE,63);

	multiple_of_1365 = m1365;
	if (debug_flag > 0) {
	  printf("esl_init() initialisation in progress using"
				" multiple_of_1365=%ld\n",multiple_of_1365);
	}

	exp_shift_start = e_shift_start;

	mpz_init_set_ui(MULTIPLE_OF_1365,multiple_of_1365);
	if (debug_flag > 0) {

	  printf("esl_init() initialisation in progress using"
				" exp_shift_start=%lld\n",exp_shift_start);

	  gmp_printf("esl_init() initialisation in progress using"
					 " MULTIPLE_OF_1365=%Zd\n",MULTIPLE_OF_1365);
	}

	t = time(NULL);
	ltm = localtime(&t);
	strftime(date8tee4, 100, "%Y%m%dT%H%M", ltm);

  asprintf(&fexpk,"%s__%s.expk",outfstem,date8tee4);
  outfexpk = fopen(fexpk,"w");

  asprintf(&fout36,"%s__%s.out36",outfstem,date8tee4);
  outfout36 = fopen(fout36,"w");

  asprintf(&fnotes,"%s__%s.notes",outfstem,date8tee4);
  outfnotes = fopen(fnotes,"w");

  fprintf(outfnotes,"esl_init() initialisation in progress"
			  " using multiple_of_1365=%ld\n",multiple_of_1365);
  fflush(outfnotes);

  asprintf(&fplanned,"%s__%s.planned",outfstem,date8tee4);
  outfplanned = fopen(fplanned,"w");

  asprintf(&frinprogress,"%s__%s.rinprogress",outfstem,date8tee4);
  outfrinprogress = fopen(frinprogress,"w");

  asprintf(&fchunkmod,"%s__%s.chunkmod",outfstem,date8tee4);
  outfchunkmod = fopen(fchunkmod,"w");

	return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(setz_esl_init__doc__,
"Initialisation. Here you would include opening any files that you expect to write to by one/several functions");

/* Wrapper around the underlying C function */
static PyObject *
py_setz_esl_init(PyObject *self, PyObject *args)
{
   long initresult;
	extern unsigned int	debug_flag;
	extern unsigned int	slice_size_max_2exp;
   /* extern unsigned long long exp_shift_start; */
	unsigned int mult1365;
   unsigned long long e_shift_start;
	unsigned int d_flag;
	unsigned int max2exp;
	unsigned int zerosappend = 0;
	/* "args" signature is integer,long then optional
		integer, integer, integer */
	/* ':setz_esl_init' for error messages */
	if (!PyArg_ParseTuple(args, "il|iii:setz_esl_init", &mult1365,
								 &e_shift_start, &d_flag, &max2exp, &zerosappend))
		return NULL;
	
	/* where e_shift_start <= 31000 take this to mean that e_shift_start
		is in fact gigantic, and argument is a shorthand for larger value */
	if (zerosappend > 0) {
	  /* append zeros to the number supplied as an argument */
	  e_shift_start = e_shift_start*pow(10,zerosappend);
	  /* So 3028 as 2nd arg and 6 as 5th argument would see
		  shift_start as 3,028,000,000 which is gigantic.
		  So 30280 as 2nd arg and 5 as 5th argument achieves same  */
	}

	if (d_flag < 1000) {
	  debug_flag = d_flag; /* set extern debug_flag */
	}

	if (max2exp < 1 || max2exp > 10) {
	  return NULL;
	}
	if (max2exp > 0) {
	  slice_size_max_2exp = max2exp; /* set extern slice_size_max_2exp */
	  /* slice_size_max_2exp = 5; 6 just too much, 8 way too much */
	}

	initresult = setz_esl_init(mult1365, e_shift_start);

	/* Convert from a C type to a Python type */	
	return PyInt_FromLong((long) initresult);
}

/* static prefix if you only need to access it directly from python */
static long setz_esl_closedown(void) {
	extern FILE		*outfexpk;
	extern FILE		*outfout36;
	extern FILE		*outfplanned;
	extern FILE		*outfnotes;
	extern FILE		*outfrinprogress;
	extern FILE		*outfchunkmod;
	extern unsigned long multiple_of_1365;
	extern mpz_t		ONE;

	fflush(outfexpk);
	fclose(outfexpk);
	fflush(outfout36);
	fclose(outfout36);
	fflush(outfplanned);
	fclose(outfplanned);
	mpz_clear(ONE);
	fprintf(outfnotes,"esl_closedown() complete for all processing that used multiple_of_1365=%ld\n",
			multiple_of_1365);
	fflush(outfnotes);
	fclose(outfnotes);
	fflush(outfrinprogress);
	fclose(outfrinprogress);
	fflush(outfchunkmod);
	fclose(outfchunkmod);
	return 0;
}

/* Short description of the function (one liner). */
PyDoc_STRVAR(setz_esl_closedown__doc__,
"You might consider this de-initialisation and here you would include closing any files opened during initialisation");

/* Wrapper around the underlying C function */
static PyObject *
py_setz_esl_closedown(PyObject *self, PyObject *args)
{
   long closeresult;
	/* "args" - there are none */
	
	closeresult = setz_esl_closedown();

	/* Convert from a C type to a Python type */
	return PyInt_FromLong((long) closeresult);
}

/* Short description of the extension module (one liner). */
PyDoc_STRVAR(setz_exp_small_to_the_gigantic_unfourgig_support_csv__doc__,
"Utilities for setZ (long) to support A^K where A is small and K is gigantic");

/* List of methods defined in this module.
	2nd argument in each entry should begin py_ */
/* "METH_VARARGS" or "METH_NOARGS" for 3rd argument of each method listed.
	Last entry in the list should be a {NULL, NULL} entry */
static PyMethodDef setz_exp_small_to_the_gigantic_unfourgig_support_csv_methods[] = {
	{"setz_esl_init",  py_setz_esl_init, METH_VARARGS, setz_esl_init__doc__},
	{"setz_esl_closedown",  py_setz_esl_closedown,
	 METH_NOARGS, setz_esl_closedown__doc__},
	{"size2gmp",  py_size2gmp, METH_VARARGS, size2gmp__doc__},
	{"size2longlong",  py_size2longlong, METH_VARARGS, size2longlong__doc__},
	{"a_pow_2exp_limited",  py_a_pow_2exp_limited, METH_VARARGS, a_pow_2exp_limited__doc__},
	{"log_to_base_a_of_n_based_on_size10",  py_log_to_base_a_of_n_based_on_size10,
	 METH_VARARGS, log_to_base_a_of_n_based_on_size10__doc__},
	{"log_to_base_a_of_n_veryapprox",  py_log_to_base_a_of_n_veryapprox,
	 METH_NOARGS, log_to_base_a_of_n_veryapprox__doc__},
	{"chunk_mod_prefix_suffix_outfile",  py_chunk_mod_prefix_suffix_outfile,
	 METH_VARARGS, chunk_mod_prefix_suffix_outfile__doc__},
	{"chunk_mod_prefix_suffix_outfile_size10",  py_chunk_mod_prefix_suffix_outfile_size10,
	 METH_VARARGS, chunk_mod_prefix_suffix_outfile_size10__doc__},
	{"chunk_mod_prefix_suffix_outfile_wrapper",  py_chunk_mod_prefix_suffix_outfile_wrapper,
	 METH_VARARGS, chunk_mod_prefix_suffix_outfile_wrapper__doc__},
	{"chunk_2exp_improve",  py_chunk_2exp_improve,
	 METH_VARARGS, chunk_2exp_improve__doc__},
	{"chunk_2exp_unimprove",  py_chunk_2exp_unimprove,
	 METH_VARARGS, chunk_2exp_unimprove__doc__},
	{"chunk_exp_improve",  py_chunk_exp_improve,
	 METH_VARARGS, chunk_exp_improve__doc__},
	{"chunk_mod_given_chunk_2exp",  py_chunk_mod_given_chunk_2exp,
	 METH_VARARGS, chunk_mod_given_chunk_2exp__doc__},
	{"chunk_2exp_improve_size5",  py_chunk_2exp_improve_size5,
	 METH_VARARGS, chunk_2exp_improve_size5__doc__},
	{"chunk_2exp_improve_size5_range",  py_chunk_2exp_improve_size5_range,
	 METH_VARARGS, chunk_2exp_improve_size5_range__doc__},
	{"r_given_chunk_2exp",  py_r_given_chunk_2exp,
	 METH_VARARGS, r_given_chunk_2exp__doc__},
	{"r_given_chunk_2exp_and_kmo",  py_r_given_chunk_2exp_and_kmo,
	 METH_VARARGS, r_given_chunk_2exp_and_kmo__doc__},
	{"r_given_chunk_2exp_and_kmo_staged",  py_r_given_chunk_2exp_and_kmo_staged,
	 METH_VARARGS, r_given_chunk_2exp_and_kmo_staged__doc__},
	{"r_given_chunk_2exp_low",  py_r_given_chunk_2exp_low,
	 METH_VARARGS, r_given_chunk_2exp_low__doc__},
	{"mod_where_multiple_of_1365_in_exponent_chunked",
	 py_mod_where_multiple_of_1365_in_exponent_chunked, METH_VARARGS,
	 mod_where_multiple_of_1365_in_exponent_chunked__doc__},
	{"mod_where_multiple_of_1365_in_exponent_chunked2",
	 py_mod_where_multiple_of_1365_in_exponent_chunked2, METH_VARARGS,
	 mod_where_multiple_of_1365_in_exponent_chunked2__doc__},
	{"calculate_split",  py_calculate_split, METH_VARARGS, calculate_split__doc__},
	{"calculate_split_wrapper_int",  py_calculate_split_wrapper_int,
	 METH_VARARGS, calculate_split_wrapper_int__doc__},
	{"calculate_split_wrapper_longlong",  py_calculate_split_wrapper_longlong,
	 METH_VARARGS, calculate_split_wrapper_longlong__doc__},
	{"mod_where_multiple_of_1365_in_exponent_limited",
	 py_mod_where_multiple_of_1365_in_exponent_limited,
	 METH_VARARGS, mod_where_multiple_of_1365_in_exponent_limited__doc__},
	{"nonresidue_value", py_nonresidue_value, METH_VARARGS, nonresidue_value__doc__},
	{"mod_where_multiple_of_1365_in_exponent_longway",
	 py_mod_where_multiple_of_1365_in_exponent_longway,
	 METH_VARARGS, mod_where_multiple_of_1365_in_exponent_longway__doc__},
	{"mod_where_multiple_of_1365_in_exponent_loopless",
	 py_mod_where_multiple_of_1365_in_exponent_loopless,
	 METH_VARARGS, mod_where_multiple_of_1365_in_exponent_loopless__doc__},
	{"process_expk", py_process_expk, METH_VARARGS, process_expk__doc__},
	{NULL, NULL}
};

/* For this module "setz_exp_small_to_the_gigantic_unfourgig_support_csv" the api expects
	an initialization function named "initsetz_exp_small_to_the_gigantic_unfourgig_support_csv". */
/* PyMODINIT_FUNC on next line might aid portability */
PyMODINIT_FUNC
initsetz_exp_small_to_the_gigantic_unfourgig_support_csv(void)
{
	Py_InitModule3("setz_exp_small_to_the_gigantic_unfourgig_support_csv", setz_exp_small_to_the_gigantic_unfourgig_support_csv_methods,
                   setz_exp_small_to_the_gigantic_unfourgig_support_csv__doc__);
}


