#!/usr/bin/python -O
""" #!/usr/bin/env python """
#
#    This file is part of primerange.
#
#    primerange is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    primerange is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with primerange.  If not, see <http://www.gnu.org/licenses/>.
#

# (c) 2012 Gary Wright
# http://wrightsolutions.co.uk/contact
# http://identi.ca/gnubyexample
# http://gnumbers.blogspot.com/

import setz_exp_small_to_the_gigantic_unfourgig_support_csv as esl
import time

print "esl.setz_esl_init(1365,453,2,5,0)"
""" 3rd argument > 0 says give me debugging / be verbose """
init_rc = esl.setz_esl_init(1365,453,2,5,0)
print init_rc

""" 5th argument indicates how many zeros to append to 2nd argument.
So (,3028,,,6) says append 6 zeros to 3028 giving 3,028,000,000
exp_shift_start as 3,028,000,000 is gigantic """
""" print esl.setz_esl_init(4095,3028,1,5,6) """

if (init_rc):
    print "Exiting as setz_esl_init() not completed as expected."
    exit(init_rc)

tasctime = time.asctime(time.localtime(None))
print "%(tasctime)s\n%(tasctime)s\n%(tasctime)s\n" % locals()

t1 = time.time()
print "Next operation is esl.process_expk(1,31)"
""" print esl.process_expk(1,0) """
process_rc = esl.process_expk(1,31)
t2 = time.time()
""" print result """
print "...chunked() as C extension", t2-t1
print "process_expk(,) return code =",process_rc

print esl.setz_esl_closedown()

exit(0)
""" print esl.setz_esl_init(4095,30280,1,5) """
""" 2nd argument < 31000 would have 5 zeros appended automatically
by C extension function setz_esl_init(). So 30280 as 2nd arg would
be requesting exp_shift_start as 3,028,000,000 which is gigantic """
