#!/usr/bin/env python
#-*- coding: latin-1 -*-

# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with This program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""Test modules."""

# Remember you can use:
# assert_(condition)
# assertEqual(a, b)
# assertNotEqual(a, b)
# assertRaises(exception, func, *args)
# fail()

import unittest
import helper

class TestHelper(unittest.TestCase):
    """Test module helper."""
    def setUp(self):
        """Run before every test in this class."""
        pass

    def tearOff(self):
        """Run after every test in this class."""
        pass

    def test_add_coords(self):
        self.assertEqual(helper.add_coords('name.ext', 400000, 4250000),
                         'name_400000_4250000.ext')
        self.assertEqual(helper.add_coords('name', 400000, 4250000),
                         'name_400000_4250000')

if __name__ == '__main__':
    unittest.main()

