!
! Test module f90_unix_io
!
!   This file is part of Posix90
!
!   This program is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   This program is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 51 Franklin Street, Fifth Floor,
!   Boston, MA 02110-1301, USA. 
!
!
program f90_unix_io_tst
  use f90_unix_io
  use f90_unix_tools, only : CRLF
  implicit none
  
  type(FILE) :: fp
  character(len=128) :: line
  integer :: linelen, errno

  fp = popen("ls", "r")
  if(.not. associated(fp)) then
     print *, "popen failed."
  end if

1000 continue
  call fgets(line, linelen, fp)
  if(linelen>0) print *, line(1:linelen-1)
  if(linelen>0) go to 1000

  print *, pclose(fp)

  fp = fopen("bla", "r", errno)
  if(.not. associated(fp)) then
     print *, "fopen failed as it should."
     call perror('fopen("bla", "r")');
  end if
  call set_errno
  
  fp = fopen("testfile", "w", errno)
  call check_errno(errno, "fopen")
  call fputs("Teststring"//CRLF, fp, errno)
  call check_errno(errno, "fputs")
  print *, fclose(fp, errno)
  call check_errno(errno, "fclose")

  call fputs("stdio-test"//CRLF, stdout())
  call fputs("Enter string:", stdout())
  call fgets(line, linelen, stdin())
  call fputs('>'//line(1:linelen)//'<', stderr())

contains

  subroutine check_errno(errno, msg)
    integer, intent(in) :: errno
    character(len=*), intent(in) :: msg
    if(errno/=0) then
       call perror(msg, errno)
       stop
    else
       print *, msg//' succeeded'
    endif
  end subroutine check_errno
  
end program f90_unix_io_tst
