!
!
!   This file is part of Posix90
!
!   This program is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   This program is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 51 Franklin Street, Fifth Floor,
!   Boston, MA 02110-1301, USA. 
!
module f90_unix_signal
  use f90_unix_errno
  use f90_unix_tools, only : C0
  implicit none
  include 'f90_unix_signal_const.inc'

  type sigaction_type
     integer(funcp_kind) :: sa_handler
     integer(funcp_kind) :: sa_action
     type(sigset_type) :: sa_mask
     integer :: sa_flags 
  end type sigaction_type
  
contains

  type(sigaction_type) function sigaction_compile(handler)
    interface
       subroutine handler
       end subroutine handler       
    end interface

    call c_sigaction_compile(sigaction_compile%sa_handler, &
         &sigaction_compile%sa_action, sigaction_compile%sa_mask%sigset,&
         &sigaction_compile%sa_flags, handler)
  end function sigaction_compile
  
  subroutine sigaction(signum, action, oldaction)
    integer :: signum
    type(sigaction_type), intent(in) :: action
    type(sigaction_type), intent(out), optional :: oldaction
  end subroutine sigaction
  
end module f90_unix_signal

