#!/usr/bin/ruby

class Token
  ## Constructeur ##
  def initialize(str)
    @str = str
  end

  ## Retourne les urls ##
  def get_urls()
    if @urls
      return @urls
    end

    @urls = Hash.new(0)
    @str.scan(/(https?:\/\/[\w\-\.]+(:\d+)?[\w\~\/\$\-_\.\+!\*\'\(\),\e;:\@&=\?]*)/){|url| 
      @urls[url[0]] += 1
      
    }
    return @urls
  end

  ## Retourne les noms de domaines ##
  def get_domains()
    if @domains
      return @domains
    end
 
    @domains = Hash.new(0)
    #domaines des urls
    @str.scan(/https?:\/\/([\w\-\.]+)/){|domain| 
      @domains[domain[0]] += 1
    }
    #domaines des adresses email
    @str.scan(/@([\w\-\.]+)/){|domain| 
      @domains[domain[0]] += 1
    }
    return @domains
  end

  ## Retourne les tags en les couplant avec leur contenu ##
  def get_tags()
    if @tags
      return @tags
    end
    # @str.tr!('A-Z','a-z')

    @tags = Hash.new(0)
    #supprime les commentaires et les scripts
    @str.gsub!(/<!--((.|\n)*?)-->|<script [^>]+?>((.|\n)*?)\/script>/i,' ')
    

    ## Récupère les tags
      @str.scan(/<[^>]+>/i){|w|
      cut_tag = w.split(/[\s"'<>\\\/+&?:;,.()={}*]+/)
      cut_tag[1].tr!('A-Z','a-z')
      i=2
      while (cut_tag[i+1] and cut_tag[i].length != 0) do
        cut_tag[i].tr!('A-Z','a-z')
        @tags[cut_tag[1]+"_"+cut_tag[i]] += 1
        i+=1
      end
    }
    return @tags
  end

  ## Retourne les mots (hors tags) ##
  def get_words()
    if @words
      return @words
    end

    @words = Hash.new(0)
    @bi_words = Hash.new(0)

    #supprime les tags
    # @str.gsub!(/<[^>]*>/,' ')
    @str.gsub!(/<("[^"]*"|'[^']*'|[^'">])*>/,' ')

    #supprime les espaces
    @str.gsub!('&nbsp;',' ')

    #supprime les caractères spéciaux et les remplace par les équivalents non spéciaux
    #ex:  &eacute; -> e
    #/!\ ne fonctionne pas quand le codage des caractères n'a pas été effectué
    @str.gsub!(/&(\w)\w+;/,'\1')

    #supprime les nombres variables. ex: [6] ou {12} ou (15)
    @str.gsub!(/[\[\{\(]\d+[\]\}\)]/,' ')

    #supprime ponctuation et autres caractères
    @str.gsub!(/[~&"#'\{\(\['_\\\^\)\]°\}¨%\*µ\+=\?\!\,;\.\/:]/,' ')

    #découpe la chaîne suivant les tokens et les place dans le hash
    #on crée ici les mots et bi-mots
    precedent=nil
    @str.split(/[\s]+/).each {|token|
      if (token.length>2)
      @words[token] += 1
      end
      if (precedent != nil) 
        @bi_words[precedent+"_"+token] += 1
      end
      precedent = token
    }
    return @words
  end

  ## Retourne les bi-mots ##
  def get_biwords()
    if @bi_words
      return @bi_words
    end

    get_words()
    return @bi_words
  end

  ## Retourne un hash contenant le tous les autres ##
  def get_all()
    if @all
      return @all
    end

    get_urls()
    get_domains()
    get_tags()
    get_words()
    get_biwords()

    @all             = Hash.new
    # @all['urls']     = Hash.new(0)
    # @all['domains']  = Hash.new(0)
    # @all['tags']     = Hash.new(0)
    # @all['words']    = Hash.new(0)
    # @all['bi-words'] = Hash.new(0)
    
    @urls.keys.each{|w|
      # @all['urls'][w] = @domains[w]
      @all['url:'+w] = @urls[w]
    }    
    @domains.keys.each{|w|
      # @all['domains'][w] = @domains[w]
      @all['domain:'+w] = @domains[w] 
    }
    @tags.keys.each{|w|
      # @all['tags'][w] = @domains[w]
      @all['tag:'+w] = @tags[w]
    }
    @words.keys.each{|w|
      # @all['words'][w] = @domains[w]
      @all['word:'+w] = @words[w]
    }
    @bi_words.keys.each{|w|
      # @all['bi-words'][w] = @domains[w]
      @all['bi-word:'+w] = @bi_words[w] 
    }
    return @all
  end

end
