class Perceptron
  attr_writer :w
  attr_reader :w
  def initialize(nb)
    if nb.class == Fixnum
	    @w=[]
	    for i in 0..nb
	      @w[i]=rand-0.5
	    end
    elsif nb.class == Array
    	    @w=nb
    else
    	raise 'Type Error in constructor'
    end
  end
  
  def output(tab)
    res=@w[-1]
    for i in 0..tab.length-1
      res += @w[i]*tab[i]
    end
    return 1/(1+Math.exp(-res))
  end
end

class Neural
  def initialize(nb_input, nb_hidden, nb_output)
    @nb_input = nb_input
    @nb_hidden = nb_hidden
    @nb_output = nb_output
    @hidden = Array.new @nb_hidden
    @output = Array.new @nb_output
    @res_h = []
    @res_o = []
    for i in 0..@nb_hidden-1
      @hidden[i] = Perceptron.new @nb_input
    end
    for i in 0..@nb_output-1
      @output[i] = Perceptron.new @nb_hidden
    end
    @dw_h = []
    @dw_o = []
    for i in 0..@nb_hidden-1
      @dw_h << []
      for j in 0..@nb_input-1
	@dw_h[i][j] = 0
      end
    end
    for i in 0..@nb_output-1
      @dw_o << []
      for j in 0..@nb_hidden-1
	@dw_o[i][j] = 0
      end
    end
  end
  def load(file)
    f = File.open(file,'r')
    @nb_input, @nb_hidden, @nb_output = f.gets.split(/ /).map{|x| x.to_i}
    @hidden = Array.new @nb_hidden
    @output = Array.new @nb_output
    @res_h = []
    @res_o = []
    for i in 0..@nb_hidden-1
    	@hidden[i] = Perceptron.new f.gets.split(/ /).map{|x| x.to_i}
    end
    for i in 0..@nb_output-1
    	@output[i] = Perceptron.new f.gets.split(/ /).map{|x| x.to_i}
    end
  end
  def save(file)
    f = File.open(file,'w')
    f.puts [@nb_input,@nb_hidden,@nb_output]*' '
    for v in @hidden
      f.puts v.w*' '
    end
    for v in @output
      f.puts v.w*' '
    end
  end
  def work(data)
    raise "error of dim\n" if data.length != @nb_input
    for i in 0..@nb_hidden-1
      @res_h[i] = @hidden[i].output data
    end
    for i in 0..@nb_output-1
      @res_o[i] = @output[i].output @res_h
    end
    return @res_o
  end
  
  def learn(data,output,epsilon=0.1,alpha=0.99)
    raise "error of dim\n" if data.length != @nb_input or output.length != @nb_output
    work(data)
    error = 0.0
    for i in 0..@nb_output-1
      error += (@res_o[i]-output[i])*(@res_o[i]-output[i])
    end
    delta_o = []
    for i in 0..@nb_output-1
      delta_o[i] = @res_o[i]*(1-@res_o[i])*(output[i]-@res_o[i])
    end
    sum = 0
    delta_h = []
    for i in 0..@nb_hidden-1
      sum = 0
      for k in 0..@nb_output-1
	sum += delta_o[k]*@output[k].w[i]
      end
      delta_h[i] = @res_h[i]*(1-@res_h[i])*sum
    end
    for i in 0..@nb_output-1
      for j in 0..@nb_hidden-1
	@dw_o[i][j] = epsilon*delta_o[i]*@res_h[j]+alpha*@dw_o[i][j]
	@output[i].w[j] += @dw_o[i][j]
#	 @output[i].w[j] += epsilon*delta_o[i]*@res_h[j]
      end
    end
    for i in 0..@nb_hidden-1
      for j in 0..@nb_input-1
	@dw_h[i][j] = epsilon*delta_h[i]*data[j]+alpha*@dw_h[i][j]
	@hidden[i].w[j] += @dw_h[i][j]
#	 @hidden[i].w[j] += epsilon*delta_h[i]*data[j]
      end
    end
  return error
  end
end


#n = Neural.new (2,10,1)
#for i in 0..1000
 # p n.learn ([0,1],[1])
#  p n.learn ([1,1],[0])
#  p n.learn ([1,0],[1])
#  p n.learn ([0,0],[0])
#end

#p n.work [0,0]
#p n.work [1,0]
#p n.work [0,1]
#p n.work [1,1]

