#!/usr/bin/ruby

require 'bdb'

class Hashdb
  ## Constructeur ##
  def initialize(nom_fichier, droits)
    @db_name  = nom_fichier
    @flags    = droits
    @database = BDB::Hash::open(@db_name, nil, @flags)
    @nbporn   = 0
    @nbnporn  = 0
  end

  ## Retourne le score correspondant à un token ##
  def getScore(token)
    if @database.get(token) != nil
      return to_int(@database.get(token))
    end
    return 0,0
  end

  ## Retourne le nombre total d'entrées porn et non porn ##
  def getTotal()
    h = getHash()
    h.keys.each{|w|
      # @nbporn,@nbnporn = @nbporn + getScore(w)[0], @nbnporn + getScore(w)[1]
      @nbporn,@nbnporn = @nbporn + to_int(h[w])[0], @nbnporn + to_int(h[w])[1]
    }
    return @nbporn, @nbnporn
  end

  ## Met à jour un token dans la base ##
  def updateToken(token, score)
    prev_score = getScore(token)
    new_scorep,newscorenp   = prev_score[0]+score[0],prev_score[1]+score[1]
    @database.store(token, to_hash(new_scorep, newscorenp))
  end

  ## Met à jour tout un hash dans la base ## 
  def updateHash(hash,isporn)
    score = [0, 0]
    hash.keys.each{|w|
      token = w 
      if isporn=="true"
        score[0] = hash[w]
      else
        score[1] = hash[w]
      end
      updateToken(token, score)
    }    
    if isporn=="true"
      updateToken("~~nombre-pages~~", [1, 0])
    else
      updateToken("~~nombre-pages~~", [0, 1])
    end
  end

  ## Crée un nouveau token dans la base ##
  def createToken(token)
    @database.store(token, to_hash(0,0))
  end

  ## Efface une entrée de la base ##
  def delete(token)
    @database.delete(token)
  end

  ## Retourne le nombre de pages porn et non porn
  def getNumberPages()
    return to_int(@database.get("~~nombre-pages~~"))
  end

  ## Retourne le hash correspondant à la base ## 
  def getHash()
    return @database.to_hash
  end

  ## conversion en hexa ##
  def to_bin(nb)
    res="  "
    res[0],res[1] = nb / 256, nb % 256
    return res
  end

  ## inversion poids fort poids faible et conversion hexa ##
  def to_hash (n1,n2)
    return to_bin(n1) + to_bin(n2)
  end
  
  ## conversion hexa --> string ##
  def to_int(str)
    return [str[0]*256+str[1],str[2]*256+str[3]]
  end

end


