#ifndef CUT_H
#define CUT_H

#include <gmp.h>
#include <mpfr.h>

/* initializes variables for scoring*/
void score_initScoring(void);

/* return 1 if porn 0 if not*/
void score_getProbability(int verbose);

/* return the inverse chi square function with df degrees of liberty */
mpfr_t* score_getChi2(double chi, unsigned int df);

/* return the number of occurences of the token in the page */
unsigned int* score_getScore(char *token);

/* stores the token in the temporary database */
void score_storeToken(char *token, int type);

/* closes the temporary database */
void score_closedb(void);

/* print a mpfr_t variable on the output */
void print_mpfr(char *string, mpfr_t var);

/* functions to sort arrays for display */
void triRapide(double *t,int debut, int fin, int *tind);
void partitionner(double *t, int debut, int fin, int *pPosition, int *tind);
void echanger(double *px, double *py);
void echangerInt(int *px, int *py);

#endif
