#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "main.h"
#include "lex.yy.h"
#include "store.h"
#include "score.h"

/**
* Retrieve execution options and start the program.
* @param argc
* @param argv
*/
int main (int argc, char **argv)
{
  int qflag = 0;
  int lflag = 0;
  int sflag = 0;
  int pflag = 0;
  int nflag = 0;
  int iflag = 0;
  int fflag = 0;
  int dflag = 0;
  int bflag = 0;
  int vflag = 0;

  char *fvalue = NULL,*dvalue = NULL, *bvalue = NULL;
  int c;

  opterr = 0;

  while ((c = getopt (argc, argv, "qhlsnpivef:d:b:")) != -1)
    switch (c)
      {
      case 'h':
        display_help();
        exit(0);
        break;
      case 'q':
        qflag = 1;
        break;
      case 'l':
	/* -l: option for learning database */
	lflag = 1;
	break;
      case 's':
	/* -s option for calculating the score of a page */
	sflag = 1;
	break;
      case 'n':
	/* -n option for non porn page(s) */
        nflag = 1;
        break;
      case 'p':
	/* -p option for porn page(s) */
        pflag = 1;
        break;
      case 'i':
	/* -i option to parse the standard input */
        iflag = 1;
        break;
      case 'v':
	/* -v option for simple verbose mode (for scoring) */
        vflag = 1;
        break;
      case 'e':
	/* -e option for complex verbose mode (for scoring) */
        vflag = 2;
        break;
      case 'f':
	/* -f option to parse one page */
	fflag = 1;
        fvalue = optarg;
        break;
      case 'd':
	/* -d option to parse a directory */
	dflag = 1;
        dvalue = optarg;
        break;
      case 'b':
	/* -b option to indicate database name and location */
	bflag = 1;
        bvalue = optarg;
        break;
      case '?':
        if (isprint (optopt))
          fprintf (stderr, "Unknown option `-%c'.\n", optopt);
        else
          fprintf (stderr,
                   "Unknown option character `\\x%x'.\n",
                   optopt);
        return 1;
      default:
        abort ();
      }

  /* Catching errors */
  if(sflag==0 && lflag==0 && qflag==0){
    fprintf(stderr, "you have to choose between -s -l or -q options");
    exit(0);
  }
  if(sflag==1 && lflag==1 && qflag==1){
    fprintf(stderr, "you can't choose both options -s -l and -q");
    exit(0);
  }
  if(fflag==1 && dflag==1 &&iflag==1){
    fprintf(stderr, "you can't choose both options -f -d and -i");
    exit(0);
  }
  if(nflag==1 && pflag==1 && lflag==1){
    fprintf(stderr, "you can't choose both options -n and -p for learning");
    exit(0);
  }
  if((nflag == 1 || pflag ==1) && lflag ==0){
    fprintf(stderr, "you don't to choose options -n or -p for scoring");
    exit(0);
  }
  if(fflag==0 && dflag==0 && iflag==0 && qflag==0){
    fprintf(stderr, "you have to choose between option -f, -d, - or q\n");
    exit(0);
  }
  if(bflag == 0){
    fprintf(stderr, "you have to indicate the database name with -b option\n");
    exit(0);
  }

  /* Dealing with options */
  if(qflag==1) {
    store_opendb(bvalue);
    store_displayTokens();
    store_closedb();
  }
  if(fflag==1) parse_file(fvalue, pflag, sflag, bvalue, vflag);
  if(dflag==1) parse_dir(dvalue, pflag, sflag, bvalue, vflag);
  if(iflag==1) parse_standard_input(stdin, pflag, sflag, bvalue, vflag);

  return 0;
}

/**
* Launch the lexer for one file.
* @param file the location and name of the file to parse
* @param isporn (1 = "is porn", 0 = "is not porn")
* @param isscoring (1 = "is scoring", 0 = "is learning")
* @param dbname location and name of the database to use
* @param verbose level of verbose mode (-e and -v options)
*/
void parse_file(char *file, int isporn, int isscoring, char *dbname, int verbose)
{
  if(!isscoring) {
    store_opendbs(dbname);
  }else{
    store_opendb(dbname);
  }
  FILE *fp = fopen(file,"r");
  init_parsing(fp, isporn, isscoring, verbose);
  fclose(fp);
  store_closedb();
}

/**
* Launch the lexer for one directory.
* @param directory the location and name of the directory to parse
* @param isporn (1 = "is porn", 0 = "is not porn")
* @param isscoring (1 = "is scoring", 0 = "is learning")
* @param dbname location and name of the database to use
* @param verbose level of verbose mode (-e and -v options)
*/
void parse_dir(char *directory, int isporn, int isscoring, char *dbname, int verbose)
{
  struct dirent **files;
  char *nom_fichier;
  nom_fichier = (char*)malloc(sizeof(char)*500);
  strcpy(nom_fichier, directory);

  int nbpages = scandir(nom_fichier,
			&files,
			0,
			alphasort);
  if(!isscoring) {
    store_opendbs(dbname);
  }else{
    store_opendb(dbname);
  }
 
  nbpages--;
  while (nbpages != 0){
    if(strcmp(files[nbpages]->d_name, ".") !=0 && strcmp(files[nbpages]->d_name, "..") != 0){
      strcpy(nom_fichier,directory);
      strcat(nom_fichier, files[nbpages]->d_name);
      printf("%-50s.....%d\n", nom_fichier, nbpages);
      FILE *fp = fopen(nom_fichier,"r");
      init_parsing(fp, isporn, isscoring, verbose);
      fclose(fp);
    }
      nbpages--;
  }
  
  store_closedb();
}

/**
* Launch the lexer for the standard input.
* @param stdinput the FILE read on the standard input
* @param isporn (1 = "is porn", 0 = "is not porn")
* @param isscoring (1 = "is scoring", 0 = "is learning")
* @param dbname location and name of the database to use
* @param verbose level of verbose mode (-e and -v options)
*/
void parse_standard_input(FILE *stdinput, int isporn, int isscoring, char *dbname, int verbose)
{
  if(!isscoring) {
    store_opendbs(dbname);
  }else{
    store_opendb(dbname);
  }
  init_parsing(stdinput, isporn, isscoring, verbose);
  store_closedb();
}

/**
* Display help for execution options
*/
void display_help()
{
  printf(" choose between -s(scoring) and -l(learning) options\n");
  printf(" choose between -f[file] or -d[directory] or -i options (file, directory or standard input)\n");
  printf(" with -b option indicate the database location and name\n");
  printf(" -n indicates non porn pages for learning \n");
  printf(" -p indicates porn pages for learning \n");

  printf(" -v will display some information for scoring \n");
  printf(" -e will display more information for scoring \n");
  printf(" -q will display all the tokens stored in the database\n");
  printf(" -h will display this message \n");
  printf("\n example : ./tokenize -s -f ./index.html -b database.db -v\n");
  printf(" will launch scoring for \"index.html\" using database.db and will display some statistics\n");
  printf("\n example : ./tokenize -l -n -f ./index.html -b database.db \n");
  printf(" will tokenize and store the tokens from the non porn page \"index.html\" in database.db wich will be created if doesn't exist\n");
  printf("\n example : ./tokenize -q -b database.db > db.txt\n");
  printf(" will display all the tokens present in the database and redirect the standard output to the file \"db.txt\"\n");
}

