#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "store.h"
#include "score.h"
#include "cut.h"

char *precedent=NULL;

/**
* Cut the words found thanks to flex and store them (words and biwords) in a temporary database (for scoring or learning).
* @param token the token to cut and store.
* @param isporn (1 = is porn 0 = is not porn)
* @param isscoring (1 = is scoring 0 = is learning)
*/
void cut_words(char *token, int isporn, int isscoring)
{
  char *separateurs = { "-=<>/\"'.{}*+,?:;|()_ " };
  char *data=NULL, *toStore=NULL;
  
  data = malloc(sizeof(char)*(strlen(token)+1));
  data = strtok( token, separateurs );
  
  if( data != NULL){
    if(strlen(data)>0 && strlen(data)<25){
      if (isscoring) score_storeToken(data, WORDS);
	else store_storeTempToken(data, WORDS);
      if(precedent != NULL){
	toStore = malloc(sizeof(char)*(strlen(precedent)+strlen(data)+2));
	strcpy(toStore, precedent);
	strcat(toStore, "_");
	strcat(toStore, data); 
	if (isscoring) score_storeToken(toStore, BIWORDS);
	  else store_storeTempToken(toStore, BIWORDS);
	free(toStore);
	toStore=NULL;
	free(precedent);
	precedent=NULL;
      }
      precedent = malloc(sizeof(char)*(strlen(data)+1));
      strcpy(precedent, data);
    }
  }
  while( data != NULL ) {
    data = strtok( NULL, separateurs );
    if( data != NULL){
      if(strlen(data)>0 && strlen(data)<25){
	if (isscoring) score_storeToken(data, WORDS);
	  else store_storeTempToken(data, WORDS);
	if (precedent != NULL ) {
	  toStore = malloc(sizeof(char)*(strlen(precedent)+strlen(data)+2));
	  strcpy(toStore, precedent);
	  strcat(toStore, "_");
	  strcat(toStore, data);
	  if (isscoring) score_storeToken(toStore, BIWORDS);
	    else store_storeTempToken(toStore, BIWORDS);
	  free(toStore);
	  toStore=NULL;
	  free(precedent);
	  precedent = NULL;
	}
	precedent = malloc(sizeof(char)*(strlen(data)+1));
	strcpy(precedent, data);
      }      
    }    
  }

  if (data != NULL) {free(data); data = NULL;}
  if (toStore != NULL) {free(toStore); toStore = NULL;}
}
 
/**
* Cut the tags found thanks to flex and store them in the temporary database (for scoring or learning).
* @param token the token to cut and store.
* @param isporn (1 = "is porn", 0 = "is not porn")
* @param isscoring (1 = "is scoring", 0 = "is learning")
*/ 
void cut_tags(char *token, int isporn, int isscoring)
{
  char *separateurs = { "\\-=<>/\"'.{}*+,?:;|()_ \n" };
  char *data=NULL, *first=NULL, *toStore=NULL;
  int i;  

  for (i=0; i<strlen(token)+1; i++) {
    token[i] = tolower(token[i]);
  }

  data = malloc(sizeof(char)*(strlen(token)+1));
  data = strtok( token, separateurs );
  
  //if(strlen(data)<20){
  if( data != NULL){
    //if(strlen(data)>0 && strlen(data)<40){
    if(strlen(data)<20){
 	first = malloc(sizeof(char)*(strlen(data)+1));
    	strcpy(first, data);
    	if (isscoring) score_storeToken(first, TAGS);
        else store_storeTempToken(first, TAGS);
    }else first="";
  }
  while( data != NULL) {
    data = strtok( NULL, separateurs );
    if( data != NULL){
      //if(strlen(data)>0 && strlen(data)<40){
	if(strlen(data)<20){
	toStore = malloc(sizeof(char)*(strlen(data)+strlen(first)+2));
      	strcpy(toStore, first);
        strcat(toStore, "_");
        strcat(toStore, data);
        if(isscoring) score_storeToken(toStore, TAGS);
	else store_storeTempToken(toStore, TAGS);
      }    
    }
  }
  //}
  if (data != NULL) {free(data); data=NULL;}
  if (first != NULL) {free(first); first=NULL;}
  if (toStore != NULL) {free(toStore); toStore=NULL;}
}

/*
* Free the global variable "precedent" 
*/
void cut_free(void)
{
  if(precedent != NULL){free(precedent); precedent=NULL;}
}

