##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################

package PlccNet;

use strict;

use Data::Dumper;
use LWP::UserAgent;
use Plcc::PlccGlobal;
use Plcc::PlccLogger;
use HTML::Entities;
use HTTP::Date;

my $lastModified = undef;

# Rcupre un backend, le parse, et retourne les posts dans un hachage 
# d'enregistrements ( ID, TIME, INFO, LOGIN, MESSAGE )
sub refreshBackend
{
	$PlccLogger::logger->debug("Debut");

	my $backend_url = $PlccGlobal::backend_url;
	$PlccLogger::logger->debug("Backend : $backend_url");
	my $ua = $PlccGlobal::myUA;

	my ($backend, $code, $message);

	# Create a user agent object
  my $UserAgent = LWP::UserAgent->new;
  $UserAgent->agent($ua);
	$UserAgent->proxy(['http'] => $PlccGlobal::base_url);

  # Create a request
  my $req = HTTP::Request->new( GET => $backend_url );
	$req->header('If-Modified-Since', $lastModified);
	$req->proxy_authorization_basic( $PlccGlobal::proxyUser, $PlccGlobal::proxyPass );

	$PlccLogger::logger->debug("Requte envoye : ".Dumper($req));

	# Pass request to the user agent and get a response back
  my $res = $UserAgent->request($req);
	( $code, $message, $backend) = ( $res->code, $res->message, $res->content );

	# Rcupration du Last-Modified
	$lastModified = $res->header('Last-Modified') if ( $code != 304 );

	$PlccLogger::logger->info("Rcupration du backend : ($code) $message");
	$PlccLogger::logger->debug("Contenu du backend $backend");

	# On teste pas le code retour, mais le coeur y est

	# On dcoupe le backend en messages
	my @post=split("<post", $backend);
	
	my %tribune;

	foreach my $p (@post)
	{
		$PlccLogger::logger->debug("Un post : $p");
	
		my ($time, $id, $info, $message, $login, $bidon );
		# Un coup de regexp ( Note : s => . gre le \n )
		if (	($time, $id, $info, $message, $bidon, $login ) = ( $p =~ m/time="(\d*)"\s+?id="(\d*)">\s+?<info>(.*?)<\/info>\s+?<message>(.*?)<\/message>\s+?(<login>(.*?)<\/login>\s+?)?<\/post>/s ) )
		{
			# Nettoyage du <!-- REALURL --> de daCode
			$message =~ s/<!-- REALURL -->//g ;
			$message =~ s/<!-- \/REALURL -->//g ;

			# Kapaute  slip pour templite : c'est n'imp, 
			# mais a marchera dans la plupart des cas
			$message =~ s/&amp;lt;/&lt;/g;
			$message =~ s/&amp;gt;/&gt;/g;
			$message =~ s/&lt;span style=&quot;text-decoration: line-through&quot;&gt;(.*?)&lt;\/span&gt;/<s>$1<\/s>/g;
			$message =~ s/&lt;span style=&quot;text-decoration: underline&quot;&gt;(.*?)&lt;\/span&gt;/<u>$1<\/u>/g;

			my $rec = {
				ID => $id,
				TIME => $time,
				INFO => $info,
				LOGIN => $login,
				MESSAGE => $message 
			};
			# Ajout dans le hachage
#			$tribune{ $id."@".$PlccGlobal::nomTribune } = $rec;
			$tribune{ $id } = $rec;
		}		
	}

	$PlccLogger::logger->debug("Fin");
	return %tribune;
}

sub post
{
	$PlccLogger::logger->debug("Debut");

	my ($message) = @_;
	my $ua = $PlccGlobal::myUA;
	my $post_param = $PlccGlobal::post_param;
	my $post_url = $PlccGlobal::post_url;
	
	$PlccLogger::logger->debug("post_url : $post_url");
	$PlccLogger::logger->debug("cookies : $PlccGlobal::cookies");

	# Create a user agent object
  my $UserAgent = LWP::UserAgent->new;
  $UserAgent->agent($ua);
	$post_param =~ s/%s/$message/;

  # Create a request
  my $req = HTTP::Request->new(POST => $post_url );
  $req->content_type('application/x-www-form-urlencoded');
  $req->content( $post_param );
	$req->header("Cookie" => $PlccGlobal::cookies) if defined $PlccGlobal::cookies; 
	$req->referer( $PlccGlobal::referer );

	$PlccLogger::logger->debug("Requte envoye : ".Dumper($req));

  # Pass request to the user agent and get a response back
  my $res = $UserAgent->request($req);
	my ( $code, $mess, $content) = ( $res->code, $res->message, $res->content );
	
	$PlccLogger::logger->info("Postage : ($code) $message");
	$PlccLogger::logger->debug("Contenu du rsultat $content");
	
	$PlccLogger::logger->debug("Fin");
}

# Chargement ok
1;
