/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SERVER_H
#define SERVER_H

#include "game.h"
#include "main.h"

class CClient;

class CServer : public CGame
{
public:
	CServer(void);
	~CServer(void);
	
	void AddBot(const std::string &team,const std::string &plane);
	
	void Init(void);
	bool Update(double time);
	bool Process(const std::string &command,const std::string &data="");

private:
	struct addr_t
	{
		sockaddr_storage	addr;
		socklen_t			len;

		inline int cmp(const addr_t &a) const
		{
			if(len != a.len) return (len - a.len);
			else return std::memcmp(&addr,&a.addr,len);
		}

		inline bool operator== (const addr_t &a) const {return (cmp(a) == 0);}
		inline bool operator!= (const addr_t &a) const {return (cmp(a) != 0);}
		inline bool operator< (const addr_t &a) const {return (cmp(a) < 0);}
		inline bool operator<= (const addr_t &a) const {return (cmp(a) <= 0);}
		inline bool operator> (const addr_t &a) const {return (cmp(a) > 0);}
		inline bool operator>= (const addr_t &a) const {return (cmp(a) >= 0);}
	};
	
	struct client_t
	{
		SOCKET		sock;				// Socket de la connexion de flux
		int			nPlayer;			// Numro de joueur
		int			nEntity;			// Numro de l'entite controlle
		double		lastRecvStamp;		// dernier stamp reu
		double		lastAckStamp;		// dernier stamp accus
		double		lastRecvLocalStamp;	// stamp local de la dernire rception
		double		latency;			// latence moyenne
		std::string recvLine;			// ligne de texte en cours de rception

		int			flags;				// drapeaux de status

		std::string name,team,plane;	// donnes
	};

	#define CLIENT_DGRAM	0x01
	
	bool Process(client_t &client,const std::string &command,const std::string &data="");
	
	typedef std::map<addr_t,client_t> ClientsMap_t;
	ClientsMap_t mClients;
	client_t mLocalClient;

	SOCKET		mSockStream,mSockDgram;
	double		mCurrentStamp;
	double		mSendCooldown;
	int			mLastPlayer;

	int			mNextBot;
};

typedef CSmartPtr<CServer> pServer;

#endif
