/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#define VERSION_MAJOR 0
#define VERSION_MINOR 5
#define VERSION_BUILD 2

#define NET_PORT		"6000"	// port UDP et TCP
#define NET_UPDATERATE	20		// frequence d'envoi
#define NET_BUFFERSIZE	4096	// taille du tampon rseau

//#define DEBUG
#define _HAS_ITERATOR_DEBUGGING 0

#include "paulo3d.h"

#include <vector>
#include <string>
#include <sstream>
#include <queue>
#include <sstream>

#if defined(_WIN32) || defined(_WIN64)

// Patch dgueu pour les headers windows
#ifdef APIENTRY
#undef APIENTRY
#endif
#ifdef WINGDIAPI
#undef WINGDIAPI
#endif
#define TRUE 1
#define FALSE 0
// Fin du patch dgueu

#include <winsock2.h>
#include <ws2tcpip.h>

#undef min
#undef max

#define ioctl ioctlsocket
#define close closesocket
#define sockerrno WSAGetLastError()
#define EWOULDBLOCK	WSAEWOULDBLOCK
#define EADDRINUSE	WSAEADDRINUSE
typedef SOCKADDR sockaddr;
typedef int socklen_t;
typedef u_long ctl_t;

#else

#include <errno.h>
#include <unistd.h> 
#include <stdlib.h>
#include <memory.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define sockerrno errno
#define INVALID_SOCKET -1
typedef int SOCKET;
typedef int ctl_t;

#endif

class buffer_t : public std::vector<char>
{
public:
	buffer_t(char *data=NULL,int size=0)
	{
		_offset = 0;
		assign(data,data+size);
	}

	~buffer_t(void) {}

	inline size_t left(void) const {return std::vector<char>::size()-_offset;}
	inline const char *ptr(void) const {return &(*this)[0];}
	inline size_t offset(void) const {return _offset;}
	inline void offset(size_t pos) {_offset = pos;}
	
	inline void readData(char *p,int size)
	{
		while(size--) *p++ = at(_offset++);
	}

	inline void writeData(const char *p,int size)
	{
		while(size--) push_back(*p++);
	}

	// Les templates d'extraction de variables
	template<typename T> void read(T &data)
	{
		readData(reinterpret_cast<char*>(&data),sizeof(data));
	}

	template<typename T> void write(const T &data)
	{
		writeData(reinterpret_cast<const char*>(&data),sizeof(data));
	}

	// Lecture de variables
	inline uint8_t		readInt8(void)		{ uint8_t value; read(value); return value; }
	inline uint16_t		readInt16(void)		{ uint16_t value; read(value); return value; }
	inline uint32_t		readInt32(void)		{ uint32_t value; read(value); return value; }
	inline float32_t	readFloat32(void)	{ float32_t value; read(value); return value; }
	inline double		readTime(void)		{ uint32_t value; read(value); return double(value)*0.001; }
	
	inline std::string readString(void)
	{
		std::string str;
		char chr;
		while((chr=readInt8())!='\0') str+=chr;
		return str;
	}
	
	// Ecriture de variables
	inline void	writeInt8(uint8_t value) 		{ write(value); }
	inline void	writeInt16(uint16_t value)		{ write(value); }
	inline void	writeInt32(uint32_t value)		{ write(value); }
	inline void	writeFloat32(float32_t value)	{ write(value); }
	inline void	writeTime(double value)			{ write(uint32_t(value*1000.)); }
	
	inline void writeString(const std::string &str)
	{
		writeData(str.data(),str.size());
		writeInt8('\0');
	}

private:
	size_t _offset;
};

#endif // MAIN_H

