/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef CLIENT_H
#define CLIENT_H

#include "game.h"
#include "main.h"

class CClient : public CGame
{
public:
	CClient(const std::string &host);
	~CClient(void);
	
	bool Update(double time);
	bool Process(const std::string &command,const std::string &data="");

protected:
	SOCKET 					mSockStream, mSockDgram;
	std::string				mRecvLine;
	int						mLocalEntity;
	double					mCurrentStamp,mLastRecvStamp,mLastAckStamp,mLastRecvLocalStamp;
	double					mLatency;
	double					mSendCooldown;
};

typedef CSmartPtr<CClient> pClient;

#endif
