/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef BULLET_H
#define BULLET_H

#include "netentity.h"
#include "main.h"

class CBullet : public CEntity
{
public:
	CBullet(	pNetEntity owner,
				double latency,
				const CCoord3 &position,
				const CVector3 &velocity);
	~CBullet(void);

	bool Update(double time);
	
	// Scripts
	virtual void Parameter(const std::string &param,const std::string &data);

private:
	pNetEntity	mOwner;
	CVector3	mStartPosition;
	CVector3	mStartVelocity;
	double		mStamp;
	double		mLeft;

	float	mRadius;
	float	mDamage;
};

typedef CSmartPtr<CBullet> pBullet;

#endif
