/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "bullet.h"
#include "netentity.h"
#include "game.h"

extern pGame Game;

CBullet::CBullet(pNetEntity owner,double latency,const CVector3 &position,const CVector3 &velocity)
{
	mOwner = owner;
	mStartPosition = position;
	mStartVelocity = velocity;
	mDamage = 10.f;
	mStamp = latency;

	mLeft = -1.f;
	mRadius = 1.f;
	setLife(10.f);

	Translate(position);
	Rotate(velocity);
}

CBullet::~CBullet(void)
{

}

void CBullet::Parameter(const std::string &param,const std::string &data)
{
	std::stringstream sdata(data);

	if(param == "damage")				sdata>>mDamage;
	else if(param == "radius")			sdata>>mRadius;
	else CEntity::Parameter(param,data);
}

bool CBullet::Update(double time)
{	
	CCoord3 pos = getLocalMatrix().getTranslation();
	
	if(mLeft < 0.)
	{
		mLeft = Game->mTerrainObject->Intersection(mStartPosition,mStartVelocity*getLife(),mRadius,NULL)*getLife();
		if(mLeft<0.f) mLeft = std::numeric_limits<float>::infinity();
	}
	
	mStamp += time;
	mLeft-=time;
	
	if(mLeft <= 0.)
	{
		pEntity impact = new CEntity("fx/impact.p3d");
		impact->Translate(pos+mStartVelocity*mLeft);
		impact->Attach(getFather());
		return false;
	}
	
	CCoord3 realpos = mStartPosition + mStartVelocity*mStamp;
	double timeshift = CNetEntity::getTimeShift(realpos);

	double localstamp = std::max(mStamp - timeshift,mStamp/10.f);
	CCoord3 newpos = mStartPosition + mStartVelocity*localstamp;

	CVector3 move = newpos-pos;

	float tmin = std::numeric_limits<float>::infinity();
	pNetEntity nearest = NULL;
	// TODO: fonctions d'accs
	for(CGame::NetEntitiesMap_t::iterator it=Game->mNetEntities.begin(); it!=Game->mNetEntities.end(); ++it)
	{
		if(it->second == mOwner) continue;

		float t = it->second->Intersection(pos,move,mRadius,NULL);
		if(t>=0.f && t<=tmin)
		{
			tmin = t;
			nearest = it->second;
		}
	}

	if(tmin<=1.f)
	{
		nearest->BulletResponse(mOwner,mDamage,pos+move*tmin,move);
		return false;
	}

	Identity();
	Translate(pos+move);
	Rotate(move);
	return CEntity::Update(time);
}
