/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Transformation matricielle
inline CVector3 CVector3::operator*(const CMatrix4 &m) const
{ 
	return m.Transform(*this);
}

inline CVector3 &CVector3::operator*=(const CMatrix4 &m)
{ 
	(*this)=m.Transform(*this);
	return (*this);
}

// Produit Vectoriel
inline CVector3 CVector3::Crosspoint(const CVector3 &v) const
{
	CVector3 result;
	result.x=y*v.z-z*v.y;
	result.y=z*v.x-x*v.z;
	result.z=x*v.y-y*v.x;
	return result;
}

// Produit Scalaire
inline float CVector3::Dotpoint(const CVector3 &v) const
{ 
	return x*v.x + y*v.y + z*v.z;
}

// Retourne la longueur du vecteur
inline float CVector3::Norm() const
{
	return std::sqrt(Dotpoint(*this));
}

// Retourne la longueur du vecteur au carr (vite un sqrt)
inline float CVector3::Norm2() const
{
	return Dotpoint(*this);
}

// Normalise le vecteur
inline CVector3 &CVector3::Normalize(void)
{
	float norm = Norm();
	// REM: pas d'exception
	if(norm > std::numeric_limits<float>::epsilon()) (*this)/=norm;
	return *this;
}

// Distance entre 2 points
inline float CVector3::Distance(const CVector3& p) const
{
	return std::sqrt(sqr(p.x-x)+sqr(p.y-y)+sqr(p.z-z));
}

// Distance entre 2 points au carr
inline float CVector3::Distance2(const CVector3& p) const
{
	return sqr(p.x-x)+sqr(p.y-y)+sqr(p.z-z);
}

// Interpolation linaire
inline CVector3 CVector3::Lerp(const CVector3 &v,float t) const
{
	return (*this)+(v-(*this))*t;
}

inline bool CVector3::isInBox(const CCoord3 &p1,const CCoord3 &p2) const
{
	if(x>=p1.x && x<=p2.x && y>=p1.y && y<=p2.y && z>=p1.z && z<=p2.z) return true;
	else return false;
}

// cast en const float*
inline CVector3::operator const float*() const
{
    return &x;
}

// cast en float*
inline CVector3::operator float*()
{
    return &x;
}
