/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "texture.h"

// Constructeur
CTexture::CTexture(pImage image)
{
	// Gnration d'une nouvelle texture
	glGenTextures(1,&mTexNbr);
	
	if(image!=NULL)
	{
		mTarget=GL_TEXTURE_2D;
		glBindTexture(mTarget,mTexNbr);
		image->BuildTexture(mTarget);
	}
}

// Destructeur
CTexture::~CTexture(void)
{
	glDeleteTextures(1,&mTexNbr);
}

// Rendu de l'image
void CTexture::Bind(GLint wrap)
{	
	glEnable(mTarget);				// Active les textures
	glBindTexture(mTarget, mTexNbr);	// Selectionne la texture

	glTexParameteri(mTarget, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(mTarget, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameteri(mTarget, GL_TEXTURE_WRAP_S, wrap);
	glTexParameteri(mTarget, GL_TEXTURE_WRAP_T, wrap);
}

void CTexture::Unbind(void)
{
	glDisable(mTarget);
}
